/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public class WebReactiveFeign {
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(WebClient webClient) {
        return new Builder(webClient);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected WebClient webClient;

        protected Builder() {
            this(WebClient.create());
        }

        protected Builder(WebClient webClient) {
            this.setWebClient(webClient);
            this.options(new ReactiveOptions.Builder().setConnectTimeoutMillis(5000L).setReadTimeoutMillis(10000L).build());
        }

        public Builder<T> options(ReactiveOptions options) {
            if (!options.isEmpty()) {
                ReactorClientHttpConnector connector = new ReactorClientHttpConnector(opts -> {
                    if (options.getConnectTimeoutMillis() != null) {
                        opts.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeoutMillis().intValue());
                    }
                    if (options.getReadTimeoutMillis() != null) {
                        opts.afterNettyContextInit(ctx -> ctx.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(options.getReadTimeoutMillis().longValue(), TimeUnit.MILLISECONDS)));
                    }
                    if (options.isTryUseCompression() != null) {
                        opts.compression(options.isTryUseCompression().booleanValue());
                    }
                });
                this.setWebClient(this.webClient.mutate().clientConnector((ClientHttpConnector)connector).build());
            }
            return this;
        }

        protected void setWebClient(WebClient webClient) {
            this.webClient = webClient;
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, webClient));
        }
    }
}

