/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import com.netflix.client.ClientFactory;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.spring.config.ReactiveFeignClientFactoryBean;
import reactivefeign.spring.config.ReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignContext;

public class ReactiveFeignRibbonConfigurator
implements ReactiveFeignConfigurator {
    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder reactiveFeignBuilder, ReactiveFeignClientFactoryBean factory, ReactiveFeignContext context) {
        if (!(reactiveFeignBuilder instanceof CloudReactiveFeign.Builder)) {
            throw new IllegalArgumentException("CloudReactiveFeign.Builder expected");
        }
        CloudReactiveFeign.Builder cloudBuilder = (CloudReactiveFeign.Builder)reactiveFeignBuilder;
        String clientName = factory.getName();
        LoadBalancerCommandFactory balancerCommandFactory = (LoadBalancerCommandFactory)context.getInstance(clientName, LoadBalancerCommandFactory.class);
        if (balancerCommandFactory == null) {
            SpringClientFactory springClientFactory = (SpringClientFactory)context.getInstance(clientName, SpringClientFactory.class);
            balancerCommandFactory = serviceName -> {
                ILoadBalancer namedLoadBalancer;
                DefaultClientConfigImpl clientConfig;
                if (springClientFactory != null) {
                    clientConfig = springClientFactory.getClientConfig(clientName);
                    namedLoadBalancer = springClientFactory.getLoadBalancer(clientName);
                } else {
                    clientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)clientName);
                    namedLoadBalancer = ClientFactory.getNamedLoadBalancer((String)clientName);
                }
                RetryHandler retryHandler = this.getOrInstantiateRetryHandler(context, clientName, (IClientConfig)clientConfig);
                return LoadBalancerCommand.builder().withLoadBalancer(namedLoadBalancer).withRetryHandler(retryHandler).withClientConfig((IClientConfig)clientConfig).build();
            };
        }
        cloudBuilder = cloudBuilder.setLoadBalancerCommandFactory(balancerCommandFactory);
        return cloudBuilder;
    }

    private RetryHandler getOrInstantiateRetryHandler(ReactiveFeignContext context, String clientName, IClientConfig clientConfig) {
        RetryHandler retryHandler = (RetryHandler)context.getInstance(clientName, RetryHandler.class);
        if (retryHandler == null) {
            retryHandler = new DefaultLoadBalancerRetryHandler(clientConfig);
        }
        return retryHandler;
    }
}

