/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import feign.Contract;
import java.time.Clock;
import org.eclipse.jetty.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.client.log.DefaultReactiveLogger;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.metrics.MicrometerReactiveLogger;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.java11.Java11ReactiveFeign;
import reactivefeign.jetty.JettyHttpClientFactory;
import reactivefeign.jetty.JettyReactiveFeign;
import reactivefeign.spring.config.ReactiveFeignHystrixConfigurator;
import reactivefeign.spring.config.ReactiveFeignRibbonConfigurator;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveFeign;

@Configuration
public class ReactiveFeignClientsConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Contract reactiveFeignContract() {
        return new SpringMvcContract();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    @ConditionalOnProperty(name={"reactive.feign.metrics.enabled"}, havingValue="true")
    public MicrometerReactiveLogger metricsReactiveLogger() {
        return MicrometerReactiveLogger.basicTimer();
    }

    @Bean
    @ConditionalOnMissingBean(ignoredType={"reactivefeign.client.metrics.MicrometerReactiveLogger"})
    @ConditionalOnProperty(name={"reactive.feign.logger.enabled"}, havingValue="true")
    public ReactiveLoggerListener reactiveLogger() {
        return new DefaultReactiveLogger(Clock.systemUTC());
    }

    @Configuration
    @AutoConfigureAfter(value={ReactiveFeignConfiguration.class})
    @ConditionalOnClass(value={HystrixCommand.class, LoadBalancerCommand.class, CloudReactiveFeign.class})
    @ConditionalOnProperty(name={"reactive.feign.cloud.enabled"}, havingValue="true", matchIfMissing=true)
    protected static class ReactiveFeignCloudConfiguration {
        protected ReactiveFeignCloudConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.hystrix.enabled"}, havingValue="true", matchIfMissing=true)
        public ReactiveFeignHystrixConfigurator reactiveFeignHystrixConfigurator() {
            return new ReactiveFeignHystrixConfigurator();
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.ribbon.enabled"}, havingValue="true", matchIfMissing=true)
        public ReactiveFeignRibbonConfigurator reactiveFeignRibbonConfigurator() {
            return new ReactiveFeignRibbonConfigurator();
        }

        @Bean
        @Primary
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        public CloudReactiveFeign.Builder reactiveFeignCloudBuilder(ReactiveFeignBuilder reactiveFeignBuilder, @Value(value="${reactive.feign.hystrix.enabled:true}") boolean enableHystrix, @Value(value="${reactive.feign.ribbon.enabled:true}") boolean enableLoadBalancer) {
            CloudReactiveFeign.Builder cloudBuilder = CloudReactiveFeign.builder((ReactiveFeignBuilder)reactiveFeignBuilder);
            if (enableLoadBalancer) {
                cloudBuilder = cloudBuilder.enableLoadBalancer();
            }
            if (!enableHystrix) {
                cloudBuilder = cloudBuilder.disableHystrix();
            }
            return cloudBuilder;
        }
    }

    @Configuration
    protected static class ReactiveFeignConfiguration {
        protected ReactiveFeignConfiguration() {
        }

        @Configuration
        @ConditionalOnClass(value={WebReactiveFeign.class, WebClient.class})
        @ConditionalOnProperty(name={"reactive.feign.jetty", "reactive.feign.java11"}, havingValue="false", matchIfMissing=true)
        protected static class ReactiveFeignWebConfiguration {
            protected ReactiveFeignWebConfiguration() {
            }

            @Bean
            @Scope(value="prototype")
            public ReactiveFeignBuilder reactiveFeignBuilder(WebClient.Builder builder, @Autowired(required=false) WebClientFeignCustomizer webClientCustomizer) {
                return webClientCustomizer != null ? WebReactiveFeign.builder((WebClient.Builder)builder, (WebClientFeignCustomizer)webClientCustomizer) : WebReactiveFeign.builder((WebClient.Builder)builder);
            }
        }

        @Configuration
        @ConditionalOnClass(value={Java11ReactiveFeign.class, java.net.http.HttpClient.class})
        @ConditionalOnProperty(name={"reactive.feign.java11"}, havingValue="true")
        protected static class ReactiveFeignJava11Configuration {
            protected ReactiveFeignJava11Configuration() {
            }

            @Bean
            @Scope(value="prototype")
            public ReactiveFeignBuilder reactiveFeignBuilder() {
                return Java11ReactiveFeign.builder();
            }
        }

        @Configuration
        @ConditionalOnClass(value={JettyReactiveFeign.class, HttpClient.class})
        @ConditionalOnProperty(name={"reactive.feign.jetty"}, havingValue="true")
        protected static class ReactiveFeignJettyConfiguration {
            protected ReactiveFeignJettyConfiguration() {
            }

            @Bean
            @Scope(value="prototype")
            public ReactiveFeignBuilder reactiveFeignBuilder(JettyHttpClientFactory jettyHttpClientFactory) {
                return JettyReactiveFeign.builder((JettyHttpClientFactory)jettyHttpClientFactory);
            }
        }
    }
}

