/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import feign.Contract;
import feign.codec.ErrorDecoder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.spring.config.ReactiveFeignClientProperties;
import reactivefeign.spring.config.ReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignContext;

class ReactiveFeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private String name;
    private String url;
    private String path;
    private boolean decode404;
    private ApplicationContext applicationContext;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;

    ReactiveFeignClientFactoryBean() {
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    protected ReactiveFeignBuilder reactiveFeign(ReactiveFeignContext context) {
        ReactiveFeignBuilder builder = this.get(context, ReactiveFeignBuilder.class).contract(this.get(context, Contract.class));
        builder = this.configureReactiveFeign(context, builder);
        return builder;
    }

    protected ReactiveFeignBuilder configureReactiveFeign(ReactiveFeignContext context, ReactiveFeignBuilder builder) {
        ReactiveFeignClientProperties properties = (ReactiveFeignClientProperties)this.applicationContext.getBean(ReactiveFeignClientProperties.class);
        if (properties != null) {
            Map config = properties.getConfig();
            if (properties.isDefaultToProperties()) {
                this.configureUsingConfiguration(context, builder);
                this.configureUsingProperties(config.get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(config.get(this.name), builder);
            } else {
                this.configureUsingProperties(config.get(properties.getDefaultConfig()), builder);
                this.configureUsingProperties(config.get(this.name), builder);
                this.configureUsingConfiguration(context, builder);
            }
        } else {
            this.configureUsingConfiguration(context, builder);
        }
        for (ReactiveFeignConfigurator configurator : this.getAll(context, ReactiveFeignConfigurator.class).values()) {
            builder = configurator.configure(builder, this, context);
        }
        return builder;
    }

    protected void configureUsingConfiguration(ReactiveFeignContext context, ReactiveFeignBuilder builder) {
        ReactiveLoggerListener logger;
        ErrorDecoder errorDecoder;
        ReactiveStatusHandler statusHandler;
        Map requestInterceptors;
        ReactiveRetryPolicy retryer;
        ReactiveOptions options = this.getOptional(context, ReactiveOptions.class);
        if (options != null) {
            builder.options(options);
        }
        if ((retryer = this.getOptional(context, ReactiveRetryPolicy.class)) != null) {
            builder.retryWhen(retryer);
        }
        if ((requestInterceptors = context.getInstances(this.name, ReactiveHttpRequestInterceptor.class)) != null) {
            for (ReactiveHttpRequestInterceptor interceptor : requestInterceptors.values()) {
                builder.addRequestInterceptor(interceptor);
            }
        }
        if ((statusHandler = this.getOptional(context, ReactiveStatusHandler.class)) == null && (errorDecoder = this.getOptional(context, ErrorDecoder.class)) != null) {
            statusHandler = ReactiveStatusHandlers.errorDecoder((ErrorDecoder)errorDecoder);
        }
        if (statusHandler != null) {
            builder.statusHandler(statusHandler);
        }
        if ((logger = this.getOptional(context, ReactiveLoggerListener.class)) != null) {
            builder.addLoggerListener(logger);
        }
        if (this.decode404) {
            builder.decode404();
        }
    }

    protected void configureUsingProperties(ReactiveFeignClientProperties.ReactiveFeignClientConfiguration<?> config, ReactiveFeignBuilder builder) {
        if (config == null) {
            return;
        }
        Object optionsBuilder = config.getOptions();
        if (optionsBuilder != null) {
            builder.options(optionsBuilder.build());
        }
        if (config.getRetry() != null) {
            ReactiveRetryPolicy retryPolicy = null;
            if (config.getRetry().getPolicy() != null) {
                retryPolicy = this.getOrInstantiate(config.getRetry().getPolicy());
            }
            if (retryPolicy == null) {
                ReactiveRetryPolicy.Builder builder2 = this.getOrInstantiate(config.getRetry().getBuilder(), config.getRetry().getArgs());
                retryPolicy = builder2.build();
            }
            if (retryPolicy != null) {
                builder.retryWhen(retryPolicy);
            }
        }
        if (config.getRequestInterceptors() != null && !config.getRequestInterceptors().isEmpty()) {
            for (Class clazz : config.getRequestInterceptors()) {
                ReactiveHttpRequestInterceptor interceptor = (ReactiveHttpRequestInterceptor)this.getOrInstantiate(clazz);
                builder.addRequestInterceptor(interceptor);
            }
        }
        if (config.getStatusHandler() != null) {
            ReactiveStatusHandler statusHandler = this.getOrInstantiate(config.getStatusHandler());
            builder.statusHandler(statusHandler);
        } else if (config.getErrorDecoder() != null) {
            ErrorDecoder errorDecoder = this.getOrInstantiate(config.getErrorDecoder());
            builder.statusHandler(ReactiveStatusHandlers.errorDecoder((ErrorDecoder)errorDecoder));
        }
        if (config.getLogger() != null) {
            builder.addLoggerListener(this.getOrInstantiate(config.getLogger()));
        }
        if (config.getDecode404() != null && config.getDecode404().booleanValue()) {
            builder.decode404();
        }
        if (Objects.nonNull(config.getContract())) {
            builder.contract(this.getOrInstantiate(config.getContract()));
        }
    }

    private <T> T getOrInstantiate(Class<T> tClass) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)BeanUtils.instantiateClass(tClass);
        }
    }

    private <T> T getOrInstantiate(Class<T> tClass, Map args) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            Object bean = BeanUtils.instantiateClass(tClass);
            if (args != null && !args.isEmpty()) {
                DataBinder dataBinder = new DataBinder(bean);
                dataBinder.bind((PropertyValues)new MutablePropertyValues(args));
                return (T)dataBinder.getTarget();
            }
            return (T)bean;
        }
    }

    protected <T> T get(ReactiveFeignContext context, Class<T> type) {
        Object instance = context.getInstance(this.name, type);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.name);
        }
        return (T)instance;
    }

    protected <T> Map<String, T> getAll(ReactiveFeignContext context, Class<T> type) {
        Map instances = context.getInstances(this.name, type);
        return instances != null ? instances : Collections.emptyMap();
    }

    protected <T> T getOptional(ReactiveFeignContext context, Class<T> type) {
        return (T)context.getInstance(this.name, type);
    }

    protected ReactiveFeignBuilder loadBalance(ReactiveFeignBuilder<?> builder, ReactiveFeignContext context) {
        return builder;
    }

    public Object getObject() throws Exception {
        return this.getTarget();
    }

    private <T> T getTarget() {
        String url;
        ReactiveFeignContext context = (ReactiveFeignContext)((Object)this.applicationContext.getBean(ReactiveFeignContext.class));
        ReactiveFeignBuilder builder = this.reactiveFeign(context);
        if (!StringUtils.hasText((String)this.url)) {
            url = !this.name.startsWith("http") ? "http://" + this.name : this.name;
            builder = this.loadBalance(builder, context);
        } else {
            url = !this.url.startsWith("http") ? "http://" + this.url : this.url;
        }
        url = url + this.cleanPath();
        builder = this.fallback(context, builder);
        return (T)builder.target(this.type, url);
    }

    private <T> ReactiveFeignBuilder fallback(ReactiveFeignContext context, ReactiveFeignBuilder builder) {
        if (this.fallback != Void.TYPE) {
            Object fallbackInstance = this.getFromContext("fallback", this.getName(), context, this.fallback, this.type);
            builder = builder.fallback(fallbackInstance);
        }
        if (this.fallbackFactory != Void.TYPE) {
            FallbackFactory fallbackFactoryInstance = this.getFromContext("fallbackFactory", this.getName(), context, this.fallbackFactory, FallbackFactory.class);
            Object exampleFallback = fallbackFactoryInstance.apply((Object)new RuntimeException());
            Assert.notNull((Object)exampleFallback, (String)String.format("Incompatible fallbackFactory instance for feign client %s. Factory may not produce null!", this.getName()));
            if (!this.type.isAssignableFrom(exampleFallback.getClass())) {
                throw new IllegalStateException(String.format("Incompatible fallbackFactory instance for feign client %s. Factory produces instances of '%s', but should produce instances of '%s'", this.getName(), exampleFallback.getClass(), this.type));
            }
            builder = builder.fallbackFactory(fallbackFactoryInstance);
        }
        return builder;
    }

    private <T> T getFromContext(String fallbackMechanism, String feignClientName, ReactiveFeignContext context, Class<?> beanType, Class<T> targetType) {
        Object fallbackInstance = context.getInstance(feignClientName, beanType);
        if (fallbackInstance == null) {
            throw new IllegalStateException(String.format("No " + fallbackMechanism + " instance of type %s found for feign client %s", beanType, feignClientName));
        }
        if (!targetType.isAssignableFrom(beanType)) {
            throw new IllegalStateException(String.format("Incompatible " + fallbackMechanism + " instance. Fallback/fallbackFactory of type %s is not assignable to %s for feign client %s", beanType, targetType, feignClientName));
        }
        return (T)fallbackInstance;
    }

    private String cleanPath() {
        String path = this.path.trim();
        if (StringUtils.hasLength((String)path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDecode404() {
        return this.decode404;
    }

    public void setDecode404(boolean decode404) {
        this.decode404 = decode404;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactiveFeignClientFactoryBean that = (ReactiveFeignClientFactoryBean)o;
        return Objects.equals(this.applicationContext, that.applicationContext) && this.decode404 == that.decode404 && Objects.equals(this.fallback, that.fallback) && Objects.equals(this.fallbackFactory, that.fallbackFactory) && Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.applicationContext, this.decode404, this.fallback, this.fallbackFactory, this.name, this.path, this.type, this.url);
    }

    public String toString() {
        return "ReactiveFeignClientFactoryBean{" + "type=" + this.type + ", " + "name='" + this.name + "', " + "url='" + this.url + "', " + "path='" + this.path + "', " + "decode404=" + this.decode404 + ", " + "applicationContext=" + this.applicationContext + ", " + "fallback=" + this.fallback + ", " + "fallbackFactory=" + this.fallbackFactory + "}";
    }
}

