/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx2;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.FluxPublisherHttpClient;
import reactivefeign.publisher.MonoPublisherHttpClient;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.rx2.Rx2Contract;
import reactivefeign.rx2.client.statushandler.Rx2ReactiveStatusHandler;
import reactivefeign.rx2.client.statushandler.Rx2StatusHandler;
import reactivefeign.rx2.methodhandler.Rx2MethodHandlerFactory;
import reactivefeign.utils.FeignUtils;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveFeign;
import reactivefeign.webclient.client.WebReactiveHttpClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Rx2ReactiveFeign {
    private Rx2ReactiveFeign() {
    }

    public static <T> Builder<T> builder() {
        return new Builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends WebReactiveFeign.Builder<T> {
        private BackpressureStrategy backpressureStrategy;

        protected Builder(WebClient.Builder webClientBuilder) {
            super(webClientBuilder);
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            super(webClientBuilder, webClientCustomizer);
        }

        public void setBackpressureStrategy(BackpressureStrategy backpressureStrategy) {
            this.backpressureStrategy = backpressureStrategy;
        }

        public MethodHandlerFactory buildReactiveMethodHandlerFactory(PublisherClientFactory publisherClientFactory) {
            return new Rx2MethodHandlerFactory(publisherClientFactory, this.backpressureStrategy);
        }

        public Builder<T> contract(Contract contract) {
            this.contract = new Rx2Contract(contract);
            return this;
        }

        public Builder<T> addRequestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            super.addRequestInterceptor(requestInterceptor);
            return this;
        }

        public Builder<T> decode404() {
            super.decode404();
            return this;
        }

        public Builder<T> statusHandler(Rx2StatusHandler statusHandler) {
            super.statusHandler((ReactiveStatusHandler)new Rx2ReactiveStatusHandler(statusHandler));
            return this;
        }

        public Builder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            super.retryWhen(retryPolicy);
            return this;
        }

        public Builder<T> options(ReactiveOptions options) {
            super.options(options);
            return this;
        }

        protected PublisherHttpClient toPublisher(ReactiveHttpClient reactiveHttpClient, MethodMetadata methodMetadata) {
            Class returnType = FeignUtils.returnPublisherType((MethodMetadata)methodMetadata);
            if (returnType == Single.class || returnType == Maybe.class) {
                return new MonoPublisherHttpClient(reactiveHttpClient);
            }
            if (returnType == Flowable.class || returnType == Observable.class) {
                return new FluxPublisherHttpClient(reactiveHttpClient);
            }
            throw new IllegalArgumentException("Unknown returnType: " + returnType);
        }

        protected void updateClientFactory() {
            this.clientFactory(methodMetadata -> this.webClient(methodMetadata, this.webClientBuilder.build()));
        }

        public WebReactiveHttpClient webClient(MethodMetadata methodMetadata, WebClient webClient) {
            Type returnType = methodMetadata.returnType();
            Type returnPublisherType = ((ParameterizedType)returnType).getRawType();
            ParameterizedTypeReference returnActualType = ParameterizedTypeReference.forType((Type)Util.resolveLastTypeParameter((Type)returnType, (Class)((Class)returnPublisherType)));
            ParameterizedTypeReference bodyActualType = Optional.ofNullable(FeignUtils.getBodyActualType((Type)methodMetadata.bodyType())).map(type -> ParameterizedTypeReference.forType((Type)type)).orElse(null);
            return new WebReactiveHttpClient(webClient, bodyActualType, WebReactiveHttpClient.webReactiveHttpResponse((Type)Builder.rx2ToReactor(returnPublisherType), (ParameterizedTypeReference)returnActualType), this.errorMapper());
        }

        private static Class rx2ToReactor(Type type) {
            if (type == Flowable.class) {
                return Flux.class;
            }
            if (type == Observable.class) {
                return Flux.class;
            }
            if (type == Single.class) {
                return Mono.class;
            }
            if (type == Maybe.class) {
                return Mono.class;
            }
            throw new IllegalArgumentException("Unexpected type=" + type);
        }
    }
}

