/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud;

import com.netflix.client.RetryHandler;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import feign.Contract;
import feign.MethodMetadata;
import feign.Target;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.cloud.ReactiveFeignClientFactory;
import reactivefeign.cloud.methodhandler.HystrixMethodHandlerFactory;
import reactivefeign.cloud.publisher.RibbonPublisherClient;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.retry.FilteredReactiveRetryPolicy;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.utils.FeignUtils;

public class CloudReactiveFeign {
    private static final Logger logger = LoggerFactory.getLogger(CloudReactiveFeign.class);

    public static <T> Builder<T> builder(ReactiveFeignBuilder<T> builder) {
        return new Builder<T>(builder);
    }

    public static class DefaultSetterFactory
    implements SetterFactory {
        @Override
        public HystrixObservableCommand.Setter create(Target<?> target, MethodMetadata methodMetadata) {
            String groupKey = target.name();
            String commandKey = methodMetadata.configKey();
            return HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
        }
    }

    public static interface SetterFactory {
        public HystrixObservableCommand.Setter create(Target<?> var1, MethodMetadata var2);
    }

    public static class Builder<T>
    implements ReactiveFeignBuilder<T> {
        private ReactiveFeignBuilder<T> builder;
        private boolean hystrixEnabled = true;
        private SetterFactory commandSetterFactory = new DefaultSetterFactory();
        private FallbackFactory<T> fallbackFactory;
        private LoadBalancerCommandFactory loadBalancerCommandFactory = s -> null;

        protected Builder(ReactiveFeignBuilder<T> builder) {
            this.builder = builder;
        }

        public Builder<T> disableHystrix() {
            this.hystrixEnabled = false;
            return this;
        }

        public Builder<T> setHystrixCommandSetterFactory(SetterFactory commandSetterFactory) {
            this.commandSetterFactory = commandSetterFactory;
            return this;
        }

        public Builder<T> enableLoadBalancer() {
            return this.enableLoadBalancer(ReactiveFeignClientFactory.DEFAULT);
        }

        public Builder<T> enableLoadBalancer(ReactiveFeignClientFactory clientFactory) {
            return this.setLoadBalancerCommandFactory(serviceName -> LoadBalancerCommand.builder().withLoadBalancer(clientFactory.loadBalancer((String)serviceName)).withClientConfig(clientFactory.clientConfig((String)serviceName)).build());
        }

        public Builder<T> enableLoadBalancer(ReactiveFeignClientFactory clientFactory, RetryHandler retryHandler) {
            if (retryHandler.getMaxRetriesOnSameServer() > 0) {
                logger.warn("Use retryWhen(ReactiveRetryPolicy retryPolicy) as it allow to configure retry delays (backoff)");
            }
            return this.setLoadBalancerCommandFactory(serviceName -> LoadBalancerCommand.builder().withLoadBalancer(clientFactory.loadBalancer((String)serviceName)).withClientConfig(clientFactory.clientConfig((String)serviceName)).withRetryHandler(retryHandler).build());
        }

        public Builder<T> setLoadBalancerCommandFactory(LoadBalancerCommandFactory loadBalancerCommandFactory) {
            this.loadBalancerCommandFactory = loadBalancerCommandFactory;
            return this;
        }

        public Builder<T> fallback(T fallback) {
            return this.fallbackFactory(throwable -> fallback);
        }

        public Builder<T> fallbackFactory(FallbackFactory<T> fallbackFactory) {
            this.fallbackFactory = fallbackFactory;
            return this;
        }

        public ReactiveFeignBuilder<T> contract(Contract contract) {
            this.builder = this.builder.contract(contract);
            return this;
        }

        public ReactiveFeignBuilder<T> options(ReactiveOptions options) {
            this.builder = this.builder.options(options);
            return this;
        }

        public ReactiveFeignBuilder<T> addRequestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            this.builder = this.builder.addRequestInterceptor(requestInterceptor);
            return this;
        }

        public ReactiveFeignBuilder<T> addLoggerListener(ReactiveLoggerListener loggerListener) {
            this.builder = this.builder.addLoggerListener(loggerListener);
            return this;
        }

        public ReactiveFeignBuilder<T> decode404() {
            this.builder = this.builder.decode404();
            return this;
        }

        public ReactiveFeignBuilder<T> statusHandler(ReactiveStatusHandler statusHandler) {
            this.builder = this.builder.statusHandler(statusHandler);
            return this;
        }

        public ReactiveFeignBuilder<T> responseMapper(BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> responseMapper) {
            this.builder = this.builder.responseMapper(responseMapper);
            return this;
        }

        public ReactiveFeignBuilder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            this.builder = this.builder.retryWhen((ReactiveRetryPolicy)FilteredReactiveRetryPolicy.notRetryOn((ReactiveRetryPolicy)retryPolicy, (Class[])new Class[]{HystrixBadRequestException.class}));
            return this;
        }

        public Contract contract() {
            return this.builder.contract();
        }

        public MethodHandlerFactory buildReactiveMethodHandlerFactory(PublisherClientFactory reactiveClientFactory) {
            MethodHandlerFactory methodHandlerFactory = this.builder.buildReactiveMethodHandlerFactory(reactiveClientFactory);
            return this.hystrixEnabled ? new HystrixMethodHandlerFactory(methodHandlerFactory, this.commandSetterFactory, (Function<Throwable, Object>)this.fallbackFactory) : methodHandlerFactory;
        }

        public PublisherClientFactory buildReactiveClientFactory() {
            final PublisherClientFactory publisherClientFactory = this.builder.buildReactiveClientFactory();
            return new PublisherClientFactory(){
                private Target target;

                public void target(Target target) {
                    this.target = target;
                    publisherClientFactory.target(target);
                }

                public PublisherHttpClient create(MethodMetadata methodMetadata) {
                    PublisherHttpClient publisherClient = publisherClientFactory.create(methodMetadata);
                    if (!this.target.name().equals(this.target.url())) {
                        return new RibbonPublisherClient(loadBalancerCommandFactory, this.target.name(), publisherClient, FeignUtils.returnPublisherType((MethodMetadata)methodMetadata));
                    }
                    return publisherClient;
                }
            };
        }
    }
}

