/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud.methodhandler;

import com.netflix.hystrix.HystrixObservableCommand;
import feign.Feign;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.lang.Nullable;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.methodhandler.MethodHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.Single;

public class HystrixMethodHandler
implements MethodHandler {
    private final Method method;
    private final Type returnPublisherType;
    private final MethodHandler methodHandler;
    private final Function<Throwable, Object> fallbackFactory;
    private final HystrixObservableCommand.Setter hystrixObservableCommandSetter;

    HystrixMethodHandler(Target target, MethodMetadata methodMetadata, MethodHandler methodHandler, CloudReactiveFeign.SetterFactory setterFactory, @Nullable Function<Throwable, Object> fallbackFactory) {
        Util.checkNotNull((Object)target, (String)"target must be not null", (Object[])new Object[0]);
        Util.checkNotNull((Object)methodMetadata, (String)"methodMetadata must be not null", (Object[])new Object[0]);
        this.method = Arrays.stream(target.type().getMethods()).filter(method -> Feign.configKey((Class)target.type(), (Method)method).equals(methodMetadata.configKey())).findFirst().orElseThrow(() -> new IllegalArgumentException());
        this.method.setAccessible(true);
        this.returnPublisherType = ((ParameterizedType)methodMetadata.returnType()).getRawType();
        this.methodHandler = (MethodHandler)Util.checkNotNull((Object)methodHandler, (String)"methodHandler must be not null", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
        Util.checkNotNull((Object)setterFactory, (String)"setterFactory must be not null", (Object[])new Object[0]);
        this.hystrixObservableCommandSetter = setterFactory.create(target, methodMetadata);
    }

    public Publisher<Object> invoke(final Object[] argv) {
        Observable observable = new HystrixObservableCommand<Object>(this.hystrixObservableCommandSetter){

            protected Observable<Object> construct() {
                Mono publisher;
                try {
                    publisher = (Publisher)HystrixMethodHandler.this.methodHandler.invoke(argv);
                }
                catch (Throwable throwable) {
                    publisher = Mono.error((Throwable)throwable);
                }
                return RxReactiveStreams.toObservable((Publisher)publisher);
            }

            protected Observable<Object> resumeWithFallback() {
                if (HystrixMethodHandler.this.fallbackFactory != null) {
                    Object fallback = HystrixMethodHandler.this.fallbackFactory.apply(this.getExecutionException());
                    try {
                        Object fallbackValue = HystrixMethodHandler.this.getFallbackValue(fallback, HystrixMethodHandler.this.method, argv);
                        return RxReactiveStreams.toObservable((Publisher)((Publisher)fallbackValue));
                    }
                    catch (Throwable e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return super.resumeWithFallback();
            }
        }.toObservable();
        if (this.returnPublisherType == Mono.class) {
            return Mono.from((Publisher)RxReactiveStreams.toPublisher((Single)observable.toSingle()));
        }
        if (this.returnPublisherType == Flux.class) {
            return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)observable));
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    protected Object getFallbackValue(Object target, Method method, Object[] argv) throws Throwable {
        return method.invoke(target, argv);
    }
}

