/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud;

import com.netflix.client.ClientFactory;
import com.netflix.client.RetryHandler;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import feign.Contract;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.ReactiveRetryPolicy;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.cloud.methodhandler.HystrixMethodHandlerFactory;
import reactivefeign.cloud.publisher.RibbonPublisherClient;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.FeignUtils;
import reactivefeign.webclient.WebReactiveFeign;

public class CloudReactiveFeign
extends ReactiveFeign {
    private static final Logger logger = LoggerFactory.getLogger(CloudReactiveFeign.class);

    private CloudReactiveFeign(ReactiveFeign.ParseHandlersByName targetToHandlersByName, InvocationHandlerFactory factory) {
        super(targetToHandlersByName, factory);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(WebClient webClient) {
        return new Builder(webClient);
    }

    public static class DefaultSetterFactory
    implements SetterFactory {
        @Override
        public HystrixObservableCommand.Setter create(Target<?> target, MethodMetadata methodMetadata) {
            String groupKey = target.name();
            String commandKey = methodMetadata.configKey();
            return HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
        }
    }

    public static interface SetterFactory {
        public HystrixObservableCommand.Setter create(Target<?> var1, MethodMetadata var2);
    }

    public static class Builder<T>
    extends WebReactiveFeign.Builder<T> {
        private boolean hystrixEnabled = true;
        private SetterFactory commandSetterFactory = new DefaultSetterFactory();
        private Function<Throwable, ? extends T> fallbackFactory;
        private Function<String, LoadBalancerCommand<Object>> loadBalancerCommandFactory = s -> null;

        protected Builder() {
        }

        protected Builder(WebClient webClient) {
            super(webClient);
        }

        public void disableHystrix() {
            this.hystrixEnabled = false;
        }

        public Builder<T> setHystrixCommandSetterFactory(SetterFactory commandSetterFactory) {
            this.commandSetterFactory = commandSetterFactory;
            return this;
        }

        public Builder<T> setFallback(T fallback) {
            return this.setFallbackFactory(throwable -> fallback);
        }

        public Builder<T> setFallbackFactory(Function<Throwable, ? extends T> fallbackFactory) {
            this.fallbackFactory = fallbackFactory;
            return this;
        }

        public Builder<T> enableLoadBalancer() {
            return this.setLoadBalancerCommandFactory(serviceName -> LoadBalancerCommand.builder().withLoadBalancer(ClientFactory.getNamedLoadBalancer((String)serviceName)).build());
        }

        public Builder<T> enableLoadBalancer(RetryHandler retryHandler) {
            if (retryHandler.getMaxRetriesOnSameServer() > 0) {
                logger.warn("Use retryWhen(ReactiveRetryPolicy retryPolicy) as it allow to configure retry delays (backoff)");
            }
            return this.setLoadBalancerCommandFactory(serviceName -> LoadBalancerCommand.builder().withLoadBalancer(ClientFactory.getNamedLoadBalancer((String)serviceName)).withRetryHandler(retryHandler).build());
        }

        public Builder<T> setLoadBalancerCommandFactory(Function<String, LoadBalancerCommand<Object>> loadBalancerCommandFactory) {
            this.loadBalancerCommandFactory = loadBalancerCommandFactory;
            return this;
        }

        protected MethodHandlerFactory buildReactiveMethodHandlerFactory() {
            MethodHandlerFactory methodHandlerFactory = super.buildReactiveMethodHandlerFactory();
            return this.hystrixEnabled ? new HystrixMethodHandlerFactory(methodHandlerFactory, this.commandSetterFactory, this.fallbackFactory) : methodHandlerFactory;
        }

        protected PublisherClientFactory buildReactiveClientFactory() {
            PublisherClientFactory publisherClientFactory = super.buildReactiveClientFactory();
            return methodMetadata -> {
                PublisherHttpClient publisherClient = (PublisherHttpClient)publisherClientFactory.apply(methodMetadata);
                String serviceName = this.extractServiceName(this.target.url());
                return new RibbonPublisherClient(this.loadBalancerCommandFactory.apply(serviceName), publisherClient, FeignUtils.returnPublisherType((MethodMetadata)methodMetadata));
            };
        }

        private String extractServiceName(String url) {
            try {
                return new URI(url).getHost();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Can't extract service name from url", e);
            }
        }

        public Builder<T> contract(Contract contract) {
            super.contract(contract);
            return this;
        }

        public Builder<T> requestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            super.requestInterceptor(requestInterceptor);
            return this;
        }

        public Builder<T> decode404() {
            super.decode404();
            return this;
        }

        public Builder<T> statusHandler(ReactiveStatusHandler statusHandler) {
            super.statusHandler(statusHandler);
            return this;
        }

        public ReactiveFeign.Builder<T> responseMapper(BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> responseMapper) {
            super.responseMapper(responseMapper);
            return this;
        }

        public Builder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            super.retryWhen(retryPolicy);
            return this;
        }

        public Builder<T> options(ReactiveOptions options) {
            super.options(options);
            return this;
        }
    }
}

