/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.handler.timeout.ReadTimeoutException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.webclient.CoreWebBuilder;
import reactivefeign.webclient.NettyClientHttpConnectorBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveOptions;
import reactor.netty.http.client.HttpClient;

public class WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return WebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends CoreWebBuilder<T> {
        private HttpClient httpClient;
        private WebReactiveOptions options = WebReactiveOptions.DEFAULT_OPTIONS;

        protected Builder(WebClient.Builder webClientBuilder) {
            super(webClientBuilder);
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            super(webClientBuilder, webClientCustomizer);
        }

        public ReactiveFeignBuilder<T> httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.options = (WebReactiveOptions)options;
            return this;
        }

        @Override
        protected ClientHttpConnector clientConnector() {
            return NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector(this.httpClient, this.options);
        }

        @Override
        public BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return Objects.requireNonNullElseGet(this.errorMapper, () -> (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof ReadTimeoutException) {
                    return new reactivefeign.client.ReadTimeoutException((Throwable)throwable, (ReactiveHttpRequest)request);
                }
                return null;
            });
        }
    }
}

