/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class SizeLimitHandler
extends Handler.Wrapper {
    private final long _requestLimit;
    private final long _responseLimit;

    public SizeLimitHandler(long requestLimit, long responseLimit) {
        this._requestLimit = requestLimit;
        this._responseLimit = responseLimit;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        HttpField contentLengthField = request.getHeaders().getField(HttpHeader.CONTENT_LENGTH);
        if (contentLengthField != null) {
            long contentLength = contentLengthField.getLongValue();
            if (this._requestLimit >= 0L && contentLength > this._requestLimit) {
                String s = "Request body is too large: " + contentLength + ">" + this._requestLimit;
                Response.writeError(request, response, callback, 413, s);
                return true;
            }
        }
        SizeLimitRequestWrapper wrappedRequest = new SizeLimitRequestWrapper(request);
        SizeLimitResponseWrapper wrappedResponse = new SizeLimitResponseWrapper(wrappedRequest, response);
        return super.handle(wrappedRequest, wrappedResponse, callback);
    }

    private class SizeLimitRequestWrapper
    extends Request.Wrapper {
        private long _read;

        public SizeLimitRequestWrapper(Request wrapped) {
            super(wrapped);
            this._read = 0L;
        }

        @Override
        public Content.Chunk read() {
            Content.Chunk chunk = super.read();
            if (chunk == null) {
                return null;
            }
            if (chunk.getFailure() != null) {
                return chunk;
            }
            ByteBuffer content = chunk.getByteBuffer();
            if (content != null && content.remaining() > 0) {
                this._read += (long)content.remaining();
                if (SizeLimitHandler.this._requestLimit >= 0L && this._read > SizeLimitHandler.this._requestLimit) {
                    BadMessageException e = new BadMessageException(413, "Request body is too large: " + this._read + ">" + SizeLimitHandler.this._requestLimit);
                    this.getWrapped().fail(e);
                    return null;
                }
            }
            return chunk;
        }
    }

    private class SizeLimitResponseWrapper
    extends Response.Wrapper {
        private final HttpFields.Mutable _httpFields;
        private long _written;
        private HttpException.RuntimeException _failure;

        public SizeLimitResponseWrapper(Request request, Response wrapped) {
            super(request, wrapped);
            this._written = 0L;
            this._httpFields = new HttpFields.Mutable.Wrapper(this, wrapped.getHeaders()){
                final /* synthetic */ SizeLimitResponseWrapper this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public HttpField onAddField(HttpField field) {
                    if (field.getHeader() == HttpHeader.CONTENT_LENGTH) {
                        long contentLength = field.getLongValue();
                        if (this.this$1.SizeLimitHandler.this._responseLimit >= 0L && contentLength > this.this$1.SizeLimitHandler.this._responseLimit) {
                            throw new HttpException.RuntimeException(500, "Response body is too large: " + contentLength + ">" + this.this$1.SizeLimitHandler.this._responseLimit);
                        }
                    }
                    return super.onAddField(field);
                }
            };
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this._httpFields;
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            if (this._failure != null) {
                callback.failed(this._failure);
                return;
            }
            if (content != null && content.remaining() > 0) {
                if (SizeLimitHandler.this._responseLimit >= 0L && this._written + (long)content.remaining() > SizeLimitHandler.this._responseLimit) {
                    this._failure = new HttpException.RuntimeException(500, "Response body is too large: %d>%d".formatted(this._written + (long)content.remaining(), SizeLimitHandler.this._responseLimit));
                    callback.failed(this._failure);
                    return;
                }
                this._written += (long)content.remaining();
            }
            super.write(last, content, callback);
        }
    }
}

