/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import java.util.function.LongSupplier;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.compression.EncodingException;
import org.eclipse.jetty.http.compression.HuffmanDecoder;
import org.eclipse.jetty.http.compression.NBitIntegerDecoder;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.http2.hpack.internal.AuthorityHttpField;
import org.eclipse.jetty.http2.hpack.internal.MetaDataBuilder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpackDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HpackDecoder.class);
    private final HpackContext _context;
    private final MetaDataBuilder _builder;
    private final HuffmanDecoder _huffmanDecoder;
    private final NBitIntegerDecoder _integerDecoder;
    private final LongSupplier _beginNanoTimeSupplier;
    private int _maxTableCapacity;

    public HpackDecoder(int maxHeaderSize, LongSupplier beginNanoTimeSupplier) {
        this._beginNanoTimeSupplier = beginNanoTimeSupplier;
        this._context = new HpackContext(4096);
        this._builder = new MetaDataBuilder(maxHeaderSize);
        this._huffmanDecoder = new HuffmanDecoder();
        this._integerDecoder = new NBitIntegerDecoder();
        this.setMaxTableCapacity(4096);
    }

    public HpackContext getHpackContext() {
        return this._context;
    }

    public int getMaxTableCapacity() {
        return this._maxTableCapacity;
    }

    public void setMaxTableCapacity(int maxTableCapacity) {
        this._maxTableCapacity = maxTableCapacity;
    }

    public int getMaxHeaderListSize() {
        return this._builder.getMaxSize();
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this._builder.setMaxSize(maxHeaderListSize);
    }

    public MetaData decode(ByteBuffer buffer) throws HpackException.SessionException, HpackException.StreamException {
        int maxSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("CtxTbl[%x] decoding %d octets", this._context.hashCode(), buffer.remaining()));
        }
        if ((maxSize = this._builder.getMaxSize()) > 0 && buffer.remaining() > maxSize) {
            throw new HpackException.SessionException("Header fields size too large", new Object[0]);
        }
        boolean emitted = false;
        block14: while (buffer.hasRemaining()) {
            HttpField field;
            HttpHeader header;
            String name;
            int nameIndex;
            boolean indexed;
            byte b;
            if (LOG.isDebugEnabled()) {
                LOG.debug("decode {}", (Object)BufferUtil.toHexString(buffer));
            }
            if ((b = buffer.get()) < 0) {
                int index = this.integerDecode(buffer, 7);
                HpackContext.Entry entry = this._context.get(index);
                if (entry == null) {
                    throw new HpackException.SessionException("Unknown index %d", index);
                }
                if (entry.isStatic()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("decode IdxStatic {}", (Object)entry);
                    }
                    emitted = true;
                    this._builder.emit(entry.getHttpField());
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decode Idx {}", (Object)entry);
                }
                emitted = true;
                this._builder.emit(entry.getHttpField());
                continue;
            }
            byte f = (byte)((b & 0xF0) >> 4);
            switch (f) {
                case 2: 
                case 3: {
                    int size = this.integerDecode(buffer, 5);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("decode resize={}", (Object)size);
                    }
                    if (size > this.getMaxTableCapacity()) {
                        throw new HpackException.CompressionException("Dynamic table resize exceeded max limit", new Object[0]);
                    }
                    if (emitted) {
                        throw new HpackException.CompressionException("Dynamic table resize after fields", new Object[0]);
                    }
                    this._context.resize(size);
                    continue block14;
                }
                case 0: 
                case 1: {
                    indexed = false;
                    nameIndex = this.integerDecode(buffer, 4);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    indexed = true;
                    nameIndex = this.integerDecode(buffer, 6);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            boolean huffmanName = false;
            if (nameIndex > 0) {
                HpackContext.Entry nameEntry = this._context.get(nameIndex);
                name = nameEntry.getHttpField().getName();
                header = nameEntry.getHttpField().getHeader();
            } else {
                huffmanName = (buffer.get() & 0x80) == 128;
                int length = this.integerDecode(buffer, 7);
                name = huffmanName ? this.huffmanDecode(buffer, length) : HpackDecoder.toISO88591String(buffer, length);
                int i2 = name.length();
                block15: while (i2-- > 0) {
                    char c = name.charAt(i2);
                    if (c > '\u00ff') {
                        this._builder.streamException("Illegal header name %s", name);
                        break;
                    }
                    HttpTokens.Token token = HttpTokens.TOKENS[0xFF & c];
                    switch (token.getType()) {
                        case ALPHA: {
                            if (c < 'A' || c > 'Z') continue block15;
                            this._builder.streamException("Uppercase header name %s", name);
                            break;
                        }
                        case COLON: 
                        case TCHAR: 
                        case DIGIT: {
                            continue block15;
                        }
                        default: {
                            this._builder.streamException("Illegal header name %s", name);
                            break;
                        }
                    }
                    break;
                }
                header = HttpHeader.CACHE.get(name);
            }
            boolean huffmanValue = (buffer.get() & 0x80) == 128;
            int length = this.integerDecode(buffer, 7);
            String value = huffmanValue ? this.huffmanDecode(buffer, length) : HpackDecoder.toISO88591String(buffer, length);
            if (header == null) {
                field = new HttpField(null, name, value);
            } else {
                switch (header) {
                    case C_STATUS: {
                        if (indexed) {
                            field = new HttpField.IntValueHttpField(header, name, value);
                            break;
                        }
                        field = new HttpField(header, name, value);
                        break;
                    }
                    case C_AUTHORITY: {
                        field = new AuthorityHttpField(value);
                        break;
                    }
                    case CONTENT_LENGTH: {
                        if ("0".equals(value)) {
                            field = HttpFields.CONTENT_LENGTH_0;
                            break;
                        }
                        field = new HttpField.LongValueHttpField(header, name, value);
                        break;
                    }
                    default: {
                        field = new HttpField(header, name, value);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("decoded '{}' by {}/{}/{}", field, nameIndex > 0 ? "IdxName" : (huffmanName ? "HuffName" : "LitName"), huffmanValue ? "HuffVal" : "LitVal", indexed ? "Idx" : "");
            }
            emitted = true;
            this._builder.emit(field);
            if (!indexed) continue;
            this._context.add(field);
        }
        this._builder.setBeginNanoTime(this._beginNanoTimeSupplier.getAsLong());
        return this._builder.build();
    }

    private int integerDecode(ByteBuffer buffer, int prefix) throws HpackException.CompressionException {
        try {
            if (prefix != 8) {
                buffer.position(buffer.position() - 1);
            }
            this._integerDecoder.setPrefix(prefix);
            int decodedInt = this._integerDecoder.decodeInt(buffer);
            if (decodedInt < 0) {
                throw new EncodingException("invalid integer encoding");
            }
            int n = decodedInt;
            return n;
        }
        catch (EncodingException e) {
            HpackException.CompressionException compressionException = new HpackException.CompressionException(e.getMessage(), new Object[0]);
            compressionException.initCause(e);
            throw compressionException;
        }
        finally {
            this._integerDecoder.reset();
        }
    }

    private String huffmanDecode(ByteBuffer buffer, int length) throws HpackException.CompressionException {
        try {
            this._huffmanDecoder.setLength(length);
            String decoded = this._huffmanDecoder.decode(buffer);
            if (decoded == null) {
                throw new HpackException.CompressionException("invalid string encoding", new Object[0]);
            }
            String string = decoded;
            return string;
        }
        catch (EncodingException e) {
            HpackException.CompressionException compressionException = new HpackException.CompressionException(e.getMessage(), new Object[0]);
            compressionException.initCause(e);
            throw compressionException;
        }
        finally {
            this._huffmanDecoder.reset();
        }
    }

    public static String toISO88591String(ByteBuffer buffer, int length) {
        CharsetStringBuilder.Iso88591StringBuilder builder = new CharsetStringBuilder.Iso88591StringBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            builder.append(HttpTokens.sanitizeFieldVchar((char)buffer.get()));
        }
        return builder.build();
    }

    public String toString() {
        return String.format("HpackDecoder@%x{%s}", this.hashCode(), this._context);
    }
}

