/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.ServerRequest;
import reactor.core.publisher.Mono;

class PredicateResourceLookupFunction
implements Function<ServerRequest, Mono<Resource>> {
    private final RequestPredicate predicate;
    private final Resource resource;

    public PredicateResourceLookupFunction(RequestPredicate predicate, Resource resource2) {
        Assert.notNull((Object)predicate, "'predicate' must not be null");
        Assert.notNull((Object)resource2, "'resource' must not be null");
        this.predicate = predicate;
        this.resource = resource2;
    }

    @Override
    public Mono<Resource> apply(ServerRequest serverRequest) {
        return this.predicate.test(serverRequest) ? Mono.just(this.resource) : Mono.empty();
    }
}

