/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.transport.internal.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Sweeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable,
ConnectionPool.MaxMultiplexable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverHTTP2.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final Queue<HttpChannelOverHTTP2> idleChannels = new ConcurrentLinkedQueue<HttpChannelOverHTTP2>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;
    private final HTTP2Connection connection;
    private boolean recycleHttpChannels = true;

    public HttpConnectionOverHTTP2(Destination destination, Session session, HTTP2Connection connection) {
        super((HttpDestination)destination);
        this.session = session;
        this.connection = connection;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.session.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.session.getRemoteSocketAddress();
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    @Override
    public int getMaxMultiplex() {
        return ((HTTP2Session)this.session).getMaxLocalStreams();
    }

    @Override
    protected Iterator<HttpChannel> getHttpChannels() {
        return this.activeChannels.iterator();
    }

    @Override
    public SendFailure send(HttpExchange exchange2) {
        HttpRequest request = exchange2.getRequest();
        request.version(HttpVersion.HTTP_2);
        this.normalizeRequest(request);
        HttpChannelOverHTTP2 channel = this.acquireHttpChannel();
        this.activeChannels.add(channel);
        return this.send(channel, exchange2);
    }

    public void upgrade(Map<String, Object> context) {
        HttpResponse response = (HttpResponse)context.get(HttpResponse.class.getName());
        HttpRequest request = (HttpRequest)response.getRequest();
        HttpChannelOverHTTP2 http2Channel = this.acquireHttpChannel();
        this.activeChannels.add(http2Channel);
        HttpExchange exchange2 = request.getConversation().getExchanges().peekLast();
        HttpExchange newExchange = new HttpExchange(exchange2.getHttpDestination(), request, new ResponseListeners());
        http2Channel.associate(newExchange);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), HttpURI.from(request.getURI()), HttpVersion.HTTP_2, request.getHeaders());
        HeadersFrame frame = new HeadersFrame(metaData, null, true);
        Stream stream = ((HTTP2Session)this.session).newUpgradeStream(frame, http2Channel.getStreamListener(), failure -> {
            newExchange.requestComplete((Throwable)failure);
            newExchange.terminateRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade failed for {}", (Object)this);
            }
        });
        if (stream != null) {
            http2Channel.setStream(stream);
            newExchange.requestComplete(null);
            newExchange.terminateRequest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade succeeded for {}", (Object)this);
            }
        }
    }

    @Override
    protected void normalizeRequest(HttpRequest request) {
        super.normalizeRequest(request);
        HttpUpgrader.Factory upgraderFactory = (HttpUpgrader.Factory)request.getAttributes().get(HttpUpgrader.Factory.class.getName());
        if (upgraderFactory != null) {
            HttpUpgrader upgrader = upgraderFactory.newHttpUpgrader(HttpVersion.HTTP_2);
            request.getConversation().setAttribute(HttpUpgrader.class.getName(), upgrader);
            upgrader.prepare(request);
        }
    }

    protected HttpChannelOverHTTP2 acquireHttpChannel() {
        HttpChannelOverHTTP2 channel = this.idleChannels.poll();
        if (channel == null) {
            channel = this.newHttpChannel();
        }
        return channel;
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this, this.getSession());
    }

    protected boolean release(HttpChannelOverHTTP2 channel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", (Object)channel);
        }
        if (this.activeChannels.remove(channel)) {
            if (channel.isFailed()) {
                channel.destroy();
            } else if (this.isRecycleHttpChannels()) {
                this.idleChannels.offer(channel);
            }
            return true;
        }
        channel.destroy();
        return false;
    }

    @Override
    public boolean onIdleTimeout(long idleTimeout, Throwable failure) {
        boolean close = super.onIdleTimeout(idleTimeout, failure);
        if (close) {
            this.close(failure);
        }
        return false;
    }

    void remove() {
        this.getHttpDestination().remove(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove(this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
            HttpChannel channel = this.idleChannels.poll();
            while (channel != null) {
                channel.destroy();
                channel = this.idleChannels.poll();
            }
            this.destroy();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.activeChannels) {
            HttpExchange exchange2 = channel.getHttpExchange();
            if (exchange2 == null) continue;
            exchange2.getRequest().abort(failure);
        }
        this.activeChannels.clear();
        HttpChannel channel = this.idleChannels.poll();
        while (channel != null) {
            channel.destroy();
            channel = this.idleChannels.poll();
        }
    }

    @Override
    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    void offerTask(Runnable task, boolean dispatch) {
        if (task != null) {
            this.connection.offerTask(task, dispatch);
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x(closed=%b)[%s]", this.getClass().getSimpleName(), this.hashCode(), this.isClosed(), this.session);
    }
}

