/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.retry;

import feign.ExceptionPropagationPolicy;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.util.retry.Retry;

public class FilteredReactiveRetryPolicy
implements ReactiveRetryPolicy {
    private final ReactiveRetryPolicy retryPolicy;
    private final Predicate<Throwable> toRetryOn;

    public static FilteredReactiveRetryPolicy notRetryOn(ReactiveRetryPolicy retryPolicy, Class<? extends Throwable> ... errorClasses) {
        return new FilteredReactiveRetryPolicy(retryPolicy, throwable -> Stream.of(errorClasses).noneMatch(errorClass -> errorClass.isAssignableFrom(throwable.getClass())));
    }

    public FilteredReactiveRetryPolicy(ReactiveRetryPolicy retryPolicy, Predicate<Throwable> toRetryOn) {
        this.retryPolicy = retryPolicy;
        this.toRetryOn = toRetryOn;
    }

    @Override
    public Retry retry() {
        return FilteredReactiveRetryPolicy.filter(this.retryPolicy.retry(), this.toRetryOn);
    }

    @Override
    public int maxAllowedRetries() {
        return this.retryPolicy.maxAllowedRetries();
    }

    static Retry filter(final Retry retry, final Predicate<Throwable> toRetryOn) {
        return new Retry(){

            @Override
            public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
                return retry.generateCompanion(retrySignals.map(retrySignal -> {
                    if (toRetryOn.test(retrySignal.failure())) {
                        return retrySignal;
                    }
                    throw Exceptions.propagate(retrySignal.failure());
                }));
            }
        };
    }

    @Override
    public ExceptionPropagationPolicy exceptionPropagationPolicy() {
        return this.retryPolicy.exceptionPropagationPolicy();
    }
}

