/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.log;

import feign.MethodMetadata;
import feign.Target;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpExchangeFilterFunction;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.utils.FeignUtils;
import reactivefeign.utils.SerializedFormData;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LoggerExchangeFilterFunction<P extends Publisher<?>>
implements ReactiveHttpExchangeFilterFunction<P> {
    private final MethodMetadata methodMetadata;
    private Target target;
    private final ReactiveLoggerListener<Object> loggerListener;
    private final boolean requestWithBody;
    private final boolean responseWithBody;

    public static <P extends Publisher<?>> ReactiveHttpExchangeFilterFunction<P> log(MethodMetadata methodMetadata, Target target, ReactiveLoggerListener<Object> loggerListener) {
        return new LoggerExchangeFilterFunction<P>(methodMetadata, target, loggerListener);
    }

    private LoggerExchangeFilterFunction(MethodMetadata methodMetadata, Target target, ReactiveLoggerListener<Object> loggerListener) {
        this.methodMetadata = methodMetadata;
        this.target = target;
        this.loggerListener = loggerListener;
        this.requestWithBody = FeignUtils.requestWithBody(methodMetadata);
        this.responseWithBody = FeignUtils.responseWithBody(methodMetadata);
    }

    @Override
    public Mono<ReactiveHttpResponse<P>> filter(ReactiveHttpRequest request, ReactiveHttpClient<P> exchangeFunction) {
        AtomicReference<Object> logContext = new AtomicReference<Object>();
        logContext.set(this.loggerListener.requestStarted(request, this.target, this.methodMetadata));
        if (this.loggerListener.logRequestBody()) {
            request = this.logRequestBody(request, logContext.get());
        }
        return exchangeFunction.executeRequest(request).doOnNext(resp -> this.loggerListener.responseReceived((ReactiveHttpResponse<?>)resp, logContext.get())).doOnError(throwable -> this.loggerListener.errorReceived((Throwable)throwable, logContext.get())).map(resp -> {
            if (this.loggerListener.logResponseBody()) {
                return this.logResponseBody((ReactiveHttpResponse<P>)resp, logContext.get());
            }
            return resp;
        });
    }

    private ReactiveHttpRequest logRequestBody(ReactiveHttpRequest request, Object logContext) {
        if (this.requestWithBody) {
            Publisher<Object> bodyLogged;
            if (request.body() instanceof Mono) {
                bodyLogged = ((Mono)request.body()).doOnNext(this.requestBodyLogger(logContext));
            } else if (request.body() instanceof Flux) {
                bodyLogged = ((Flux)request.body()).doOnNext(this.requestBodyLogger(logContext));
            } else if (request.body() instanceof SerializedFormData) {
                bodyLogged = ((SerializedFormData)request.body()).logged(this.requestBodyLogger(logContext));
            } else {
                throw new IllegalArgumentException("Unsupported publisher type: " + request.body().getClass());
            }
            return new ReactiveHttpRequest(request, bodyLogged);
        }
        return request;
    }

    private Consumer<Object> requestBodyLogger(Object logContext) {
        return body2 -> this.loggerListener.bodySent(body2, logContext);
    }

    private ReactiveHttpResponse<P> logResponseBody(ReactiveHttpResponse<P> resp, Object logContext) {
        return this.responseWithBody ? new LoggerReactiveHttpResponse(resp, this.loggerListener, logContext) : resp;
    }

    private static class LoggerReactiveHttpResponse<P extends Publisher<?>>
    extends DelegatingReactiveHttpResponse<P> {
        private final ReactiveLoggerListener<Object> loggerListener;
        private Object logContext;

        private LoggerReactiveHttpResponse(ReactiveHttpResponse<P> response, ReactiveLoggerListener<Object> loggerListener, Object logContext) {
            super(response);
            this.loggerListener = loggerListener;
            this.logContext = logContext;
        }

        @Override
        public P body() {
            Object publisher = this.getResponse().body();
            if (publisher instanceof Mono) {
                return (P)((Mono)publisher).doOnNext(this.responseBodyLogger());
            }
            return (P)((Flux)publisher).doOnNext(this.responseBodyLogger());
        }

        @Override
        public Mono<byte[]> bodyData() {
            Mono<byte[]> publisher = this.getResponse().bodyData();
            return publisher.doOnNext(this.responseBodyLogger());
        }

        private Consumer<Object> responseBodyLogger() {
            return result -> this.loggerListener.bodyReceived(result, this.logContext);
        }
    }
}

