/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.log;

import feign.MethodMetadata;
import feign.Target;
import java.time.Clock;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.utils.Pair;
import reactivefeign.utils.SerializedFormData;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveLogger
implements ReactiveLoggerListener<LogContext> {
    private final Logger logger;
    private final Clock clock;

    public DefaultReactiveLogger(Clock clock) {
        this(clock, LoggerFactory.getLogger(DefaultReactiveLogger.class));
    }

    public DefaultReactiveLogger(Clock clock, Logger logger) {
        this.clock = clock;
        this.logger = logger;
    }

    @Override
    public LogContext requestStarted(ReactiveHttpRequest request, Target target, MethodMetadata methodMetadata) {
        LogContext logContext = new LogContext(request, target, methodMetadata, this.clock);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]--->{} {} HTTP/1.1", logContext.feignMethodKey, request.method(), request.uri());
        }
        if (this.logger.isTraceEnabled()) {
            this.logRequestHeaders(request, logContext.feignMethodKey);
        }
        return logContext;
    }

    @Override
    public boolean logRequestBody() {
        return this.logger.isTraceEnabled();
    }

    private void logRequestHeaders(ReactiveHttpRequest request, String feignMethodTag) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] REQUEST HEADERS\n{}", (Object)feignMethodTag, (Object)DefaultReactiveLogger.msg(() -> request.headers().entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"))));
        }
    }

    @Override
    public void bodySent(Object body2, LogContext logContext) {
        if (this.logger.isTraceEnabled()) {
            Publisher<Object> requestBody = logContext.request.body();
            if (requestBody instanceof Mono) {
                this.logger.trace("[{}] REQUEST BODY\n{}", (Object)logContext.feignMethodKey, body2);
            } else if (requestBody instanceof Flux) {
                this.logger.trace("[{}] REQUEST BODY ELEMENT\n{}", (Object)logContext.feignMethodKey, body2);
            } else if (requestBody instanceof SerializedFormData) {
                this.logger.trace("[{}] REQUEST BODY FORM DATA\n{}", (Object)logContext.feignMethodKey, body2);
            } else {
                throw new IllegalArgumentException("Unsupported publisher type: " + requestBody.getClass());
            }
        }
    }

    @Override
    public void responseReceived(ReactiveHttpResponse response, LogContext logContext) {
        logContext.setResponse(response);
        this.logResponseHeaders(response, logContext.feignMethodKey, logContext.timeSpent());
    }

    @Override
    public void errorReceived(Throwable throwable, LogContext logContext) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("[{}]--->{} {} HTTP/1.1", logContext.feignMethodKey, logContext.request.method(), logContext.request.uri(), throwable);
        }
    }

    @Override
    public boolean logResponseBody() {
        return this.logger.isTraceEnabled();
    }

    private void logResponseHeaders(ReactiveHttpResponse<?> httpResponse, String feignMethodTag, long elapsedTime) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] RESPONSE HEADERS\n{}", (Object)feignMethodTag, (Object)DefaultReactiveLogger.msg(() -> httpResponse.headers().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new Pair<String, String>((String)entry.getKey(), (String)value))).map(pair -> String.format("%s:%s", pair.left, pair.right)).collect(Collectors.joining("\n"))));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- headers takes {} milliseconds", (Object)feignMethodTag, (Object)elapsedTime);
        }
    }

    @Override
    public void bodyReceived(Object body2, LogContext logContext) {
        if (this.logger.isTraceEnabled()) {
            if (logContext.getResponse().body() instanceof Mono) {
                this.logger.trace("[{}] RESPONSE BODY\n{}", (Object)logContext.feignMethodKey, body2);
            } else {
                this.logger.trace("[{}] RESPONSE BODY ELEMENT\n{}", (Object)logContext.feignMethodKey, body2);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]<--- body takes {} milliseconds", (Object)logContext.feignMethodKey, (Object)logContext.timeSpent());
        }
    }

    private static MessageSupplier msg(Supplier<?> supplier) {
        return new MessageSupplier(supplier);
    }

    static class LogContext {
        private final ReactiveHttpRequest request;
        private final Target target;
        private final MethodMetadata methodMetadata;
        private final Clock clock;
        private final long startTime;
        private final String feignMethodKey;
        private ReactiveHttpResponse response;

        public LogContext(ReactiveHttpRequest request, Target target, MethodMetadata methodMetadata, Clock clock) {
            this.request = request;
            this.target = target;
            this.methodMetadata = methodMetadata;
            this.clock = clock;
            this.startTime = clock.millis();
            this.feignMethodKey = methodMetadata.configKey();
        }

        public long timeSpent() {
            return this.clock.millis() - this.startTime;
        }

        public ReactiveHttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(ReactiveHttpResponse response) {
            this.response = response;
        }
    }

    static class MessageSupplier {
        private Supplier<?> supplier;

        public MessageSupplier(Supplier<?> supplier) {
            this.supplier = supplier;
        }

        public String toString() {
            return this.supplier.get().toString();
        }
    }
}

