/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class MediaTypeFactory {
    private static final String MIME_TYPES_FILE_NAME = "/org/springframework/http/mime.types";
    private static final MultiValueMap<String, MediaType> fileExtensionToMediaTypes = MediaTypeFactory.parseMimeTypes();

    private MediaTypeFactory() {
    }

    private static MultiValueMap<String, MediaType> parseMimeTypes() {
        LinkedMultiValueMap<String, MediaType> linkedMultiValueMap;
        InputStream is = MediaTypeFactory.class.getResourceAsStream(MIME_TYPES_FILE_NAME);
        Assert.state(is != null, "/org/springframework/http/mime.types not found in classpath");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
        try {
            String line;
            LinkedMultiValueMap<String, MediaType> result = new LinkedMultiValueMap<String, MediaType>();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] tokens = StringUtils.tokenizeToStringArray(line, " \t\n\r\f");
                MediaType mediaType = MediaType.parseMediaType(tokens[0]);
                for (int i2 = 1; i2 < tokens.length; ++i2) {
                    String fileExtension = tokens[i2].toLowerCase(Locale.ENGLISH);
                    result.add(fileExtension, mediaType);
                }
            }
            linkedMultiValueMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not read /org/springframework/http/mime.types", ex);
            }
        }
        reader.close();
        return linkedMultiValueMap;
    }

    public static Optional<MediaType> getMediaType(@Nullable Resource resource2) {
        return Optional.ofNullable(resource2).map(Resource::getFilename).flatMap(MediaTypeFactory::getMediaType);
    }

    public static Optional<MediaType> getMediaType(@Nullable String filename) {
        return MediaTypeFactory.getMediaTypes(filename).stream().findFirst();
    }

    public static List<MediaType> getMediaTypes(@Nullable String filename) {
        List mediaTypes = null;
        String ext = StringUtils.getFilenameExtension(filename);
        if (ext != null) {
            mediaTypes = (List)fileExtensionToMediaTypes.get(ext.toLowerCase(Locale.ENGLISH));
        }
        return mediaTypes != null ? mediaTypes : Collections.emptyList();
    }
}

