/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class PathContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final Path path;
    private final long length;
    private final ByteBufferPool byteBufferPool;
    private int bufferSize = 4096;
    private boolean useDirectByteBuffers = true;
    private SeekableByteChannel channel;
    private long totalRead;
    private Runnable demandCallback;
    private Content.Chunk errorChunk;

    public PathContentSource(Path path) {
        this(path, null);
    }

    public PathContentSource(Path path, ByteBufferPool byteBufferPool) {
        try {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new NoSuchFileException(path.toString());
            }
            if (!Files.isReadable(path)) {
                throw new AccessDeniedException(path.toString());
            }
            this.path = path;
            this.length = Files.size(path);
            this.byteBufferPool = byteBufferPool != null ? byteBufferPool : ByteBufferPool.NON_POOLING;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public Content.Chunk read() {
        boolean last;
        int read;
        SeekableByteChannel channel;
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk != null) {
                Content.Chunk chunk = this.errorChunk;
                return chunk;
            }
            if (this.channel == null) {
                try {
                    this.channel = this.open();
                }
                catch (Throwable x) {
                    Content.Chunk chunk = this.failure(x);
                    if (ignored != null) {
                        ignored.close();
                    }
                    return chunk;
                }
            }
            channel = this.channel;
        }
        if (!channel.isOpen()) {
            return Content.Chunk.EOF;
        }
        RetainableByteBuffer retainableByteBuffer = this.byteBufferPool.acquire(this.getBufferSize(), this.isUseDirectByteBuffers());
        ByteBuffer byteBuffer = retainableByteBuffer.getByteBuffer();
        try {
            BufferUtil.clearToFill(byteBuffer);
            read = this.read(channel, byteBuffer);
            BufferUtil.flipToFlush(byteBuffer, 0);
        }
        catch (Throwable x) {
            retainableByteBuffer.release();
            return this.failure(x);
        }
        if (read > 0) {
            this.totalRead += (long)read;
        }
        boolean bl = last = read == -1 || this.isReadComplete(this.totalRead);
        if (last) {
            IO.close(channel);
        }
        return Content.Chunk.asChunk(byteBuffer, last, retainableByteBuffer);
    }

    protected SeekableByteChannel open() throws IOException {
        return Files.newByteChannel(this.path, StandardOpenOption.READ);
    }

    protected int read(SeekableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.read(byteBuffer);
    }

    protected boolean isReadComplete(long read) {
        return read == this.getLength();
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.failure(failure);
    }

    private Content.Chunk failure(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk == null) {
                this.errorChunk = Content.Chunk.from(failure);
                IO.close(this.channel);
            }
            Content.Chunk chunk = this.errorChunk;
            return chunk;
        }
    }

    @Override
    public boolean rewind() {
        try (AutoLock ignored = this.lock.lock();){
            IO.close(this.channel);
            this.channel = null;
            this.totalRead = 0L;
            this.demandCallback = null;
            this.errorChunk = null;
        }
        return true;
    }
}

