/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeignException
extends RuntimeException {
    private static final String EXCEPTION_MESSAGE_TEMPLATE_NULL_REQUEST = "request should not be null";
    private static final long serialVersionUID = 0L;
    private final int status;
    private byte[] responseBody;
    private Map<String, Collection<String>> responseHeaders;
    private final Request request;

    protected FeignException(int status, String message, Throwable cause) {
        super(message, cause);
        this.status = status;
        this.request = null;
    }

    protected FeignException(int status, String message, Throwable cause, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(message, cause);
        this.status = status;
        this.responseBody = responseBody;
        this.responseHeaders = Util.caseInsensitiveCopyOf(responseHeaders);
        this.request = null;
    }

    protected FeignException(int status, String message) {
        super(message);
        this.status = status;
        this.request = null;
    }

    protected FeignException(int status, String message, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(message);
        this.status = status;
        this.responseBody = responseBody;
        this.responseHeaders = Util.caseInsensitiveCopyOf(responseHeaders);
        this.request = null;
    }

    protected FeignException(int status, String message, Request request, Throwable cause) {
        super(message, cause);
        this.status = status;
        this.request = this.checkRequestNotNull(request);
    }

    protected FeignException(int status, String message, Request request, Throwable cause, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(message, cause);
        this.status = status;
        this.responseBody = responseBody;
        this.responseHeaders = Util.caseInsensitiveCopyOf(responseHeaders);
        this.request = this.checkRequestNotNull(request);
    }

    protected FeignException(int status, String message, Request request) {
        super(message);
        this.status = status;
        this.request = this.checkRequestNotNull(request);
    }

    protected FeignException(int status, String message, Request request, byte[] responseBody, Map<String, Collection<String>> responseHeaders) {
        super(message);
        this.status = status;
        this.responseBody = responseBody;
        this.responseHeaders = Util.caseInsensitiveCopyOf(responseHeaders);
        this.request = this.checkRequestNotNull(request);
    }

    private Request checkRequestNotNull(Request request) {
        return Util.checkNotNull(request, EXCEPTION_MESSAGE_TEMPLATE_NULL_REQUEST, new Object[0]);
    }

    public int status() {
        return this.status;
    }

    @Deprecated
    public byte[] content() {
        return this.responseBody;
    }

    public Optional<ByteBuffer> responseBody() {
        if (this.responseBody == null) {
            return Optional.empty();
        }
        return Optional.of(ByteBuffer.wrap(this.responseBody));
    }

    public Map<String, Collection<String>> responseHeaders() {
        if (this.responseHeaders == null) {
            return Collections.emptyMap();
        }
        return this.responseHeaders;
    }

    public Request request() {
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public String contentUTF8() {
        if (this.responseBody != null) {
            return new String(this.responseBody, Util.UTF_8);
        }
        return "";
    }

    static FeignException errorReading(Request request, Response response, IOException cause) {
        return new FeignException(response.status(), String.format("%s reading %s %s", new Object[]{cause.getMessage(), request.httpMethod(), request.url()}), request, cause, request.body(), request.headers());
    }

    public static FeignException errorStatus(String methodKey, Response response) {
        return FeignException.errorStatus(methodKey, response, null, null);
    }

    public static FeignException errorStatus(String methodKey, Response response, Integer maxBodyBytesLength, Integer maxBodyCharsLength) {
        byte[] body2 = new byte[]{};
        try {
            if (response.body() != null) {
                body2 = Util.toByteArray(response.body().asInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String message = new FeignExceptionMessageBuilder().withResponse(response).withMethodKey(methodKey).withMaxBodyBytesLength(maxBodyBytesLength).withMaxBodyCharsLength(maxBodyCharsLength).withBody(body2).build();
        return FeignException.errorStatus(response.status(), message, response.request(), body2, response.headers());
    }

    private static FeignException errorStatus(int status, String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
        if (FeignException.isClientError(status)) {
            return FeignException.clientErrorStatus(status, message, request, body2, headers);
        }
        if (FeignException.isServerError(status)) {
            return FeignException.serverErrorStatus(status, message, request, body2, headers);
        }
        return new FeignException(status, message, request, body2, headers);
    }

    private static boolean isClientError(int status) {
        return status >= 400 && status < 500;
    }

    private static FeignClientException clientErrorStatus(int status, String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
        switch (status) {
            case 400: {
                return new BadRequest(message, request, body2, headers);
            }
            case 401: {
                return new Unauthorized(message, request, body2, headers);
            }
            case 403: {
                return new Forbidden(message, request, body2, headers);
            }
            case 404: {
                return new NotFound(message, request, body2, headers);
            }
            case 405: {
                return new MethodNotAllowed(message, request, body2, headers);
            }
            case 406: {
                return new NotAcceptable(message, request, body2, headers);
            }
            case 409: {
                return new Conflict(message, request, body2, headers);
            }
            case 410: {
                return new Gone(message, request, body2, headers);
            }
            case 415: {
                return new UnsupportedMediaType(message, request, body2, headers);
            }
            case 429: {
                return new TooManyRequests(message, request, body2, headers);
            }
            case 422: {
                return new UnprocessableEntity(message, request, body2, headers);
            }
        }
        return new FeignClientException(status, message, request, body2, headers);
    }

    private static boolean isServerError(int status) {
        return status >= 500 && status <= 599;
    }

    private static FeignServerException serverErrorStatus(int status, String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
        switch (status) {
            case 500: {
                return new InternalServerError(message, request, body2, headers);
            }
            case 501: {
                return new NotImplemented(message, request, body2, headers);
            }
            case 502: {
                return new BadGateway(message, request, body2, headers);
            }
            case 503: {
                return new ServiceUnavailable(message, request, body2, headers);
            }
            case 504: {
                return new GatewayTimeout(message, request, body2, headers);
            }
        }
        return new FeignServerException(status, message, request, body2, headers);
    }

    static FeignException errorExecuting(Request request, IOException cause) {
        Long nonRetryable = null;
        return new RetryableException(-1, String.format("%s executing %s %s", new Object[]{cause.getMessage(), request.httpMethod(), request.url()}), request.httpMethod(), (Throwable)cause, nonRetryable, request);
    }

    private static class FeignExceptionMessageBuilder {
        private static final int MAX_BODY_BYTES_LENGTH = 400;
        private static final int MAX_BODY_CHARS_LENGTH = 200;
        private Response response;
        private byte[] body;
        private String methodKey;
        private Integer maxBodyBytesLength;
        private Integer maxBodyCharsLength;

        private FeignExceptionMessageBuilder() {
        }

        public FeignExceptionMessageBuilder withResponse(Response response) {
            this.response = response;
            return this;
        }

        public FeignExceptionMessageBuilder withBody(byte[] body2) {
            this.body = body2;
            return this;
        }

        public FeignExceptionMessageBuilder withMethodKey(String methodKey) {
            this.methodKey = methodKey;
            return this;
        }

        public FeignExceptionMessageBuilder withMaxBodyBytesLength(Integer length) {
            this.maxBodyBytesLength = length;
            return this;
        }

        public FeignExceptionMessageBuilder withMaxBodyCharsLength(Integer length) {
            this.maxBodyCharsLength = length;
            return this;
        }

        public String build() {
            StringBuilder result = new StringBuilder();
            if (this.maxBodyBytesLength == null) {
                this.maxBodyBytesLength = 400;
            }
            if (this.maxBodyCharsLength == null) {
                this.maxBodyCharsLength = 200;
            }
            if (this.response.reason() != null) {
                result.append(String.format("[%d %s]", this.response.status(), this.response.reason()));
            } else {
                result.append(String.format("[%d]", this.response.status()));
            }
            result.append(String.format(" during [%s] to [%s] [%s]", new Object[]{this.response.request().httpMethod(), this.response.request().url(), this.methodKey}));
            result.append(String.format(": [%s]", this.getBodyAsString(this.body, this.response.headers())));
            return result.toString();
        }

        private String getBodyAsString(byte[] body2, Map<String, Collection<String>> headers) {
            Charset charset = FeignExceptionMessageBuilder.getResponseCharset(headers);
            if (charset == null) {
                charset = Util.UTF_8;
            }
            return this.getResponseBody(body2, charset);
        }

        private String getResponseBody(byte[] body2, Charset charset) {
            if (body2.length < this.maxBodyBytesLength) {
                return new String(body2, charset);
            }
            return this.getResponseBodyPreview(body2, charset);
        }

        private String getResponseBodyPreview(byte[] body2, Charset charset) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(body2), charset);
                CharBuffer result = CharBuffer.allocate(this.maxBodyCharsLength);
                ((Reader)reader).read(result);
                ((Reader)reader).close();
                ((Buffer)result).flip();
                return result + "... (" + body2.length + " bytes)";
            }
            catch (IOException e) {
                return e + ", failed to parse response";
            }
        }

        private static Charset getResponseCharset(Map<String, Collection<String>> headers) {
            Collection<String> strings = headers.get("content-type");
            if (strings == null || strings.isEmpty()) {
                return null;
            }
            Pattern pattern = Pattern.compile(".*charset=([^\\s|^;]+).*");
            Matcher matcher = pattern.matcher(strings.iterator().next());
            if (!matcher.lookingAt()) {
                return null;
            }
            String group = matcher.group(1);
            if (!Charset.isSupported(group)) {
                return null;
            }
            return Charset.forName(group);
        }
    }

    public static class GatewayTimeout
    extends FeignServerException {
        public GatewayTimeout(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(504, message, request, body2, headers);
        }
    }

    public static class ServiceUnavailable
    extends FeignServerException {
        public ServiceUnavailable(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(503, message, request, body2, headers);
        }
    }

    public static class BadGateway
    extends FeignServerException {
        public BadGateway(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(502, message, request, body2, headers);
        }
    }

    public static class NotImplemented
    extends FeignServerException {
        public NotImplemented(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(501, message, request, body2, headers);
        }
    }

    public static class InternalServerError
    extends FeignServerException {
        public InternalServerError(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(500, message, request, body2, headers);
        }
    }

    public static class FeignServerException
    extends FeignException {
        public FeignServerException(int status, String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(status, message, request, body2, headers);
        }
    }

    public static class UnprocessableEntity
    extends FeignClientException {
        public UnprocessableEntity(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(422, message, request, body2, headers);
        }
    }

    public static class TooManyRequests
    extends FeignClientException {
        public TooManyRequests(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(429, message, request, body2, headers);
        }
    }

    public static class UnsupportedMediaType
    extends FeignClientException {
        public UnsupportedMediaType(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(415, message, request, body2, headers);
        }
    }

    public static class Gone
    extends FeignClientException {
        public Gone(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(410, message, request, body2, headers);
        }
    }

    public static class Conflict
    extends FeignClientException {
        public Conflict(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(409, message, request, body2, headers);
        }
    }

    public static class NotAcceptable
    extends FeignClientException {
        public NotAcceptable(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(406, message, request, body2, headers);
        }
    }

    public static class MethodNotAllowed
    extends FeignClientException {
        public MethodNotAllowed(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(405, message, request, body2, headers);
        }
    }

    public static class NotFound
    extends FeignClientException {
        public NotFound(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(404, message, request, body2, headers);
        }
    }

    public static class Forbidden
    extends FeignClientException {
        public Forbidden(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(403, message, request, body2, headers);
        }
    }

    public static class Unauthorized
    extends FeignClientException {
        public Unauthorized(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(401, message, request, body2, headers);
        }
    }

    public static class BadRequest
    extends FeignClientException {
        public BadRequest(String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(400, message, request, body2, headers);
        }
    }

    public static class FeignClientException
    extends FeignException {
        public FeignClientException(int status, String message, Request request, byte[] body2, Map<String, Collection<String>> headers) {
            super(status, message, request, body2, headers);
        }
    }
}

