/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observers.Subscribers;

public final class OnSubscribeUsing<T, Resource>
implements Observable.OnSubscribe<T> {
    private final Func0<Resource> resourceFactory;
    private final Func1<? super Resource, ? extends Observable<? extends T>> observableFactory;
    private final Action1<? super Resource> dispose;
    private final boolean disposeEagerly;

    public OnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Observable<? extends T>> observableFactory, Action1<? super Resource> dispose, boolean disposeEagerly) {
        this.resourceFactory = resourceFactory;
        this.observableFactory = observableFactory;
        this.dispose = dispose;
        this.disposeEagerly = disposeEagerly;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        block9: {
            try {
                Observable<T> source;
                Resource resource2 = this.resourceFactory.call();
                DisposeAction<? super Resource> disposeOnceOnly = new DisposeAction<Resource>(this.dispose, resource2);
                subscriber.add(disposeOnceOnly);
                try {
                    source = this.observableFactory.call(resource2);
                }
                catch (Throwable e) {
                    Throwable disposeError = this.dispose(disposeOnceOnly);
                    Exceptions.throwIfFatal(e);
                    Exceptions.throwIfFatal(disposeError);
                    if (disposeError != null) {
                        subscriber.onError(new CompositeException(e, disposeError));
                    } else {
                        subscriber.onError(e);
                    }
                    return;
                }
                Observable<Object> observable = this.disposeEagerly ? source.doOnTerminate(disposeOnceOnly) : source.doAfterTerminate(disposeOnceOnly);
                try {
                    observable.unsafeSubscribe(Subscribers.wrap(subscriber));
                }
                catch (Throwable e) {
                    Throwable disposeError = this.dispose(disposeOnceOnly);
                    Exceptions.throwIfFatal(e);
                    Exceptions.throwIfFatal(disposeError);
                    if (disposeError != null) {
                        subscriber.onError(new CompositeException(e, disposeError));
                        break block9;
                    }
                    subscriber.onError(e);
                }
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, subscriber);
            }
        }
    }

    private Throwable dispose(Action0 disposeOnceOnly) {
        try {
            disposeOnceOnly.call();
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    static final class DisposeAction<Resource>
    extends AtomicBoolean
    implements Action0,
    Subscription {
        private static final long serialVersionUID = 4262875056400218316L;
        private Action1<? super Resource> dispose;
        private Resource resource;

        DisposeAction(Action1<? super Resource> dispose, Resource resource2) {
            this.dispose = dispose;
            this.resource = resource2;
            this.lazySet(false);
        }

        @Override
        public void call() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.dispose.call(this.resource);
                }
                finally {
                    this.resource = null;
                    this.dispose = null;
                }
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }

        @Override
        public void unsubscribe() {
            this.call();
        }
    }
}

