/*
 * Decompiled with CFR 0.152.
 */
package reactivejson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class Tokenizer {
    private final JsonParser parser;
    private final boolean tokenizeArrayElements;
    private TokenBuffer tokenBuffer;
    private int objectDepth;
    private int arrayDepth;
    private final ByteBufferFeeder inputFeeder;

    public Tokenizer(JsonFactory jsonFactory, boolean tokenizeArrayElements) throws IOException {
        this.parser = jsonFactory.createNonBlockingByteArrayParser();
        this.tokenizeArrayElements = tokenizeArrayElements;
        this.tokenBuffer = new TokenBuffer(this.parser);
        this.inputFeeder = (ByteBufferFeeder)this.parser.getNonBlockingInputFeeder();
    }

    public List<TokenBuffer> tokenize(ByteBuffer byteBuffer) throws IOException {
        this.inputFeeder.feedInput(byteBuffer);
        return this.parse();
    }

    public List<TokenBuffer> endOfInput() throws IOException {
        this.inputFeeder.endOfInput();
        return this.parse();
    }

    private List<TokenBuffer> parse() throws IOException {
        JsonToken token;
        ArrayList<TokenBuffer> result = new ArrayList<TokenBuffer>();
        while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE && (token != null || (token = this.parser.nextToken()) != null)) {
            this.updateDepth(token);
            if (!this.tokenizeArrayElements) {
                this.processTokenNormal(token, result);
                continue;
            }
            this.processTokenArray(token, result);
        }
        return result;
    }

    private void updateDepth(JsonToken token) {
        switch (token) {
            case START_OBJECT: {
                ++this.objectDepth;
                break;
            }
            case END_OBJECT: {
                --this.objectDepth;
                break;
            }
            case START_ARRAY: {
                ++this.arrayDepth;
                break;
            }
            case END_ARRAY: {
                --this.arrayDepth;
            }
        }
    }

    private void processTokenNormal(JsonToken token, List<TokenBuffer> result) throws IOException {
        this.tokenBuffer.copyCurrentEvent(this.parser);
        if ((token.isStructEnd() || token.isScalarValue()) && this.objectDepth == 0 && this.arrayDepth == 0) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser);
        }
    }

    private void processTokenArray(JsonToken token, List<TokenBuffer> result) throws IOException {
        if (!this.isTopLevelArrayToken(token)) {
            this.tokenBuffer.copyCurrentEvent(this.parser);
        }
        if (!(this.objectDepth != 0 || this.arrayDepth != 0 && this.arrayDepth != 1 || token != JsonToken.END_OBJECT && !token.isScalarValue())) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser);
        }
    }

    private boolean isTopLevelArrayToken(JsonToken token) {
        return this.objectDepth == 0 && (token == JsonToken.START_ARRAY && this.arrayDepth == 1 || token == JsonToken.END_ARRAY && this.arrayDepth == 0);
    }
}

