/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.observation.ServerRequestObservationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.reactive.ServerHttpObservationFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.method.AbstractHandlerMethodMapping;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsatisfiedRequestParameterException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Method HTTP_OPTIONS_HANDLE_METHOD;

    @Override
    protected Set<String> getDirectPaths(RequestMappingInfo info) {
        return info.getDirectPaths();
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, ServerWebExchange exchange2) {
        return info.getMatchingCondition(exchange2);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(ServerWebExchange exchange2) {
        return (info1, info2) -> info1.compareTo((RequestMappingInfo)info2, exchange2);
    }

    @Override
    public Mono<HandlerMethod> getHandlerInternal(ServerWebExchange exchange2) {
        exchange2.getAttributes().remove(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return super.getHandlerInternal(exchange2).doOnTerminate(() -> ProducesRequestCondition.clearMediaTypesAttribute(exchange2));
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, HandlerMethod handlerMethod, ServerWebExchange exchange2) {
        Set<MediaType> mediaTypes;
        Map<Object, Object> matrixVariables;
        Map<Object, Object> uriVariables;
        PathPattern bestPattern;
        super.handleMatch(info, handlerMethod, exchange2);
        PathContainer lookupPath = exchange2.getRequest().getPath().pathWithinApplication();
        Set<PathPattern> patterns = info.getPatternsCondition().getPatterns();
        if (patterns.isEmpty()) {
            bestPattern = this.getPathPatternParser().parse(lookupPath.value());
            uriVariables = Collections.emptyMap();
            matrixVariables = Collections.emptyMap();
        } else {
            bestPattern = patterns.iterator().next();
            PathPattern.PathMatchInfo result = bestPattern.matchAndExtract(lookupPath);
            Assert.notNull((Object)result, () -> "Expected bestPattern: " + bestPattern + " to match lookupPath " + lookupPath);
            uriVariables = result.getUriVariables();
            matrixVariables = result.getMatrixVariables();
        }
        exchange2.getAttributes().put(BEST_MATCHING_HANDLER_ATTRIBUTE, handlerMethod);
        exchange2.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestPattern);
        ServerHttpObservationFilter.findObservationContext(exchange2).ifPresent(context -> context.setPathPattern(bestPattern.toString()));
        ServerRequestObservationContext.findCurrent(exchange2.getAttributes()).ifPresent(context -> context.setPathPattern(bestPattern.toString()));
        exchange2.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
        exchange2.getAttributes().put(MATRIX_VARIABLES_ATTRIBUTE, matrixVariables);
        ProducesRequestCondition producesCondition = info.getProducesCondition();
        if (!producesCondition.isEmpty() && !(mediaTypes = producesCondition.getProducibleMediaTypes()).isEmpty()) {
            exchange2.getAttributes().put(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    @Override
    @Nullable
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> infos, ServerWebExchange exchange2) throws Exception {
        if (CollectionUtils.isEmpty(infos)) {
            return null;
        }
        PartialMatchHelper helper = new PartialMatchHelper(infos, exchange2);
        if (helper.isEmpty()) {
            return null;
        }
        ServerHttpRequest request = exchange2.getRequest();
        if (helper.hasMethodsMismatch()) {
            HttpMethod httpMethod = request.getMethod();
            Set<HttpMethod> methods = helper.getAllowedMethods();
            if (HttpMethod.OPTIONS.equals(httpMethod)) {
                Set<MediaType> mediaTypes = helper.getConsumablePatchMediaTypes();
                HttpOptionsHandler handler = new HttpOptionsHandler(methods, mediaTypes);
                return new HandlerMethod(handler, HTTP_OPTIONS_HANDLE_METHOD);
            }
            throw new MethodNotAllowedException(httpMethod, methods);
        }
        if (helper.hasConsumesMismatch()) {
            MediaType contentType;
            Set<MediaType> mediaTypes = helper.getConsumableMediaTypes();
            try {
                contentType = request.getHeaders().getContentType();
            }
            catch (InvalidMediaTypeException ex) {
                throw new UnsupportedMediaTypeStatusException(ex.getMessage(), new ArrayList<MediaType>(mediaTypes));
            }
            throw new UnsupportedMediaTypeStatusException(contentType, new ArrayList<MediaType>(mediaTypes), exchange2.getRequest().getMethod());
        }
        if (helper.hasProducesMismatch()) {
            Set<MediaType> mediaTypes = helper.getProducibleMediaTypes();
            throw new NotAcceptableStatusException(new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasParamsMismatch()) {
            throw new UnsatisfiedRequestParameterException(helper.getParamConditions().stream().map(Object::toString).toList(), request.getQueryParams());
        }
        return null;
    }

    static {
        try {
            HTTP_OPTIONS_HANDLE_METHOD = HttpOptionsHandler.class.getMethod("handle", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("No handler for HTTP OPTIONS", ex);
        }
    }

    private static final class PartialMatchHelper {
        private final List<PartialMatch> partialMatches = new ArrayList<PartialMatch>();

        PartialMatchHelper(Set<RequestMappingInfo> infos, ServerWebExchange exchange2) {
            for (RequestMappingInfo info : infos) {
                if (info.getPatternsCondition().getMatchingCondition(exchange2) == null) continue;
                this.partialMatches.add(new PartialMatch(info, exchange2));
            }
        }

        public boolean isEmpty() {
            return this.partialMatches.isEmpty();
        }

        public boolean hasMethodsMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasMethodsMatch);
        }

        public boolean hasConsumesMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasConsumesMatch);
        }

        public boolean hasProducesMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasProducesMatch);
        }

        public boolean hasParamsMismatch() {
            return this.partialMatches.stream().noneMatch(PartialMatch::hasParamsMatch);
        }

        public Set<HttpMethod> getAllowedMethods() {
            return this.partialMatches.stream().flatMap(m -> m.getInfo().getMethodsCondition().getMethods().stream()).map(requestMethod -> HttpMethod.valueOf(requestMethod.name())).collect(Collectors.toSet());
        }

        public Set<MediaType> getConsumableMediaTypes() {
            return this.partialMatches.stream().filter(PartialMatch::hasMethodsMatch).flatMap(m -> m.getInfo().getConsumesCondition().getConsumableMediaTypes().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public Set<MediaType> getProducibleMediaTypes() {
            return this.partialMatches.stream().filter(PartialMatch::hasConsumesMatch).flatMap(m -> m.getInfo().getProducesCondition().getProducibleMediaTypes().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public List<Set<NameValueExpression<String>>> getParamConditions() {
            return this.partialMatches.stream().filter(PartialMatch::hasProducesMatch).map(match -> match.getInfo().getParamsCondition().getExpressions()).toList();
        }

        public Set<MediaType> getConsumablePatchMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                Set<RequestMethod> methods = match.getInfo().getMethodsCondition().getMethods();
                if (!methods.isEmpty() && !methods.contains((Object)RequestMethod.PATCH)) continue;
                result.addAll(match.getInfo().getConsumesCondition().getConsumableMediaTypes());
            }
            return result;
        }

        private static class PartialMatch {
            private final RequestMappingInfo info;
            private final boolean methodsMatch;
            private final boolean consumesMatch;
            private final boolean producesMatch;
            private final boolean paramsMatch;

            public PartialMatch(RequestMappingInfo info, ServerWebExchange exchange2) {
                this.info = info;
                this.methodsMatch = info.getMethodsCondition().getMatchingCondition(exchange2) != null;
                this.consumesMatch = info.getConsumesCondition().getMatchingCondition(exchange2) != null;
                this.producesMatch = info.getProducesCondition().getMatchingCondition(exchange2) != null;
                this.paramsMatch = info.getParamsCondition().getMatchingCondition(exchange2) != null;
            }

            public RequestMappingInfo getInfo() {
                return this.info;
            }

            public boolean hasMethodsMatch() {
                return this.methodsMatch;
            }

            public boolean hasConsumesMatch() {
                return this.hasMethodsMatch() && this.consumesMatch;
            }

            public boolean hasProducesMatch() {
                return this.hasConsumesMatch() && this.producesMatch;
            }

            public boolean hasParamsMatch() {
                return this.hasProducesMatch() && this.paramsMatch;
            }

            public String toString() {
                return this.info.toString();
            }
        }
    }

    private static class HttpOptionsHandler {
        private final HttpHeaders headers = new HttpHeaders();

        public HttpOptionsHandler(Set<HttpMethod> declaredMethods, Set<MediaType> acceptPatch) {
            this.headers.setAllow(HttpOptionsHandler.initAllowedHttpMethods(declaredMethods));
            this.headers.setAcceptPatch(new ArrayList<MediaType>(acceptPatch));
        }

        private static Set<HttpMethod> initAllowedHttpMethods(Set<HttpMethod> declaredMethods) {
            if (declaredMethods.isEmpty()) {
                return Stream.of(HttpMethod.values()).filter(method -> !HttpMethod.TRACE.equals(method)).collect(Collectors.toSet());
            }
            LinkedHashSet<HttpMethod> result = new LinkedHashSet<HttpMethod>(declaredMethods);
            if (result.contains(HttpMethod.GET)) {
                result.add(HttpMethod.HEAD);
            }
            result.add(HttpMethod.OPTIONS);
            return result;
        }

        public HttpHeaders handle() {
            return this.headers;
        }
    }
}

