/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class BodyExtractors {
    private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, String.class);
    private static final ResolvableType MULTIPART_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, Part.class);
    private static final ResolvableType PART_TYPE = ResolvableType.forClass(Part.class);
    private static final ResolvableType VOID_TYPE = ResolvableType.forClass(Void.class);

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(Class<? extends T> elementClass) {
        return BodyExtractors.toMono(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ParameterizedTypeReference<T> elementTypeRef) {
        return BodyExtractors.toMono(ResolvableType.forType(elementTypeRef.getType()));
    }

    private static <T> BodyExtractor<Mono<T>, ReactiveHttpInputMessage> toMono(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> BodyExtractors.readToMono(inputMessage, context, elementType, reader), ex -> Mono.from(BodyExtractors.unsupportedErrorHandler(inputMessage, ex)), BodyExtractors.skipBodyAsMono(inputMessage));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(Class<? extends T> elementClass) {
        return BodyExtractors.toFlux(ResolvableType.forClass(elementClass));
    }

    public static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ParameterizedTypeReference<T> typeRef) {
        return BodyExtractors.toFlux(ResolvableType.forType(typeRef.getType()));
    }

    private static <T> BodyExtractor<Flux<T>, ReactiveHttpInputMessage> toFlux(ResolvableType elementType) {
        return (inputMessage, context) -> BodyExtractors.readWithMessageReaders(inputMessage, context, elementType, reader -> BodyExtractors.readToFlux(inputMessage, context, elementType, reader), ex -> BodyExtractors.unsupportedErrorHandler(inputMessage, ex), BodyExtractors.skipBodyAsFlux(inputMessage));
    }

    public static BodyExtractor<Mono<MultiValueMap<String, String>>, ReactiveHttpInputMessage> toFormData() {
        return (message, context) -> {
            ResolvableType elementType = FORM_DATA_TYPE;
            MediaType mediaType = MediaType.APPLICATION_FORM_URLENCODED;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToMono(message, context, elementType, reader);
        };
    }

    public static BodyExtractor<Mono<MultiValueMap<String, Part>>, ServerHttpRequest> toMultipartData() {
        return (serverRequest, context) -> {
            ResolvableType elementType = MULTIPART_DATA_TYPE;
            MediaType mediaType = MediaType.MULTIPART_FORM_DATA;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToMono(serverRequest, context, elementType, reader);
        };
    }

    public static BodyExtractor<Flux<Part>, ServerHttpRequest> toParts() {
        return (serverRequest, context) -> {
            ResolvableType elementType = PART_TYPE;
            MediaType mediaType = MediaType.MULTIPART_FORM_DATA;
            HttpMessageReader reader = BodyExtractors.findReader(elementType, mediaType, context);
            return BodyExtractors.readToFlux(serverRequest, context, elementType, reader);
        };
    }

    public static BodyExtractor<Flux<DataBuffer>, ReactiveHttpInputMessage> toDataBuffers() {
        return (inputMessage, context) -> inputMessage.getBody();
    }

    private static <T, S extends Publisher<T>> S readWithMessageReaders(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType elementType, Function<HttpMessageReader<T>, S> readerFunction, Function<UnsupportedMediaTypeException, S> errorFunction, Supplier<S> emptySupplier) {
        if (VOID_TYPE.equals(elementType)) {
            return (S)((Publisher)emptySupplier.get());
        }
        MediaType contentType = Optional.ofNullable(message.getHeaders().getContentType()).orElse(MediaType.APPLICATION_OCTET_STREAM);
        for (HttpMessageReader<?> messageReader : context.messageReaders()) {
            if (!messageReader.canRead(elementType, contentType)) continue;
            return (S)((Publisher)readerFunction.apply(BodyExtractors.cast(messageReader)));
        }
        List<MediaType> mediaTypes = context.messageReaders().stream().flatMap(reader -> reader.getReadableMediaTypes(elementType).stream()).toList();
        return (S)((Publisher)errorFunction.apply(new UnsupportedMediaTypeException(contentType, mediaTypes, elementType)));
    }

    private static <T> Mono<T> readToMono(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType type, HttpMessageReader<T> reader) {
        return context.serverResponse().map(response -> reader.readMono(type, type, (ServerHttpRequest)message, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.readMono(type, message, context.hints()));
    }

    private static <T> Flux<T> readToFlux(ReactiveHttpInputMessage message, BodyExtractor.Context context, ResolvableType type, HttpMessageReader<T> reader) {
        return context.serverResponse().map(response -> reader.read(type, type, (ServerHttpRequest)message, (ServerHttpResponse)response, context.hints())).orElseGet(() -> reader.read(type, message, context.hints()));
    }

    private static <T> Flux<T> unsupportedErrorHandler(ReactiveHttpInputMessage message, UnsupportedMediaTypeException ex) {
        Flux<Object> result = message.getHeaders().getContentType() == null ? message.getBody().map(buffer -> {
            DataBufferUtils.release(buffer);
            throw ex;
        }) : (message instanceof ClientHttpResponse ? BodyExtractors.consumeAndCancel(message).thenMany(Flux.error(ex)) : Flux.error(ex));
        return result;
    }

    private static <T> HttpMessageReader<T> findReader(ResolvableType elementType, MediaType mediaType, BodyExtractor.Context context) {
        for (HttpMessageReader<?> messageReader : context.messageReaders()) {
            if (!messageReader.canRead(elementType, mediaType)) continue;
            return BodyExtractors.cast(messageReader);
        }
        throw new IllegalStateException("No HttpMessageReader for \"" + mediaType + "\" and \"" + elementType + "\"");
    }

    private static <T> HttpMessageReader<T> cast(HttpMessageReader<?> reader) {
        return reader;
    }

    private static <T> Supplier<Flux<T>> skipBodyAsFlux(ReactiveHttpInputMessage message) {
        return message instanceof ClientHttpResponse ? () -> BodyExtractors.consumeAndCancel(message).thenMany(Mono.empty()) : Flux::empty;
    }

    private static <T> Supplier<Mono<T>> skipBodyAsMono(ReactiveHttpInputMessage message) {
        return message instanceof ClientHttpResponse ? () -> BodyExtractors.consumeAndCancel(message).then(Mono.empty()) : Mono::empty;
    }

    private static Flux<DataBuffer> consumeAndCancel(ReactiveHttpInputMessage message) {
        return message.getBody().takeWhile(buffer -> {
            DataBufferUtils.release(buffer);
            return false;
        });
    }
}

