/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.StandardServletPartUtils;
import org.springframework.web.util.WebUtils;

public class ServletRequestDataBinder
extends WebDataBinder {
    public ServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public ServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void construct(ServletRequest request) {
        this.construct(this.createValueResolver(request));
    }

    protected ServletRequestValueResolver createValueResolver(ServletRequest request) {
        return new ServletRequestValueResolver(request, this);
    }

    protected boolean shouldConstructArgument(MethodParameter param) {
        Class<?> type = param.nestedIfOptional().getNestedParameterType();
        return super.shouldConstructArgument(param) && !MultipartFile.class.isAssignableFrom(type) && !Part.class.isAssignableFrom(type);
    }

    public void bind(ServletRequest request) {
        HttpServletRequest httpServletRequest;
        if (this.shouldNotBindPropertyValues()) {
            return;
        }
        ServletRequestParameterPropertyValues mpvs = new ServletRequestParameterPropertyValues(request);
        MultipartRequest multipartRequest = WebUtils.getNativeRequest(request, MultipartRequest.class);
        if (multipartRequest != null) {
            this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
        } else if (ServletRequestDataBinder.isFormDataPost(request) && (httpServletRequest = WebUtils.getNativeRequest(request, HttpServletRequest.class)) != null && HttpMethod.POST.matches(httpServletRequest.getMethod())) {
            StandardServletPartUtils.bindParts(httpServletRequest, mpvs, this.isBindEmptyMultipartFiles());
        }
        this.addBindValues(mpvs, request);
        this.doBind(mpvs);
    }

    private static boolean isFormDataPost(ServletRequest request) {
        return StringUtils.startsWithIgnoreCase(request.getContentType(), "multipart/form-data");
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getBindingResult().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getBindingResult().getObjectName() + "'", (Throwable)new BindException(this.getBindingResult()));
        }
    }

    public static DataBinder.ValueResolver valueResolver(ServletRequest request, WebDataBinder binder) {
        return new ServletRequestValueResolver(request, binder);
    }

    protected static class ServletRequestValueResolver
    implements DataBinder.ValueResolver {
        private final ServletRequest request;
        private final WebDataBinder dataBinder;
        @Nullable
        private Set<String> parameterNames;

        protected ServletRequestValueResolver(ServletRequest request, WebDataBinder dataBinder) {
            this.request = request;
            this.dataBinder = dataBinder;
        }

        protected ServletRequest getRequest() {
            return this.request;
        }

        @Nullable
        public final Object resolveValue(String name, Class<?> paramType) {
            Object value = this.getRequestParameter(name, paramType);
            if (value == null) {
                value = this.dataBinder.resolvePrefixValue(name, paramType, this::getRequestParameter);
            }
            if (value == null) {
                value = this.getMultipartValue(name);
            }
            return value;
        }

        @Nullable
        protected Object getRequestParameter(String name, Class<?> type) {
            String[] value = this.request.getParameterValues(name);
            return ObjectUtils.isArray(value) && Array.getLength(value) == 1 ? Array.get(value, 0) : value;
        }

        @Nullable
        private Object getMultipartValue(String name) {
            Part parts;
            HttpServletRequest httpRequest;
            MultipartRequest multipartRequest = WebUtils.getNativeRequest(this.request, MultipartRequest.class);
            if (multipartRequest != null) {
                List<MultipartFile> files = multipartRequest.getFiles(name);
                if (!files.isEmpty()) {
                    return files.size() == 1 ? files.get(0) : files;
                }
            } else if (ServletRequestDataBinder.isFormDataPost(this.request) && (httpRequest = WebUtils.getNativeRequest(this.request, HttpServletRequest.class)) != null && HttpMethod.POST.matches(httpRequest.getMethod()) && !(parts = StandardServletPartUtils.getParts(httpRequest, name)).isEmpty()) {
                return parts.size() == 1 ? parts.get(0) : parts;
            }
            return null;
        }

        public Set<String> getNames() {
            if (this.parameterNames == null) {
                this.parameterNames = this.initParameterNames(this.request);
            }
            return this.parameterNames;
        }

        protected Set<String> initParameterNames(ServletRequest request) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                set.add((String)enumeration.nextElement());
            }
            return set;
        }
    }
}

