/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.thread.AutoLock;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedSinglePublisher<T>
extends AbstractSinglePublisher<T> {
    private static final Logger logger = LoggerFactory.getLogger(QueuedSinglePublisher.class);
    private final Queue<Object> items = new ArrayDeque<Object>();
    private long demand;
    private boolean stalled = true;
    private boolean active;
    private Throwable terminated;

    public void offer(T item) {
        if (logger.isDebugEnabled()) {
            logger.debug("offered item {} to {}", (Object)item, (Object)this);
        }
        this.process(item);
    }

    public void complete() {
        if (logger.isDebugEnabled()) {
            logger.debug("completed {}", (Object)this);
        }
        this.process(new Complete());
    }

    public boolean fail(Throwable failure) {
        if (logger.isDebugEnabled()) {
            logger.debug("failed {}", (Object)this, (Object)failure);
        }
        return this.process(new Failure(failure));
    }

    protected void tryProduce(Runnable producer) {
        boolean produce;
        try (AutoLock ignored = this.lock();){
            produce = this.demand > 0L && this.stalled;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("producing {} on {}", (Object)produce, (Object)this);
        }
        if (produce) {
            producer.run();
        }
    }

    public boolean hasDemand() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this.demand > 0L;
            return bl;
        }
    }

    @Override
    protected void onRequest(Subscriber<? super T> subscriber, long n) {
        boolean proceed = false;
        try (AutoLock ignored = this.lock();){
            this.demand = MathUtils.cappedAdd(this.demand, n);
            if (this.stalled) {
                this.stalled = false;
                proceed = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("demand {}, proceeding {} on {}", n, proceed, this);
        }
        if (proceed) {
            this.proceed(subscriber);
        }
    }

    private boolean process(Object item) {
        Subscriber subscriber;
        try (AutoLock ignored = this.lock();){
            if (this.terminated != null) {
                throw new IllegalStateException(this.terminated);
            }
            if (this.isTerminal(item)) {
                this.terminated = new CompletionException("terminated from " + Thread.currentThread(), null);
            }
            this.items.offer(item);
            subscriber = this.subscriber();
            if (subscriber != null && this.stalled) {
                this.stalled = false;
            }
        }
        if (subscriber != null) {
            this.proceed(subscriber);
            return true;
        }
        return false;
    }

    private void proceed(Subscriber<? super T> subscriber) {
        try (AutoLock ignored = this.lock();){
            if (this.active) {
                return;
            }
            this.active = true;
        }
        while (true) {
            Object t;
            boolean terminal;
            Object item;
            try (AutoLock ignored = this.lock();){
                item = this.items.peek();
                if (item == null) {
                    this.stalled = true;
                    this.active = false;
                    return;
                }
                terminal = this.isTerminal(item);
                if (!terminal) {
                    if (this.demand > 0L) {
                        --this.demand;
                    } else {
                        this.stalled = true;
                        this.active = false;
                        return;
                    }
                }
                item = this.items.poll();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("processing {} item {} by {}", terminal ? "last" : "next", item, this);
            }
            if (terminal) {
                t = (Terminal)item;
                t.notify(subscriber);
                continue;
            }
            t = item;
            this.onNext(subscriber, t);
        }
    }

    protected void onNext(Subscriber<? super T> subscriber, T item) {
        this.emitOnNext(subscriber, item);
    }

    private boolean isTerminal(Object item) {
        return item instanceof Terminal;
    }

    private class Complete
    implements Terminal<T> {
        private Complete() {
        }

        @Override
        public void notify(Subscriber<? super T> subscriber) {
            QueuedSinglePublisher.this.emitOnComplete(subscriber);
        }
    }

    private class Failure
    implements Terminal<T> {
        private final Throwable failure;

        private Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public void notify(Subscriber<? super T> subscriber) {
            QueuedSinglePublisher.this.emitOnError(subscriber, this.failure);
        }
    }

    @FunctionalInterface
    private static interface Terminal<T> {
        public void notify(Subscriber<? super T> var1);
    }
}

