/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.jetty.io.ByteBufferAggregator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.io.content.PathContentSource;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.Invocable;

public class IOResources {
    public static RetainableByteBuffer toRetainableByteBuffer(Resource resource2, ByteBufferPool bufferPool, boolean direct) throws IllegalArgumentException {
        RetainableByteBuffer retainableByteBuffer;
        block24: {
            if (resource2.isDirectory() || !resource2.exists()) {
                throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
            }
            if (resource2 instanceof MemoryResource) {
                MemoryResource memoryResource = (MemoryResource)resource2;
                return RetainableByteBuffer.wrap(ByteBuffer.wrap(memoryResource.getBytes()));
            }
            long longLength = resource2.length();
            if (longLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Resource length exceeds 2 GiB: " + String.valueOf(resource2));
            }
            int length = (int)longLength;
            bufferPool = bufferPool == null ? ByteBufferPool.NON_POOLING : bufferPool;
            Path path = resource2.getPath();
            if (path != null) {
                RetainableByteBuffer retainableByteBuffer2;
                block23: {
                    RetainableByteBuffer retainableByteBuffer3 = bufferPool.acquire(length, direct);
                    SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);
                    try {
                        int read;
                        ByteBuffer byteBuffer = retainableByteBuffer3.getByteBuffer();
                        int pos = BufferUtil.flipToFill(byteBuffer);
                        for (long totalRead = 0L; totalRead < (long)length && (read = seekableByteChannel.read(byteBuffer)) != -1; totalRead += (long)read) {
                        }
                        BufferUtil.flipToFlush(byteBuffer, pos);
                        retainableByteBuffer2 = retainableByteBuffer3;
                        if (seekableByteChannel == null) break block23;
                    }
                    catch (Throwable totalRead) {
                        try {
                            if (seekableByteChannel != null) {
                                try {
                                    seekableByteChannel.close();
                                }
                                catch (Throwable throwable) {
                                    totalRead.addSuppressed(throwable);
                                }
                            }
                            throw totalRead;
                        }
                        catch (IOException e) {
                            retainableByteBuffer3.release();
                            throw new RuntimeIOException(e);
                        }
                    }
                    seekableByteChannel.close();
                }
                return retainableByteBuffer2;
            }
            InputStream inputStream = resource2.newInputStream();
            try {
                int read;
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource2));
                }
                ByteBufferAggregator aggregator = new ByteBufferAggregator(bufferPool, direct, length > -1 ? length : 4096, length > -1 ? length : Integer.MAX_VALUE);
                byte[] byteArray = new byte[4096];
                while ((read = inputStream.read(byteArray)) != -1) {
                    aggregator.aggregate(ByteBuffer.wrap(byteArray, 0, read));
                }
                retainableByteBuffer = aggregator.takeRetainableByteBuffer();
                if (inputStream == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
            inputStream.close();
        }
        return retainableByteBuffer;
    }

    public static Content.Source asContentSource(Resource resource2, ByteBufferPool bufferPool, int bufferSize, boolean direct) throws IllegalArgumentException {
        if (resource2.isDirectory() || !resource2.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
        }
        Path path = resource2.getPath();
        if (path != null) {
            PathContentSource pathContentSource = new PathContentSource(path, bufferPool);
            if (bufferSize > 0) {
                pathContentSource.setBufferSize(bufferSize);
                pathContentSource.setUseDirectByteBuffers(direct);
            }
            return pathContentSource;
        }
        if (resource2 instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource2;
            byte[] bytes = memoryResource.getBytes();
            return new ByteBufferContentSource(ByteBuffer.wrap(bytes));
        }
        try {
            return new InputStreamContentSource(resource2.newInputStream());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static Content.Source asContentSource(Resource resource2, ByteBufferPool bufferPool, int bufferSize, boolean direct, long first, long length) throws IllegalArgumentException {
        if (resource2.isDirectory() || !resource2.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
        }
        Path path = resource2.getPath();
        if (path != null) {
            RangedPathContentSource contentSource = new RangedPathContentSource(path, bufferPool, first, length);
            if (bufferSize > 0) {
                contentSource.setBufferSize(bufferSize);
                contentSource.setUseDirectByteBuffers(direct);
            }
            return contentSource;
        }
        if (resource2 instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource2;
            return new ByteBufferContentSource(ByteBuffer.wrap(memoryResource.getBytes()));
        }
        try {
            InputStream inputStream = resource2.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource2));
            }
            RangedInputStreamContentSource contentSource = new RangedInputStreamContentSource(inputStream, bufferPool, first, length);
            if (bufferSize > 0) {
                contentSource.setBufferSize(bufferSize);
                contentSource.setUseDirectByteBuffers(direct);
            }
            return contentSource;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static InputStream asInputStream(Resource resource2) throws IllegalArgumentException {
        if (resource2.isDirectory() || !resource2.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
        }
        try {
            InputStream inputStream = resource2.newInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource does not support InputStream: " + String.valueOf(resource2));
            }
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void copy(Resource resource2, Content.Sink sink, ByteBufferPool bufferPool, int bufferSize, boolean direct, Callback callback) throws IllegalArgumentException {
        if (resource2.isDirectory() || !resource2.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
        }
        Path path = resource2.getPath();
        if (path != null) {
            try {
                new PathToSinkCopier(path, sink, bufferPool, bufferSize, direct, callback).iterate();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
            return;
        }
        if (resource2 instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource2;
            byte[] bytes = memoryResource.getBytes();
            sink.write(true, ByteBuffer.wrap(bytes), callback);
            return;
        }
        Content.Source source = IOResources.asContentSource(resource2, bufferPool, bufferSize, direct);
        Content.copy(source, sink, callback);
    }

    public static void copy(Resource resource2, Content.Sink sink, ByteBufferPool bufferPool, int bufferSize, boolean direct, long first, long length, Callback callback) throws IllegalArgumentException {
        if (resource2.isDirectory() || !resource2.exists()) {
            throw new IllegalArgumentException("Resource must exist and cannot be a directory: " + String.valueOf(resource2));
        }
        Path path = resource2.getPath();
        if (path != null) {
            try {
                new PathToSinkCopier(path, sink, bufferPool, bufferSize, direct, first, length, callback).iterate();
            }
            catch (Throwable x) {
                callback.failed(x);
            }
            return;
        }
        if (resource2 instanceof MemoryResource) {
            MemoryResource memoryResource = (MemoryResource)resource2;
            byte[] bytes = memoryResource.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            if (first >= 0L) {
                byteBuffer.position((int)first);
            }
            if (length >= 0L) {
                byteBuffer.limit((int)((long)byteBuffer.position() + length));
            }
            sink.write(true, byteBuffer, callback);
            return;
        }
        Content.Source source = IOResources.asContentSource(resource2, bufferPool, bufferSize, direct, first, length);
        Content.copy(source, sink, callback);
    }

    private static class RangedPathContentSource
    extends PathContentSource {
        private final long first;
        private final long length;
        private long toRead;

        public RangedPathContentSource(Path path, ByteBufferPool bufferPool, long first, long length) {
            super(path, bufferPool);
            this.first = first;
            this.length = length;
        }

        @Override
        protected SeekableByteChannel open() throws IOException {
            SeekableByteChannel channel = super.open();
            if (this.first > -1L) {
                channel.position(this.first);
            }
            this.toRead = this.length;
            return channel;
        }

        @Override
        protected int read(SeekableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
            int read = super.read(channel, byteBuffer);
            if (read <= 0) {
                return read;
            }
            if ((read = (int)Math.min((long)read, this.toRead)) > -1) {
                this.toRead -= (long)read;
                byteBuffer.position(read);
            }
            return read;
        }

        @Override
        protected boolean isReadComplete(long read) {
            return read == this.length;
        }
    }

    private static class RangedInputStreamContentSource
    extends InputStreamContentSource {
        private long toRead;

        public RangedInputStreamContentSource(InputStream inputStream, ByteBufferPool bufferPool, long first, long length) throws IOException {
            super(inputStream, bufferPool);
            inputStream.skipNBytes(first);
            this.toRead = length;
        }

        @Override
        protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer) throws IOException {
            if (this.toRead == 0L) {
                return -1;
            }
            int toReadInt = (int)Math.min(Integer.MAX_VALUE, this.toRead);
            int len = toReadInt > -1 ? Math.min(toReadInt, buffer.length) : buffer.length;
            int read = inputStream.read(buffer, 0, len);
            this.toRead -= (long)read;
            return read;
        }
    }

    private static class PathToSinkCopier
    extends IteratingNestedCallback {
        private final SeekableByteChannel channel;
        private final Content.Sink sink;
        private final ByteBufferPool pool;
        private final int bufferSize;
        private final boolean direct;
        private long remainingLength;
        private RetainableByteBuffer retainableByteBuffer;
        private boolean terminated;

        public PathToSinkCopier(Path path, Content.Sink sink, ByteBufferPool pool, int bufferSize, boolean direct, Callback callback) throws IOException {
            this(path, sink, pool, bufferSize, direct, -1L, -1L, callback);
        }

        public PathToSinkCopier(Path path, Content.Sink sink, ByteBufferPool pool, int bufferSize, boolean direct, long first, long length, Callback callback) throws IOException {
            super(callback);
            this.channel = Files.newByteChannel(path, new OpenOption[0]);
            if (first > -1L) {
                this.channel.position(first);
            }
            this.sink = sink;
            this.pool = pool == null ? ByteBufferPool.NON_POOLING : pool;
            this.bufferSize = bufferSize <= 0 ? 4096 : bufferSize;
            this.direct = direct;
            this.remainingLength = length;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        protected IteratingCallback.Action process() throws Throwable {
            if (this.terminated) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this.retainableByteBuffer == null) {
                this.retainableByteBuffer = this.pool.acquire(this.bufferSize, this.direct);
            }
            ByteBuffer byteBuffer = this.retainableByteBuffer.getByteBuffer();
            BufferUtil.clearToFill(byteBuffer);
            if (this.remainingLength >= 0L && this.remainingLength < Integer.MAX_VALUE) {
                byteBuffer.limit((int)Math.min((long)byteBuffer.capacity(), this.remainingLength));
            }
            boolean eof = false;
            while (byteBuffer.hasRemaining() && !eof) {
                int read = this.channel.read(byteBuffer);
                if (read == -1) {
                    eof = true;
                    continue;
                }
                if (this.remainingLength < 0L) continue;
                this.remainingLength -= (long)read;
            }
            BufferUtil.flipToFlush(byteBuffer, 0);
            this.terminated = eof || this.remainingLength == 0L;
            this.sink.write(this.terminated, byteBuffer, this);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            IO.close(this.channel);
            super.onCompleteSuccess();
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            if (this.retainableByteBuffer != null) {
                this.retainableByteBuffer.release();
            }
            IO.close(this.channel);
            super.onCompleteFailure(x);
        }
    }
}

