/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport.internal;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.internal.HttpChannelOverHTTP;
import org.eclipse.jetty.client.transport.internal.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP.class);
    private final LongAdder inMessages = new LongAdder();
    private final HttpParser parser;
    private final ByteBufferPool byteBufferPool;
    private RetainableByteBuffer networkBuffer;
    private boolean shutdown;
    private boolean complete;
    private boolean unsolicited;
    private String method;
    private int status;
    private Content.Chunk chunk;
    private Runnable action;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        HttpClient httpClient = channel.getHttpDestination().getHttpClient();
        this.parser = new HttpParser(this, httpClient.getMaxResponseHeadersSize(), httpClient.getHttpCompliance());
        HttpClientTransport transport = httpClient.getTransport();
        if (transport instanceof HttpClientTransportOverHTTP) {
            HttpClientTransportOverHTTP httpTransport = (HttpClientTransportOverHTTP)transport;
            this.parser.setHeaderCacheSize(httpTransport.getHeaderCacheSize());
            this.parser.setHeaderCacheCaseSensitive(httpTransport.isHeaderCacheCaseSensitive());
        }
        this.byteBufferPool = httpClient.getByteBufferPool();
    }

    void receive() {
        if (!this.hasContent()) {
            boolean setFillInterest = this.parseAndFill();
            if (!this.hasContent() && setFillInterest) {
                this.fillInterested();
            }
        } else {
            this.responseContentAvailable();
        }
    }

    @Override
    protected void onInterim() {
        this.receive();
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    @Override
    public Content.Chunk read(boolean fillInterestIfNeeded) {
        Content.Chunk chunk;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading, fillInterestIfNeeded={} in {}", (Object)fillInterestIfNeeded, (Object)this);
        }
        if ((chunk = this.consumeChunk()) != null) {
            return chunk;
        }
        boolean needFillInterest = this.parseAndFill();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ParseAndFill needFillInterest {} in {}", (Object)needFillInterest, (Object)this);
        }
        if ((chunk = this.consumeChunk()) != null) {
            return chunk;
        }
        if (needFillInterest && fillInterestIfNeeded) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read null, filled 0, fill interest requested -> call fillInterested in {}", (Object)this);
            }
            this.fillInterested();
        }
        return null;
    }

    private Content.Chunk consumeChunk() {
        Content.Chunk chunk = this.chunk;
        this.chunk = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receiver consuming chunk {} in {}", (Object)chunk, (Object)this);
        }
        return chunk;
    }

    @Override
    public void failAndClose(Throwable failure) {
        this.responseFailure(failure, Promise.from(failed -> {
            if (failed.booleanValue()) {
                this.getHttpConnection().close(failure);
            }
        }, x -> this.getHttpConnection().close(failure)));
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        return this.networkBuffer == null ? null : this.networkBuffer.getByteBuffer();
    }

    private void acquireNetworkBuffer() {
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired {} in {}", (Object)this.networkBuffer, (Object)this);
        }
    }

    private void reacquireNetworkBuffer() {
        RetainableByteBuffer currentBuffer = this.networkBuffer;
        if (currentBuffer == null) {
            throw new IllegalStateException();
        }
        if (currentBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        currentBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {} <- {} in {}", currentBuffer, this.networkBuffer, this);
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        boolean direct = client.isUseInputDirectByteBuffers();
        return this.byteBufferPool.acquire(client.getResponseBufferSize(), direct);
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {} in {}", (Object)this.networkBuffer, (Object)this);
        }
        this.networkBuffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        RetainableByteBuffer networkBuffer = this.networkBuffer;
        if (networkBuffer == null) {
            return null;
        }
        ByteBuffer upgradeBuffer = null;
        if (networkBuffer.hasRemaining()) {
            HttpClient client = this.getHttpDestination().getHttpClient();
            upgradeBuffer = BufferUtil.allocate(networkBuffer.remaining(), client.isUseInputDirectByteBuffers());
            BufferUtil.clearToFill(upgradeBuffer);
            BufferUtil.put(networkBuffer.getByteBuffer(), upgradeBuffer);
            BufferUtil.flipToFlush(upgradeBuffer, 0);
        }
        this.releaseNetworkBuffer();
        return upgradeBuffer;
    }

    private boolean parseAndFill() {
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        EndPoint endPoint = connection.getEndPoint();
        try {
            int read;
            if (this.networkBuffer == null) {
                this.acquireNetworkBuffer();
            }
            while (true) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsing {} in {}", (Object)BufferUtil.toDetailString(this.networkBuffer.getByteBuffer()), (Object)this);
                }
                if (this.parse()) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parser willing to advance in {}", (Object)this);
                }
                if (connection.isClosed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closed {} in {}", (Object)connection, (Object)this);
                    }
                    this.releaseNetworkBuffer();
                    return false;
                }
                if (this.networkBuffer.isRetained()) {
                    this.reacquireNetworkBuffer();
                }
                read = endPoint.fill(this.networkBuffer.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes in {} from {} in {}", read, this.networkBuffer, endPoint, this);
                }
                if (read <= 0) break;
                connection.addBytesIn(read);
            }
            if (read == 0) {
                this.releaseNetworkBuffer();
                return true;
            }
            this.releaseNetworkBuffer();
            this.shutdown();
            return false;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error processing {} in {}", endPoint, this, x);
            }
            this.releaseNetworkBuffer();
            this.failAndClose(x);
            return false;
        }
    }

    private boolean parse() {
        do {
            Runnable action;
            boolean handle2 = this.parser.parseNext(this.networkBuffer.getByteBuffer());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse result={} on {}", (Object)handle2, (Object)this);
            }
            if ((action = this.getAndSetAction(null)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing action after parser returned: {} on {}", (Object)action, (Object)this);
                }
                action.run();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Action executed after Parse result={} on {}", (Object)handle2, (Object)this);
                }
            }
            if (handle2) {
                return !this.parser.isClose();
            }
            boolean complete = this.complete;
            this.complete = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse complete={}, {} {} in {}", complete, this.networkBuffer, this.parser, this);
            }
            if (!complete) continue;
            int status = this.status;
            this.status = 0;
            if (status == 101) {
                return true;
            }
            String method = this.method;
            this.method = null;
            if (this.getHttpChannel().isTunnel(method, status)) {
                return true;
            }
            if (!this.networkBuffer.hasRemaining()) {
                return false;
            }
            if (!HttpStatus.isInformational(status)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discarding unexpected content after response {}: {} in {}", status, this.networkBuffer, this);
                }
                this.networkBuffer.clear();
            }
            return false;
        } while (this.networkBuffer.hasRemaining());
        return false;
    }

    protected void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering as fill interested in {}", (Object)this);
        }
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange2 = this.getHttpExchange();
        boolean bl = this.unsolicited = exchange2 == null;
        if (exchange2 == null) {
            return;
        }
        this.method = exchange2.getRequest().getMethod();
        this.status = status;
        this.parser.setHeadResponse(HttpMethod.HEAD.is(this.method) || this.getHttpChannel().isTunnel(this.method, status));
        exchange2.getResponse().version(version).status(status).reason(reason);
        this.responseBegin(exchange2);
    }

    @Override
    public void parsedHeader(HttpField field) {
        HttpExchange exchange2 = this.getHttpExchange();
        this.unsolicited |= exchange2 == null;
        if (this.unsolicited) {
            return;
        }
        this.responseHeader(exchange2, field);
    }

    @Override
    public boolean headerComplete() {
        HttpExchange exchange2 = this.getHttpExchange();
        this.unsolicited |= exchange2 == null;
        if (this.unsolicited) {
            return false;
        }
        exchange2.getRequest().getConversation().setAttribute(EndPoint.class.getName(), this.getHttpConnection().getEndPoint());
        this.getHttpConnection().onResponseHeaders(exchange2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting action to responseHeaders(exchange, boolean) on {}", (Object)this);
        }
        if (this.getAndSetAction(() -> this.responseHeaders(exchange2)) != null) {
            throw new IllegalStateException();
        }
        return true;
    }

    @Override
    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parser generated content {} in {}", (Object)BufferUtil.toDetailString(buffer), (Object)this);
        }
        this.unsolicited |= (exchange2 = this.getHttpExchange()) == null;
        if (this.unsolicited) {
            return false;
        }
        if (this.chunk != null) {
            throw new IllegalStateException("Content generated with unconsumed content left");
        }
        this.networkBuffer.retain();
        this.chunk = Content.Chunk.asChunk(buffer, false, this.networkBuffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting action to responseContentAvailable on {}", (Object)this);
        }
        if (this.getAndSetAction(() -> this.responseContentAvailable()) != null) {
            throw new IllegalStateException();
        }
        if (this.getHttpConnection().isFillInterested()) {
            throw new IllegalStateException();
        }
        return true;
    }

    @Override
    public boolean contentComplete() {
        return false;
    }

    @Override
    public void parsedTrailer(HttpField trailer) {
        HttpExchange exchange2 = this.getHttpExchange();
        this.unsolicited |= exchange2 == null;
        if (this.unsolicited) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending trailer '{}' to response in {}", (Object)trailer, (Object)this);
        }
        exchange2.getResponse().trailer(trailer);
    }

    @Override
    public boolean messageComplete() {
        Runnable task;
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null || this.unsolicited) {
            this.getHttpConnection().close();
            return false;
        }
        int status = exchange2.getResponse().getStatus();
        if (!HttpStatus.isInterim(status)) {
            this.inMessages.increment();
            this.complete = true;
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        this.chunk = Content.Chunk.EOF;
        boolean isUpgrade = status == 101;
        boolean isTunnel = this.getHttpChannel().isTunnel(this.method, status);
        Runnable runnable = task = isUpgrade || isTunnel ? null : this::receiveNext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message complete, calling response success with task {} in {}", (Object)task, (Object)this);
        }
        this.responseSuccess(exchange2, task);
        return false;
    }

    private void receiveNext() {
        if (this.hasContent()) {
            throw new IllegalStateException();
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Receiving next request in {}", (Object)this);
        }
        boolean setFillInterest = this.parseAndFill();
        if (!this.hasContent() && setFillInterest) {
            this.fillInterested();
        }
    }

    @Override
    public void earlyEOF() {
        HttpExchange exchange2 = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange2 == null || this.unsolicited) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    @Override
    public void badMessage(HttpException failure) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null || this.unsolicited) {
            this.getHttpConnection().close();
        } else {
            HttpResponse response = exchange2.getResponse();
            response.status(failure.getCode()).reason(failure.getReason());
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + String.valueOf(this.getHttpConnection()), response, (Throwable)((Object)failure)));
        }
    }

    private Runnable getAndSetAction(Runnable action) {
        Runnable r = this.action;
        this.action = action;
        return r;
    }

    long getMessagesIn() {
        return this.inMessages.longValue();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }
}

