/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannel.class);
    private final AutoLock _lock = new AutoLock();
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    public boolean associate(HttpExchange exchange2) {
        boolean result = false;
        boolean abort = true;
        try (AutoLock ignored = this._lock.lock();){
            if (this._exchange == null) {
                abort = false;
                result = exchange2.associate(this);
                if (result) {
                    this._exchange = exchange2;
                }
            }
        }
        HttpRequest request = exchange2.getRequest();
        if (abort) {
            request.abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else {
            request.setConnection(this.getConnection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} associated {} to {}", exchange2, result, this);
            }
        }
        return result;
    }

    public boolean disassociate(HttpExchange exchange2) {
        boolean result = false;
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange2) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", exchange2, result, this);
        }
        return result;
    }

    public HttpExchange getHttpExchange() {
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange httpExchange = this._exchange;
            return httpExchange;
        }
    }

    protected abstract Connection getConnection();

    @Override
    public long getExpireNanoTime() {
        HttpExchange exchange2 = this.getHttpExchange();
        return exchange2 != null ? exchange2.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 != null) {
            this.send(exchange2);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange2, Throwable failure) {
        this.getHttpSender().proceed(exchange2, failure);
    }

    public void abort(HttpExchange exchange2, Throwable requestFailure, Throwable responseFailure, Promise<Boolean> promise) {
        Promise.Completable<Boolean> requestPromise = new Promise.Completable<Boolean>();
        if (requestFailure != null) {
            this.getHttpSender().abort(exchange2, requestFailure, requestPromise);
        } else {
            requestPromise.succeeded(false);
        }
        Promise.Completable<Boolean> responsePromise = new Promise.Completable<Boolean>();
        if (responseFailure != null) {
            this.abortResponse(exchange2, responseFailure, responsePromise);
        } else {
            responsePromise.succeeded(false);
        }
        promise.completeWith((CompletableFuture<Boolean>)requestPromise.thenCombine(responsePromise, (requestAborted, responseAborted) -> requestAborted != false || responseAborted != false));
    }

    public void abortResponse(HttpExchange exchange2, Throwable failure, Promise<Boolean> promise) {
        this.getHttpReceiver().abort(exchange2, failure, promise);
    }

    public Result exchangeTerminating(HttpExchange exchange2, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange exchange2, Result result) {
        this.disassociate(exchange2);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

