/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.util.component.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestListeners
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(RequestListeners.class);
    private Request.QueuedListener queuedListener;
    private Request.BeginListener beginListener;
    private Request.HeadersListener headersListener;
    private Request.CommitListener commitListener;
    private Request.ContentListener contentListener;
    private Request.SuccessListener successListener;
    private Request.FailureListener failureListener;

    public boolean addListener(Request.Listener listener) {
        return this.addQueuedListener(listener) | this.addBeginListener(listener) | this.addHeadersListener(listener) | this.addCommitListener(listener) | this.addContentListener(listener) | this.addSuccessListener(listener) | this.addFailureListener(listener);
    }

    public boolean removeListener(Request.Listener listener) {
        return this.removeQueuedListener(listener) | this.removeBeginListener(listener) | this.removeHeadersListener(listener) | this.removeCommitListener(listener) | this.removeContentListener(listener) | this.removeSuccessListener(listener) | this.removeFailureListener(listener);
    }

    public boolean addQueuedListener(Request.QueuedListener listener) {
        if (listener == null) {
            return false;
        }
        Request.QueuedListener existing = this.queuedListener;
        this.queuedListener = existing == null ? listener : new QueuedListenerLink(existing, listener);
        return true;
    }

    public boolean removeQueuedListener(Request.QueuedListener listener) {
        QueuedListenerLink link;
        Request.QueuedListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.queuedListener == listener) {
            this.queuedListener = null;
            return true;
        }
        Request.QueuedListener queuedListener = this.queuedListener;
        if (queuedListener instanceof QueuedListenerLink && (remaining = (link = (QueuedListenerLink)queuedListener).remove(listener)) != null) {
            this.queuedListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyQueued(Request.QueuedListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onQueued(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addBeginListener(Request.BeginListener listener) {
        if (listener == null) {
            return false;
        }
        Request.BeginListener existing = this.beginListener;
        this.beginListener = existing == null ? listener : new BeginListenerLink(existing, listener);
        return true;
    }

    public boolean removeBeginListener(Request.BeginListener listener) {
        BeginListenerLink link;
        Request.BeginListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.beginListener == listener) {
            this.beginListener = null;
            return true;
        }
        Request.BeginListener beginListener = this.beginListener;
        if (beginListener instanceof BeginListenerLink && (remaining = (link = (BeginListenerLink)beginListener).remove(listener)) != null) {
            this.beginListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyBegin(Request.BeginListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onBegin(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addHeadersListener(Request.HeadersListener listener) {
        if (listener == null) {
            return false;
        }
        Request.HeadersListener existing = this.headersListener;
        this.headersListener = existing == null ? listener : new HeadersListenerLink(existing, listener);
        return true;
    }

    public boolean removeHeadersListener(Request.HeadersListener listener) {
        HeadersListenerLink link;
        Request.HeadersListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.headersListener == listener) {
            this.headersListener = null;
            return true;
        }
        Request.HeadersListener headersListener = this.headersListener;
        if (headersListener instanceof HeadersListenerLink && (remaining = (link = (HeadersListenerLink)headersListener).remove(listener)) != null) {
            this.headersListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyHeaders(Request.HeadersListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onHeaders(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addCommitListener(Request.CommitListener listener) {
        if (listener == null) {
            return false;
        }
        Request.CommitListener existing = this.commitListener;
        this.commitListener = existing == null ? listener : new CommitListenerLink(existing, listener);
        return true;
    }

    public boolean removeCommitListener(Request.CommitListener listener) {
        CommitListenerLink link;
        Request.CommitListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.commitListener == listener) {
            this.commitListener = null;
            return true;
        }
        Request.CommitListener commitListener = this.commitListener;
        if (commitListener instanceof CommitListenerLink && (remaining = (link = (CommitListenerLink)commitListener).remove(listener)) != null) {
            this.commitListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyCommit(Request.CommitListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onCommit(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addContentListener(Request.ContentListener listener) {
        if (listener == null) {
            return false;
        }
        Request.ContentListener existing = this.contentListener;
        this.contentListener = existing == null ? listener : new ContentListenerLink(existing, listener);
        return true;
    }

    public boolean removeContentListener(Request.ContentListener listener) {
        ContentListenerLink link;
        Request.ContentListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.contentListener == listener) {
            this.contentListener = null;
            return true;
        }
        Request.ContentListener contentListener = this.contentListener;
        if (contentListener instanceof ContentListenerLink && (remaining = (link = (ContentListenerLink)contentListener).remove(listener)) != null) {
            this.contentListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyContent(Request.ContentListener listener, Request request, ByteBuffer byteBuffer) {
        try {
            if (listener != null) {
                byteBuffer.clear();
                listener.onContent(request, byteBuffer);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addSuccessListener(Request.SuccessListener listener) {
        if (listener == null) {
            return false;
        }
        Request.SuccessListener existing = this.successListener;
        this.successListener = existing == null ? listener : new SuccessListenerLink(existing, listener);
        return true;
    }

    public boolean removeSuccessListener(Request.SuccessListener listener) {
        SuccessListenerLink link;
        Request.SuccessListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.successListener == listener) {
            this.successListener = null;
            return true;
        }
        Request.SuccessListener successListener = this.successListener;
        if (successListener instanceof SuccessListenerLink && (remaining = (link = (SuccessListenerLink)successListener).remove(listener)) != null) {
            this.successListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifySuccess(Request.SuccessListener listener, Request request) {
        try {
            if (listener != null) {
                listener.onSuccess(request);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean addFailureListener(Request.FailureListener listener) {
        if (listener == null) {
            return false;
        }
        Request.FailureListener existing = this.failureListener;
        this.failureListener = existing == null ? listener : new FailureListenerLink(existing, listener);
        return true;
    }

    public boolean removeFailureListener(Request.FailureListener listener) {
        FailureListenerLink link;
        Request.FailureListener remaining;
        if (listener == null) {
            return false;
        }
        if (this.failureListener == listener) {
            this.failureListener = null;
            return true;
        }
        Request.FailureListener failureListener = this.failureListener;
        if (failureListener instanceof FailureListenerLink && (remaining = (link = (FailureListenerLink)failureListener).remove(listener)) != null) {
            this.failureListener = remaining;
            return true;
        }
        return false;
    }

    protected static void notifyFailure(Request.FailureListener listener, Request request, Throwable failure) {
        try {
            if (listener != null) {
                listener.onFailure(request, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void clear() {
        this.queuedListener = null;
        this.beginListener = null;
        this.headersListener = null;
        this.commitListener = null;
        this.contentListener = null;
        this.successListener = null;
        this.failureListener = null;
    }

    protected Request.QueuedListener getQueuedListener() {
        return this.queuedListener;
    }

    protected Request.BeginListener getBeginListener() {
        return this.beginListener;
    }

    protected Request.HeadersListener getHeadersListener() {
        return this.headersListener;
    }

    protected Request.CommitListener getCommitListener() {
        return this.commitListener;
    }

    protected Request.ContentListener getContentListener() {
        return this.contentListener;
    }

    protected Request.SuccessListener getSuccessListener() {
        return this.successListener;
    }

    protected Request.FailureListener getFailureListener() {
        return this.failureListener;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, new ListenerDump("queued", this.getQueuedListener()), new ListenerDump("begin", this.getBeginListener()), new ListenerDump("headers", this.getHeadersListener()), new ListenerDump("commit", this.getCommitListener()), new ListenerDump("content", this.getContentListener()), new ListenerDump("success", this.getSuccessListener()), new ListenerDump("failure", this.getFailureListener()));
    }

    private static class QueuedListenerLink
    extends Link<Request.QueuedListener, QueuedListenerLink>
    implements Request.QueuedListener {
        private QueuedListenerLink(Request.QueuedListener prev, Request.QueuedListener next) {
            super(QueuedListenerLink.class, QueuedListenerLink::new, prev, next);
        }

        @Override
        public void onQueued(Request request) {
            RequestListeners.notifyQueued((Request.QueuedListener)this.prev, request);
            RequestListeners.notifyQueued((Request.QueuedListener)this.next, request);
        }
    }

    private static class BeginListenerLink
    extends Link<Request.BeginListener, BeginListenerLink>
    implements Request.BeginListener {
        private BeginListenerLink(Request.BeginListener prev, Request.BeginListener next) {
            super(BeginListenerLink.class, BeginListenerLink::new, prev, next);
        }

        @Override
        public void onBegin(Request request) {
            RequestListeners.notifyBegin((Request.BeginListener)this.prev, request);
            RequestListeners.notifyBegin((Request.BeginListener)this.next, request);
        }
    }

    private static class HeadersListenerLink
    extends Link<Request.HeadersListener, HeadersListenerLink>
    implements Request.HeadersListener {
        private HeadersListenerLink(Request.HeadersListener prev, Request.HeadersListener next) {
            super(HeadersListenerLink.class, HeadersListenerLink::new, prev, next);
        }

        @Override
        public void onHeaders(Request request) {
            RequestListeners.notifyHeaders((Request.HeadersListener)this.prev, request);
            RequestListeners.notifyHeaders((Request.HeadersListener)this.next, request);
        }
    }

    private static class CommitListenerLink
    extends Link<Request.CommitListener, CommitListenerLink>
    implements Request.CommitListener {
        private CommitListenerLink(Request.CommitListener prev, Request.CommitListener next) {
            super(CommitListenerLink.class, CommitListenerLink::new, prev, next);
        }

        @Override
        public void onCommit(Request request) {
            RequestListeners.notifyCommit((Request.CommitListener)this.prev, request);
            RequestListeners.notifyCommit((Request.CommitListener)this.next, request);
        }
    }

    private static class ContentListenerLink
    extends Link<Request.ContentListener, ContentListenerLink>
    implements Request.ContentListener {
        private ContentListenerLink(Request.ContentListener prev, Request.ContentListener next) {
            super(ContentListenerLink.class, ContentListenerLink::new, prev, next);
        }

        @Override
        public void onContent(Request request, ByteBuffer content) {
            RequestListeners.notifyContent((Request.ContentListener)this.prev, request, content);
            RequestListeners.notifyContent((Request.ContentListener)this.next, request, content);
        }
    }

    private static class SuccessListenerLink
    extends Link<Request.SuccessListener, SuccessListenerLink>
    implements Request.SuccessListener {
        private SuccessListenerLink(Request.SuccessListener prev, Request.SuccessListener next) {
            super(SuccessListenerLink.class, SuccessListenerLink::new, prev, next);
        }

        @Override
        public void onSuccess(Request request) {
            RequestListeners.notifySuccess((Request.SuccessListener)this.prev, request);
            RequestListeners.notifySuccess((Request.SuccessListener)this.next, request);
        }
    }

    private static class FailureListenerLink
    extends Link<Request.FailureListener, FailureListenerLink>
    implements Request.FailureListener {
        private FailureListenerLink(Request.FailureListener prev, Request.FailureListener next) {
            super(FailureListenerLink.class, FailureListenerLink::new, prev, next);
        }

        @Override
        public void onFailure(Request request, Throwable failure) {
            RequestListeners.notifyFailure((Request.FailureListener)this.prev, request, failure);
            RequestListeners.notifyFailure((Request.FailureListener)this.next, request, failure);
        }
    }

    private record ListenerDump(String name, Object listener) {
        @Override
        public String toString() {
            return this.name + " = " + String.valueOf(this.listener);
        }
    }

    private static class Link<T, L extends Link<T, L>> {
        private final Class<L> type;
        private final BiFunction<T, T, L> ctor;
        protected final T prev;
        protected final T next;

        protected Link(Class<L> type, BiFunction<T, T, L> ctor, T prev, T next) {
            this.type = type;
            this.ctor = ctor;
            this.prev = prev;
            this.next = next;
        }

        protected T remove(T listener) {
            if (this.next == listener) {
                return this.prev;
            }
            if (this.type.isInstance(this.prev)) {
                T remaining = ((Link)this.type.cast(this.prev)).remove(listener);
                if (remaining != null) {
                    return (T)this.ctor.apply(remaining, this.next);
                }
                return null;
            }
            if (this.prev == listener) {
                return this.next;
            }
            return null;
        }

        public String toString() {
            return "%s@%x(%s,%s)".formatted(this.getClass().getSimpleName(), this.hashCode(), this.prev, this.next);
        }
    }
}

