/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.NonSymmetricMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public class CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecomposition(RealMatrix matrix, double relativeSymmetryThreshold, double absolutePositivityThreshold) {
        int i2;
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        this.lTData = matrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        for (i2 = 0; i2 < order; ++i2) {
            double[] lI = this.lTData[i2];
            for (int j = i2 + 1; j < order; ++j) {
                double[] lJ = this.lTData[j];
                double lIJ = lI[j];
                double lJI = lJ[i2];
                double maxDelta = relativeSymmetryThreshold * FastMath.max(FastMath.abs(lIJ), FastMath.abs(lJI));
                if (FastMath.abs(lIJ - lJI) > maxDelta) {
                    throw new NonSymmetricMatrixException(i2, j, relativeSymmetryThreshold);
                }
                lJ[i2] = 0.0;
            }
        }
        for (i2 = 0; i2 < order; ++i2) {
            double[] ltI = this.lTData[i2];
            if (ltI[i2] <= absolutePositivityThreshold) {
                throw new NonPositiveDefiniteMatrixException(ltI[i2], i2, absolutePositivityThreshold);
            }
            ltI[i2] = FastMath.sqrt(ltI[i2]);
            double inverse = 1.0 / ltI[i2];
            for (int q = order - 1; q > i2; --q) {
                int n = q;
                ltI[n] = ltI[n] * inverse;
                double[] ltQ = this.lTData[q];
                for (int p = q; p < order; ++p) {
                    int n2 = p;
                    ltQ[n2] = ltQ[n2] - ltI[q] * ltI[p];
                }
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (int i2 = 0; i2 < this.lTData.length; ++i2) {
            double lTii = this.lTData[i2][i2];
            determinant *= lTii * lTii;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lTData);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lTData;

        private Solver(double[][] lTData) {
            this.lTData = lTData;
        }

        public boolean isNonSingular() {
            return true;
        }

        public RealVector solve(RealVector b) {
            int j;
            int m = this.lTData.length;
            if (b.getDimension() != m) {
                throw new DimensionMismatchException(b.getDimension(), m);
            }
            double[] x = b.toArray();
            for (j = 0; j < m; ++j) {
                double[] lJ = this.lTData[j];
                int n = j;
                x[n] = x[n] / lJ[j];
                double xJ = x[j];
                for (int i2 = j + 1; i2 < m; ++i2) {
                    int n2 = i2;
                    x[n2] = x[n2] - xJ * lJ[i2];
                }
            }
            for (j = m - 1; j >= 0; --j) {
                int n = j;
                x[n] = x[n] / this.lTData[j][j];
                double xJ = x[j];
                for (int i3 = 0; i3 < j; ++i3) {
                    int n3 = i3;
                    x[n3] = x[n3] - xJ * this.lTData[i3][j];
                }
            }
            return new ArrayRealVector(x, false);
        }

        public RealMatrix solve(RealMatrix b) {
            int j;
            int m = this.lTData.length;
            if (b.getRowDimension() != m) {
                throw new DimensionMismatchException(b.getRowDimension(), m);
            }
            int nColB = b.getColumnDimension();
            double[][] x = b.getData();
            for (j = 0; j < m; ++j) {
                double[] lJ = this.lTData[j];
                double lJJ = lJ[j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                for (int i2 = j + 1; i2 < m; ++i2) {
                    double[] xI = x[i2];
                    double lJI = lJ[i2];
                    for (int k2 = 0; k2 < nColB; ++k2) {
                        int n = k2;
                        xI[n] = xI[n] - xJ[k2] * lJI;
                    }
                }
            }
            for (j = m - 1; j >= 0; --j) {
                double lJJ = this.lTData[j][j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                for (int i3 = 0; i3 < j; ++i3) {
                    double[] xI = x[i3];
                    double lIJ = this.lTData[i3][j];
                    for (int k3 = 0; k3 < nColB; ++k3) {
                        int n = k3;
                        xI[n] = xI[n] - xJ[k3] * lIJ;
                    }
                }
            }
            return new Array2DRowRealMatrix(x);
        }

        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.lTData.length));
        }
    }
}

