/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openjdk.jmh.runner.AbstractResourceReader;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.Utils;

public class CompilerHints
extends AbstractResourceReader {
    public static final String LIST = "/META-INF/CompilerHints";
    static final String[] HINT_COMPATIBLE_JVMS = new String[]{"OpenJDK", "HotSpot", "GraalVM"};
    static final String JVM_ZING = "Zing";
    private static volatile CompilerHints defaultList;
    private static volatile String hintsFile;
    private final Set<String> hints = Collections.unmodifiableSet(this.read());
    static final String XX_COMPILE_COMMAND_FILE = "-XX:CompileCommandFile=";
    static final String BLACKHOLE_MODE_NAME = "jmh.blackhole.mode";
    static final String BLACKHOLE_AUTODETECT_NAME = "jmh.blackhole.autoDetect";
    static final String BLACKHOLE_DEBUG_NAME = "jmh.blackhole.debug";
    static final String COMPILER_HINTS_MODE = "jmh.compilerhints.mode";
    static final boolean BLACKHOLE_MODE_AUTODETECT;
    static final boolean BLACKHOLE_MODE_DEBUG;
    static CompilerHintsSelect compilerHintsSelect;
    private static BlackholeMode blackholeMode;
    private static BlackholeSelect blackholeSelect;

    public static CompilerHints defaultList() {
        if (defaultList == null) {
            defaultList = CompilerHints.fromResource(LIST);
        }
        return defaultList;
    }

    public static String hintsFile() {
        if (hintsFile == null) {
            try {
                Set<String> defaultHints = CompilerHints.defaultList().get();
                ArrayList<String> hints = new ArrayList<String>(defaultHints.size() + 2);
                hints.add("quiet");
                BlackholeMode bhMode = CompilerHints.blackholeMode();
                hints.add("inline,org/openjdk/jmh/infra/Blackhole.consume");
                hints.add("dontinline,org/openjdk/jmh/infra/Blackhole.consumeCPU");
                if (bhMode.shouldBlackhole()) {
                    hints.add("blackhole,org/openjdk/jmh/infra/Blackhole.consumeCompiler");
                }
                if (bhMode.shouldNotInline()) {
                    hints.add("dontinline,org/openjdk/jmh/infra/Blackhole.consumeFull");
                }
                hints.addAll(defaultHints);
                hintsFile = FileUtils.createTempFileWithLines("compilecommand", hints);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error creating compiler hints file", e);
            }
        }
        return hintsFile;
    }

    public static CompilerHints fromResource(String resource2) {
        return new CompilerHints(null, resource2);
    }

    public static CompilerHints fromFile(String file) {
        return new CompilerHints(file, null);
    }

    private CompilerHints(String file, String resource2) {
        super(file, resource2, null);
    }

    public static CompilerHintsSelect compilerHintsSelect() {
        if (compilerHintsSelect == null) {
            compilerHintsSelect = CompilerHints.checkCompilerHintsState();
        }
        return compilerHintsSelect;
    }

    static void resetCompilerHintsSelect() {
        compilerHintsSelect = null;
    }

    private static boolean compilerHintsEnabled() {
        return CompilerHints.compilerHintsSelect().isEnabled();
    }

    private static CompilerHintsSelect checkCompilerHintsState() {
        String propMode = System.getProperty(COMPILER_HINTS_MODE);
        if (propMode != null) {
            CompilerHintsSelect forced;
            try {
                forced = CompilerHintsSelect.valueOf(propMode);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("jmh.compilerhints.mode should be set to FORCE_ON or FORCE_OFF", e);
            }
            if (forced.isAuto()) {
                throw new IllegalArgumentException("jmh.compilerhints.mode should be set to FORCE_ON or FORCE_OFF");
            }
            return forced;
        }
        String name = System.getProperty("java.vm.name");
        for (String vmName : HINT_COMPATIBLE_JVMS) {
            if (!name.contains(vmName)) continue;
            return CompilerHintsSelect.AUTO_ON;
        }
        if (name.contains(JVM_ZING)) {
            String version = System.getProperty("java.version");
            try {
                String[] versionDigits = version.substring(version.indexOf(95) + 1).split("\\.");
                if (Integer.parseInt(versionDigits[0]) > 5) {
                    return CompilerHintsSelect.AUTO_ON;
                }
                if (Integer.parseInt(versionDigits[0]) == 5 && Integer.parseInt(versionDigits[1]) >= 10) {
                    return CompilerHintsSelect.AUTO_ON;
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                System.err.println("ERROR: Zing version format does not match 1.*.0-zing_*.*.*.*");
            }
        }
        return CompilerHintsSelect.AUTO_OFF;
    }

    public Set<String> get() {
        return this.hints;
    }

    private Set<String> read() {
        TreeSet<String> result = new TreeSet<String>();
        try {
            for (Reader r : this.getReaders()) {
                try (BufferedReader reader = new BufferedReader(r);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && !line.trim().isEmpty()) {
                            result.add(line);
                        }
                        line = reader.readLine();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading compiler hints", ex);
        }
        return result;
    }

    public static List<String> getCompileCommandFiles(List<String> command) {
        ArrayList<String> compileCommandFiles = new ArrayList<String>();
        for (String cmdLineWord : command) {
            if (!cmdLineWord.startsWith(XX_COMPILE_COMMAND_FILE)) continue;
            compileCommandFiles.add(cmdLineWord.substring(XX_COMPILE_COMMAND_FILE.length()));
        }
        return compileCommandFiles;
    }

    public static void addCompilerHints(List<String> command) {
        File hotspotCompilerFile;
        if (CompilerHints.compilerHintsSelect() == CompilerHintsSelect.AUTO_OFF) {
            System.err.println("WARNING: Not a HotSpot compiler command compatible VM (\"" + System.getProperty("java.vm.name") + "-" + System.getProperty("java.version") + "\"), compiler hints are disabled.");
        }
        if (!CompilerHints.compilerHintsEnabled()) {
            return;
        }
        ArrayList<String> hintFiles = new ArrayList<String>();
        hintFiles.add(CompilerHints.hintsFile());
        CompilerHints.removeCompileCommandFiles(command, hintFiles);
        if (hintFiles.size() == 1 && (hotspotCompilerFile = new File(".hotspot_compiler")).exists()) {
            hintFiles.add(hotspotCompilerFile.getAbsolutePath());
        }
        if (CompilerHints.blackholeMode() == BlackholeMode.COMPILER) {
            command.add("-XX:+UnlockDiagnosticVMOptions");
            command.add("-XX:+UnlockExperimentalVMOptions");
            command.add("-DcompilerBlackholesEnabled=true");
        }
        command.add(XX_COMPILE_COMMAND_FILE + CompilerHints.mergeHintFiles(hintFiles));
    }

    private static void removeCompileCommandFiles(List<String> command, List<String> compileCommandFiles) {
        Iterator<String> iterator = command.iterator();
        while (iterator.hasNext()) {
            String cmdLineWord = iterator.next();
            if (!cmdLineWord.startsWith(XX_COMPILE_COMMAND_FILE)) continue;
            compileCommandFiles.add(cmdLineWord.substring(XX_COMPILE_COMMAND_FILE.length()));
            iterator.remove();
        }
    }

    private static String mergeHintFiles(List<String> compileCommandFiles) {
        if (compileCommandFiles.size() == 1) {
            return compileCommandFiles.get(0);
        }
        try {
            TreeSet<String> hints = new TreeSet<String>();
            for (String file : compileCommandFiles) {
                hints.addAll(CompilerHints.fromFile(file).get());
            }
            return FileUtils.createTempFileWithLines("compilecommand", hints);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error merging compiler hints files", e);
        }
    }

    private static BlackholeMode blackholeMode() {
        if (blackholeMode != null) {
            return blackholeMode;
        }
        String propMode = System.getProperty(BLACKHOLE_MODE_NAME);
        if (propMode != null) {
            try {
                blackholeMode = BlackholeMode.valueOf(propMode);
                blackholeSelect = BlackholeSelect.FORCED;
                if (blackholeMode.shouldBlackhole() && !CompilerHints.compilerBlackholesAvailable()) {
                    throw new IllegalStateException("Compiler Blackholes are not available in current VM");
                }
                return blackholeMode;
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Unknown Blackhole mode: " + propMode);
            }
        }
        if (BLACKHOLE_MODE_AUTODETECT) {
            blackholeMode = CompilerHints.compilerBlackholesAvailable() ? BlackholeMode.COMPILER : BlackholeMode.FULL_DONTINLINE;
            blackholeSelect = BlackholeSelect.AUTO;
            return blackholeMode;
        }
        blackholeMode = BlackholeMode.FULL_DONTINLINE;
        blackholeSelect = BlackholeSelect.FALLBACK;
        return blackholeMode;
    }

    private static BlackholeSelect blackholeSelect() {
        CompilerHints.blackholeMode();
        return blackholeSelect;
    }

    private static boolean compilerBlackholesAvailable() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Utils.getCurrentJvm());
        cmd.add("-XX:+UnlockExperimentalVMOptions");
        cmd.add("-XX:CompileCommand=quiet");
        cmd.add("-XX:CompileCommand=blackhole,some/fake/Class.method");
        cmd.add("-version");
        CompilerHints.debug("Blackhole command errors test:");
        Collection<String> log = Utils.runWith(cmd);
        for (String l : log) {
            CompilerHints.debug(l);
            if (!l.contains("CompilerOracle") && !l.contains("CompileCommand")) continue;
            CompilerHints.debug("Found the suspected error line, no compiler blackholes.");
            return false;
        }
        cmd = new ArrayList();
        cmd.add(Utils.getCurrentJvm());
        cmd.add("-XX:+UnlockExperimentalVMOptions");
        cmd.add("-XX:CompileCommand=blackhole,some/fake/Class.method");
        cmd.add("-version");
        CompilerHints.debug("Blackhole command acceptance test:");
        log = Utils.runWith(cmd);
        for (String l : log) {
            CompilerHints.debug(l);
            if (!l.contains("CompilerOracle") && !l.contains("CompileCommand")) continue;
            CompilerHints.debug("Found the acceptance line, compiler blackholes are available.");
            return true;
        }
        CompilerHints.debug("Compiler blackholes are not available.");
        return false;
    }

    private static void debug(String msg) {
        if (BLACKHOLE_MODE_DEBUG) {
            System.out.println(msg);
        }
    }

    public static void printHints(PrintStream out) {
        if (!CompilerHints.compilerHintsSelect().isAuto()) {
            out.print("# Compiler hints: " + (CompilerHints.compilerHintsEnabled() ? "enabled" : "disabled") + " (" + CompilerHints.compilerHintsSelect().desc() + ")");
            out.println();
        }
        BlackholeMode mode = CompilerHints.blackholeMode();
        out.print("# Blackhole mode: " + mode.desc() + " (" + CompilerHints.blackholeSelect().desc() + ")");
        out.println();
    }

    public static void printWarnings(PrintStream out) {
        if (CompilerHints.blackholeMode() == BlackholeMode.COMPILER) {
            out.println("NOTE: Current JVM experimentally supports Compiler Blackholes, and they are in use. Please exercise");
            out.println("extra caution when trusting the results, look into the generated code to check the benchmark still");
            out.println("works, and factor in a small probability of new VM bugs. Additionally, while comparisons between");
            out.println("different JVMs are already problematic, the performance difference caused by different Blackhole");
            out.println("modes can be very significant. Please make sure you use the consistent Blackhole mode for comparisons.");
            out.println();
        }
    }

    static {
        BLACKHOLE_MODE_AUTODETECT = Boolean.parseBoolean(System.getProperty(BLACKHOLE_AUTODETECT_NAME, "true"));
        BLACKHOLE_MODE_DEBUG = Boolean.parseBoolean(System.getProperty(BLACKHOLE_DEBUG_NAME, "false"));
    }

    private static enum BlackholeMode {
        COMPILER(true, false, "compiler"),
        FULL_DONTINLINE(false, true, "full + dont-inline hint"),
        FULL(false, false, "full");

        private final boolean shouldBlackhole;
        private final boolean shouldNotInline;
        private final String desc;

        private BlackholeMode(boolean shouldBlackhole, boolean shouldNotInline, String desc) {
            this.shouldBlackhole = shouldBlackhole;
            this.shouldNotInline = shouldNotInline;
            this.desc = desc;
        }

        public boolean shouldBlackhole() {
            return this.shouldBlackhole;
        }

        public boolean shouldNotInline() {
            return this.shouldNotInline;
        }

        public String desc() {
            return this.desc;
        }
    }

    public static enum CompilerHintsSelect {
        FORCE_ON("Forced on", false, true),
        FORCE_OFF("Forced off", false, false),
        AUTO_ON("Automatically enabled", true, true),
        AUTO_OFF("Automatically disabled", true, false);

        private final String desc;
        private final boolean auto;
        private final boolean enabled;

        private CompilerHintsSelect(String desc, boolean auto, boolean enabled) {
            this.desc = desc;
            this.auto = auto;
            this.enabled = enabled;
        }

        public String desc() {
            return this.desc;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private static enum BlackholeSelect {
        AUTO("auto-detected, use -Djmh.blackhole.autoDetect=false to disable"),
        FALLBACK("fallback, use -Djmh.blackhole.mode to force"),
        FORCED("forced");

        final String desc;

        private BlackholeSelect(String desc) {
            this.desc = desc;
        }

        public String desc() {
            return this.desc;
        }
    }
}

