/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subjects.UnicastSubject;
import rx.subscriptions.Subscriptions;

public final class OperatorWindowWithTime<T>
implements Observable.Operator<Observable<T>, T> {
    final long timespan;
    final long timeshift;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int size;
    static final Object NEXT_SUBJECT = new Object();

    public OperatorWindowWithTime(long timespan, long timeshift, TimeUnit unit, int size, Scheduler scheduler) {
        this.timespan = timespan;
        this.timeshift = timeshift;
        this.unit = unit;
        this.size = size;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        if (this.timespan == this.timeshift) {
            ExactSubscriber s = new ExactSubscriber(child, worker);
            s.add(worker);
            s.scheduleExact();
            return s;
        }
        InexactSubscriber s = new InexactSubscriber(child, worker);
        s.add(worker);
        s.startNewChunk();
        s.scheduleChunk();
        return s;
    }

    final class InexactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final Scheduler.Worker worker;
        final Object guard;
        final List<CountedSerializedSubject<T>> chunks;
        boolean done;

        public InexactSubscriber(Subscriber<? super Observable<T>> child, Scheduler.Worker worker) {
            super(child);
            this.child = child;
            this.worker = worker;
            this.guard = new Object();
            this.chunks = new LinkedList();
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            ArrayList list;
            Iterator iterator = this.guard;
            synchronized (iterator) {
                if (this.done) {
                    return;
                }
                list = new ArrayList(this.chunks);
                Iterator iterator2 = this.chunks.iterator();
                while (iterator2.hasNext()) {
                    CountedSerializedSubject cs = iterator2.next();
                    if (++cs.count != OperatorWindowWithTime.this.size) continue;
                    iterator2.remove();
                }
            }
            for (CountedSerializedSubject countedSerializedSubject : list) {
                countedSerializedSubject.consumer.onNext(t);
                if (countedSerializedSubject.count != OperatorWindowWithTime.this.size) continue;
                countedSerializedSubject.consumer.onCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            ArrayList list;
            Iterator iterator = this.guard;
            synchronized (iterator) {
                if (this.done) {
                    return;
                }
                this.done = true;
                list = new ArrayList(this.chunks);
                this.chunks.clear();
            }
            for (CountedSerializedSubject countedSerializedSubject : list) {
                countedSerializedSubject.consumer.onError(e);
            }
            this.child.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            ArrayList list;
            Iterator iterator = this.guard;
            synchronized (iterator) {
                if (this.done) {
                    return;
                }
                this.done = true;
                list = new ArrayList(this.chunks);
                this.chunks.clear();
            }
            for (CountedSerializedSubject countedSerializedSubject : list) {
                countedSerializedSubject.consumer.onCompleted();
            }
            this.child.onCompleted();
        }

        void scheduleChunk() {
            this.worker.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    InexactSubscriber.this.startNewChunk();
                }
            }, OperatorWindowWithTime.this.timeshift, OperatorWindowWithTime.this.timeshift, OperatorWindowWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startNewChunk() {
            final CountedSerializedSubject chunk = this.createCountedSerializedSubject();
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                this.chunks.add(chunk);
            }
            try {
                this.child.onNext(chunk.producer);
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
            this.worker.schedule(new Action0(){

                @Override
                public void call() {
                    InexactSubscriber.this.terminateChunk(chunk);
                }
            }, OperatorWindowWithTime.this.timespan, OperatorWindowWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminateChunk(CountedSerializedSubject<T> chunk) {
            boolean terminate = false;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    CountedSerializedSubject cs = it.next();
                    if (cs != chunk) continue;
                    terminate = true;
                    it.remove();
                    break;
                }
            }
            if (terminate) {
                chunk.consumer.onCompleted();
            }
        }

        CountedSerializedSubject<T> createCountedSerializedSubject() {
            UnicastSubject bus = UnicastSubject.create();
            return new CountedSerializedSubject(bus, bus);
        }
    }

    static final class CountedSerializedSubject<T> {
        final Observer<T> consumer;
        final Observable<T> producer;
        int count;

        public CountedSerializedSubject(Observer<T> consumer, Observable<T> producer) {
            this.consumer = new SerializedObserver<T>(consumer);
            this.producer = producer;
        }
    }

    final class ExactSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final Scheduler.Worker worker;
        final Object guard;
        List<Object> queue;
        boolean emitting;
        volatile State<T> state;

        public ExactSubscriber(Subscriber<? super Observable<T>> child, Scheduler.Worker worker) {
            this.child = new SerializedSubscriber(child);
            this.worker = worker;
            this.guard = new Object();
            this.state = State.empty();
            child.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    if (ExactSubscriber.this.state.consumer == null) {
                        ExactSubscriber.this.unsubscribe();
                    }
                }
            }));
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(t);
                    return;
                }
                this.emitting = true;
            }
            boolean skipFinal = false;
            try {
                if (!this.emitValue(t)) {
                    return;
                }
                while (true) {
                    List<Object> localQueue;
                    Object object2 = this.guard;
                    synchronized (object2) {
                        block30: {
                            localQueue = this.queue;
                            if (localQueue != null) break block30;
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                        this.queue = null;
                    }
                    if (this.drain(localQueue)) continue;
                    return;
                }
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        boolean drain(List<Object> queue) {
            if (queue == null) {
                return true;
            }
            for (Object o : queue) {
                if (o == NEXT_SUBJECT) {
                    if (this.replaceSubject()) continue;
                    return false;
                }
                if (NotificationLite.isError(o)) {
                    this.error(NotificationLite.getError(o));
                    break;
                }
                if (NotificationLite.isCompleted(o)) {
                    this.complete();
                    break;
                }
                Object t = o;
                if (this.emitValue(t)) continue;
                return false;
            }
            return true;
        }

        boolean replaceSubject() {
            Observer s = this.state.consumer;
            if (s != null) {
                s.onCompleted();
            }
            if (this.child.isUnsubscribed()) {
                this.state = this.state.clear();
                this.unsubscribe();
                return false;
            }
            UnicastSubject bus = UnicastSubject.create();
            this.state = this.state.create(bus, bus);
            this.child.onNext(bus);
            return true;
        }

        boolean emitValue(T t) {
            State s = this.state;
            if (s.consumer == null) {
                if (!this.replaceSubject()) {
                    return false;
                }
                s = this.state;
            }
            s.consumer.onNext(t);
            if (s.count == OperatorWindowWithTime.this.size - 1) {
                s.consumer.onCompleted();
                s = s.clear();
            } else {
                s = s.next();
            }
            this.state = s;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    this.queue = Collections.singletonList(NotificationLite.error(e));
                    return;
                }
                this.queue = null;
                this.emitting = true;
            }
            this.error(e);
        }

        void error(Throwable e) {
            Observer s = this.state.consumer;
            this.state = this.state.clear();
            if (s != null) {
                s.onError(e);
            }
            this.child.onError(e);
            this.unsubscribe();
        }

        void complete() {
            Observer s = this.state.consumer;
            this.state = this.state.clear();
            if (s != null) {
                s.onCompleted();
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NotificationLite.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            try {
                this.drain(localQueue);
            }
            catch (Throwable e) {
                this.error(e);
                return;
            }
            this.complete();
        }

        void scheduleExact() {
            this.worker.schedulePeriodically(new Action0(){

                @Override
                public void call() {
                    ExactSubscriber.this.nextWindow();
                }
            }, 0L, OperatorWindowWithTime.this.timespan, OperatorWindowWithTime.this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void nextWindow() {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NEXT_SUBJECT);
                    return;
                }
                this.emitting = true;
            }
            boolean skipFinal = false;
            try {
                if (!this.replaceSubject()) {
                    return;
                }
                while (true) {
                    List<Object> localQueue;
                    Object object2 = this.guard;
                    synchronized (object2) {
                        block30: {
                            localQueue = this.queue;
                            if (localQueue != null) break block30;
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                        this.queue = null;
                    }
                    if (this.drain(localQueue)) continue;
                    return;
                }
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }
    }

    static final class State<T> {
        final Observer<T> consumer;
        final Observable<T> producer;
        final int count;
        static final State<Object> EMPTY = new State(null, null, 0);

        public State(Observer<T> consumer, Observable<T> producer, int count) {
            this.consumer = consumer;
            this.producer = producer;
            this.count = count;
        }

        public State<T> next() {
            return new State<T>(this.consumer, this.producer, this.count + 1);
        }

        public State<T> create(Observer<T> consumer, Observable<T> producer) {
            return new State<T>(consumer, producer, 0);
        }

        public State<T> clear() {
            return State.empty();
        }

        public static <T> State<T> empty() {
            return EMPTY;
        }
    }
}

