/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Consumer;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.BeanInstanceSupplier;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingSupplier;

class InstanceSupplierCodeGenerator {
    private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
    private static final String ARGS_PARAMETER_NAME = "args";
    private static final javax.lang.model.element.Modifier[] PRIVATE_STATIC = new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC};
    private static final CodeBlock NO_ARGS = CodeBlock.of("", new Object[0]);
    private final GenerationContext generationContext;
    private final ClassName className;
    private final GeneratedMethods generatedMethods;
    private final boolean allowDirectSupplierShortcut;

    InstanceSupplierCodeGenerator(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, boolean allowDirectSupplierShortcut) {
        this.generationContext = generationContext;
        this.className = className;
        this.generatedMethods = generatedMethods;
        this.allowDirectSupplierShortcut = allowDirectSupplierShortcut;
    }

    CodeBlock generateCode(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        if (constructorOrFactoryMethod instanceof Constructor) {
            Constructor constructor = (Constructor)constructorOrFactoryMethod;
            return this.generateCodeForConstructor(registeredBean, constructor);
        }
        if (constructorOrFactoryMethod instanceof Method) {
            Method method = (Method)constructorOrFactoryMethod;
            return this.generateCodeForFactoryMethod(registeredBean, method);
        }
        throw new IllegalStateException("No suitable executor found for " + registeredBean.getBeanName());
    }

    private CodeBlock generateCodeForConstructor(RegisteredBean registeredBean, Constructor<?> constructor) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        Class<?> declaringClass = constructor.getDeclaringClass();
        boolean dependsOnBean = ClassUtils.isInnerClass(declaringClass);
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, constructor);
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleConstructor(beanName, beanClass, constructor, dependsOnBean, declaringClass);
        }
        return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor, dependsOnBean);
    }

    private CodeBlock generateCodeForAccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && constructor.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of("$T.using($T::new)", InstanceSupplier.class, declaringClass);
            }
            if (!this.isThrowingCheckedException(constructor)) {
                return CodeBlock.of("$T::new", declaringClass);
            }
            return CodeBlock.of("$T.of($T::new)", ThrowingSupplier.class, declaringClass);
        }
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForConstructor((MethodSpec.Builder)method, beanName, beanClass, constructor, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(generatedMethod);
    }

    private CodeBlock generateCodeForInaccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, ExecutableMode.INVOKE);
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> {
            method.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
            method.addModifiers(PRIVATE_STATIC);
            method.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, beanClass));
            int parameterOffset = !dependsOnBean ? 0 : 1;
            method.addStatement(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        });
        return this.generateReturnStatement(generatedMethod);
    }

    private void buildGetInstanceMethodForConstructor(MethodSpec.Builder method, String beanName, Class<?> beanClass, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        method.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
        method.addModifiers(modifiers);
        method.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, beanClass));
        int parameterOffset = !dependsOnBean ? 0 : 1;
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        boolean hasArguments = constructor.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, constructor).generateCode(constructor.getParameterTypes(), parameterOffset) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateResolverForConstructor(Class<?> beanClass, Constructor<?> constructor, int parameterOffset) {
        CodeBlock parameterTypes = this.generateParameterTypesCode(constructor.getParameterTypes(), parameterOffset);
        return CodeBlock.of("return $T.<$T>forConstructor($L)", BeanInstanceSupplier.class, beanClass, parameterTypes);
    }

    private CodeBlock generateNewInstanceCodeForConstructor(boolean dependsOnBean, Class<?> declaringClass, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of("new $T($L)", declaringClass, args);
        }
        return CodeBlock.of("$L.getBeanFactory().getBean($T.class).new $L($L)", REGISTERED_BEAN_PARAMETER_NAME, declaringClass.getEnclosingClass(), declaringClass.getSimpleName(), args);
    }

    private CodeBlock generateCodeForFactoryMethod(RegisteredBean registeredBean, Method factoryMethod) {
        String beanName = registeredBean.getBeanName();
        Class<?> declaringClass = ClassUtils.getUserClass(factoryMethod.getDeclaringClass());
        boolean dependsOnBean = !Modifier.isStatic(factoryMethod.getModifiers());
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, factoryMethod);
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleFactoryMethod(beanName, factoryMethod, declaringClass, dependsOnBean);
        }
        return this.generateCodeForInaccessibleFactoryMethod(beanName, factoryMethod, declaringClass);
    }

    private CodeBlock generateCodeForAccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && factoryMethod.getParameterCount() == 0) {
            Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.<$T>forFactoryMethod($T.class, $S)", BeanInstanceSupplier.class, suppliedType, declaringClass, factoryMethod.getName());
            code.add(".withGenerator($T::$L)", declaringClass, factoryMethod.getName());
            return code.build();
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForFactoryMethod((MethodSpec.Builder)method, beanName, factoryMethod, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(getInstanceMethod);
    }

    private CodeBlock generateCodeForInaccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INVOKE);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> {
            Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            method.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
            method.addModifiers(PRIVATE_STATIC);
            method.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, suppliedType));
            method.addStatement(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, declaringClass, factoryMethod.getName()));
        });
        return this.generateReturnStatement(getInstanceMethod);
    }

    private void buildGetInstanceMethodForFactoryMethod(MethodSpec.Builder method, String beanName, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        String factoryMethodName = factoryMethod.getName();
        Class<?> suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
        method.addJavadoc("Get the bean instance supplier for '$L'.", beanName);
        method.addModifiers(modifiers);
        method.returns(ParameterizedTypeName.get(BeanInstanceSupplier.class, suppliedType));
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, declaringClass, factoryMethodName));
        boolean hasArguments = factoryMethod.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, factoryMethod).generateCode(factoryMethod.getParameterTypes()) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForMethod(dependsOnBean, declaringClass, factoryMethodName, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateInstanceSupplierForFactoryMethod(Method factoryMethod, Class<?> suppliedType, Class<?> declaringClass, String factoryMethodName) {
        if (factoryMethod.getParameterCount() == 0) {
            return CodeBlock.of("return $T.<$T>forFactoryMethod($T.class, $S)", BeanInstanceSupplier.class, suppliedType, declaringClass, factoryMethodName);
        }
        CodeBlock parameterTypes = this.generateParameterTypesCode(factoryMethod.getParameterTypes(), 0);
        return CodeBlock.of("return $T.<$T>forFactoryMethod($T.class, $S, $L)", BeanInstanceSupplier.class, suppliedType, declaringClass, factoryMethodName, parameterTypes);
    }

    private CodeBlock generateNewInstanceCodeForMethod(boolean dependsOnBean, Class<?> declaringClass, String factoryMethodName, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of("$T.$L($L)", declaringClass, factoryMethodName, args);
        }
        return CodeBlock.of("$L.getBeanFactory().getBean($T.class).$L($L)", REGISTERED_BEAN_PARAMETER_NAME, declaringClass, factoryMethodName, args);
    }

    private CodeBlock generateReturnStatement(GeneratedMethod generatedMethod) {
        return generatedMethod.toMethodReference().toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), this.className);
    }

    private CodeBlock generateWithGeneratorCode(boolean hasArguments, CodeBlock newInstance) {
        CodeBlock lambdaArguments = hasArguments ? CodeBlock.of("($L, $L)", REGISTERED_BEAN_PARAMETER_NAME, ARGS_PARAMETER_NAME) : CodeBlock.of("($L)", REGISTERED_BEAN_PARAMETER_NAME);
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("\n", new Object[0]);
        code.indent().indent();
        code.add(".withGenerator($L -> $L)", lambdaArguments, newInstance);
        code.unindent().unindent();
        return code.build();
    }

    private AccessControl.Visibility getAccessVisibility(RegisteredBean registeredBean, Member member) {
        AccessControl beanTypeAccessControl = AccessControl.forResolvableType(registeredBean.getBeanType());
        AccessControl memberAccessControl = AccessControl.forMember(member);
        return AccessControl.lowest(beanTypeAccessControl, memberAccessControl).getVisibility();
    }

    private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes, int offset) {
        CodeBlock.Builder code = CodeBlock.builder();
        for (int i2 = offset; i2 < parameterTypes.length; ++i2) {
            code.add(i2 != offset ? ", " : "", new Object[0]);
            code.add("$T.class", parameterTypes[i2]);
        }
        return code.build();
    }

    private GeneratedMethod generateGetInstanceSupplierMethod(Consumer<MethodSpec.Builder> method) {
        return this.generatedMethods.add("getInstanceSupplier", method);
    }

    private boolean isThrowingCheckedException(Executable executable) {
        return Arrays.stream(executable.getGenericExceptionTypes()).map(ResolvableType::forType).map(ResolvableType::toClass).anyMatch(Exception.class::isAssignableFrom);
    }
}

