/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.support;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.upgrade.JettyRequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNetty2RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.StandardWebSocketUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.TomcatRequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.UndertowRequestUpgradeStrategy;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class HandshakeWebSocketService
implements WebSocketService,
Lifecycle {
    private static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final Mono<Map<String, Object>> EMPTY_ATTRIBUTES = Mono.just(Collections.emptyMap());
    private static final boolean tomcatWsPresent;
    private static final boolean jettyWsPresent;
    private static final boolean undertowWsPresent;
    private static final boolean reactorNettyPresent;
    private static final boolean reactorNetty2Present;
    private static final Log logger;
    private final RequestUpgradeStrategy upgradeStrategy;
    @Nullable
    private Predicate<String> sessionAttributePredicate;
    private volatile boolean running;

    public HandshakeWebSocketService() {
        this(HandshakeWebSocketService.initUpgradeStrategy());
    }

    public HandshakeWebSocketService(RequestUpgradeStrategy upgradeStrategy) {
        Assert.notNull((Object)upgradeStrategy, "RequestUpgradeStrategy is required");
        this.upgradeStrategy = upgradeStrategy;
    }

    public RequestUpgradeStrategy getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    public void setSessionAttributePredicate(@Nullable Predicate<String> predicate) {
        this.sessionAttributePredicate = predicate;
    }

    @Nullable
    public Predicate<String> getSessionAttributePredicate() {
        return this.sessionAttributePredicate;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            this.doStart();
        }
    }

    protected void doStart() {
        RequestUpgradeStrategy requestUpgradeStrategy = this.getUpgradeStrategy();
        if (requestUpgradeStrategy instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)requestUpgradeStrategy;
            lifecycle.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            this.doStop();
        }
    }

    protected void doStop() {
        RequestUpgradeStrategy requestUpgradeStrategy = this.getUpgradeStrategy();
        if (requestUpgradeStrategy instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)requestUpgradeStrategy;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Mono<Void> handleRequest(ServerWebExchange exchange2, WebSocketHandler handler) {
        ServerHttpRequest request = exchange2.getRequest();
        HttpMethod method = request.getMethod();
        HttpHeaders headers = request.getHeaders();
        if (HttpMethod.GET != method) {
            return Mono.error(new MethodNotAllowedException(request.getMethod(), Collections.singleton(HttpMethod.GET)));
        }
        if (!"WebSocket".equalsIgnoreCase(headers.getUpgrade())) {
            return this.handleBadRequest(exchange2, "Invalid 'Upgrade' header: " + headers);
        }
        List<String> connectionValue = headers.getConnection();
        if (!connectionValue.contains("Upgrade") && !connectionValue.contains("upgrade")) {
            return this.handleBadRequest(exchange2, "Invalid 'Connection' header: " + headers);
        }
        String key = headers.getFirst(SEC_WEBSOCKET_KEY);
        if (key == null) {
            return this.handleBadRequest(exchange2, "Missing \"Sec-WebSocket-Key\" header");
        }
        String protocol = this.selectProtocol(headers, handler);
        return this.initAttributes(exchange2).flatMap(attributes -> this.upgradeStrategy.upgrade(exchange2, handler, protocol, () -> this.createHandshakeInfo(exchange2, request, protocol, (Map<String, Object>)attributes)));
    }

    private Mono<Void> handleBadRequest(ServerWebExchange exchange2, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug(exchange2.getLogPrefix() + reason);
        }
        return Mono.error(new ServerWebInputException(reason));
    }

    @Nullable
    private String selectProtocol(HttpHeaders headers, WebSocketHandler handler) {
        String protocolHeader = headers.getFirst(SEC_WEBSOCKET_PROTOCOL);
        if (protocolHeader != null) {
            List<String> supportedProtocols = handler.getSubProtocols();
            for (String protocol : StringUtils.commaDelimitedListToStringArray(protocolHeader)) {
                if (!supportedProtocols.contains(protocol)) continue;
                return protocol;
            }
        }
        return null;
    }

    private Mono<Map<String, Object>> initAttributes(ServerWebExchange exchange2) {
        if (this.sessionAttributePredicate == null) {
            return EMPTY_ATTRIBUTES;
        }
        return exchange2.getSession().map(session -> session.getAttributes().entrySet().stream().filter(entry -> this.sessionAttributePredicate.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private HandshakeInfo createHandshakeInfo(ServerWebExchange exchange2, ServerHttpRequest request, @Nullable String protocol, Map<String, Object> attributes) {
        URI uri = request.getURI();
        HttpHeaders headers = new HttpHeaders();
        headers.addAll(request.getHeaders());
        MultiValueMap<String, HttpCookie> cookies = request.getCookies();
        Mono<Principal> principal2 = exchange2.getPrincipal();
        String logPrefix = exchange2.getLogPrefix();
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        return new HandshakeInfo(uri, headers, cookies, principal2, protocol, remoteAddress, attributes, logPrefix);
    }

    static RequestUpgradeStrategy initUpgradeStrategy() {
        if (tomcatWsPresent) {
            return new TomcatRequestUpgradeStrategy();
        }
        if (jettyWsPresent) {
            return new JettyRequestUpgradeStrategy();
        }
        if (undertowWsPresent) {
            return new UndertowRequestUpgradeStrategy();
        }
        if (reactorNettyPresent) {
            return ReactorNettyStrategyDelegate.forReactorNetty1();
        }
        if (reactorNetty2Present) {
            return ReactorNettyStrategyDelegate.forReactorNetty2();
        }
        return new StandardWebSocketUpgradeStrategy();
    }

    static {
        ClassLoader classLoader = HandshakeWebSocketService.class.getClassLoader();
        tomcatWsPresent = ClassUtils.isPresent("org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", classLoader);
        jettyWsPresent = ClassUtils.isPresent("org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer", classLoader);
        undertowWsPresent = ClassUtils.isPresent("io.undertow.websockets.WebSocketProtocolHandshakeHandler", classLoader);
        reactorNettyPresent = ClassUtils.isPresent("reactor.netty.http.server.HttpServerResponse", classLoader);
        reactorNetty2Present = ClassUtils.isPresent("reactor.netty5.http.server.HttpServerResponse", classLoader);
        logger = LogFactory.getLog(HandshakeWebSocketService.class);
    }

    private static class ReactorNettyStrategyDelegate {
        private ReactorNettyStrategyDelegate() {
        }

        public static RequestUpgradeStrategy forReactorNetty1() {
            return new ReactorNettyRequestUpgradeStrategy();
        }

        public static RequestUpgradeStrategy forReactorNetty2() {
            return new ReactorNetty2RequestUpgradeStrategy();
        }
    }
}

