/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.ErrorResponse;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.server.DefaultServerResponseBuilder;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface ServerResponse {
    public HttpStatusCode statusCode();

    @Deprecated(since="6.0")
    public int rawStatusCode();

    public HttpHeaders headers();

    public MultiValueMap<String, ResponseCookie> cookies();

    public Mono<Void> writeTo(ServerWebExchange var1, Context var2);

    public static BodyBuilder from(ServerResponse other) {
        return new DefaultServerResponseBuilder(other);
    }

    public static Mono<ServerResponse> from(ErrorResponse response) {
        return ((BodyBuilder)ServerResponse.status(response.getStatusCode()).headers(headers -> headers.putAll(response.getHeaders()))).bodyValue(response.getBody());
    }

    public static BodyBuilder status(HttpStatusCode status) {
        return new DefaultServerResponseBuilder(status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultServerResponseBuilder(HttpStatusCode.valueOf(status));
    }

    public static BodyBuilder ok() {
        return ServerResponse.status(HttpStatus.OK);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return ServerResponse.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ServerResponse.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder seeOther(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.SEE_OTHER);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder temporaryRedirect(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.TEMPORARY_REDIRECT);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder permanentRedirect(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.PERMANENT_REDIRECT);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder badRequest() {
        return ServerResponse.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ServerResponse.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return ServerResponse.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public BodyBuilder hint(String var1, Object var2);

        public BodyBuilder hints(Consumer<Map<String, Object>> var1);

        public Mono<ServerResponse> bodyValue(Object var1);

        public <T, P extends Publisher<T>> Mono<ServerResponse> body(P var1, Class<T> var2);

        public <T, P extends Publisher<T>> Mono<ServerResponse> body(P var1, ParameterizedTypeReference<T> var2);

        public Mono<ServerResponse> body(Object var1, Class<?> var2);

        public Mono<ServerResponse> body(Object var1, ParameterizedTypeReference<?> var2);

        public Mono<ServerResponse> body(BodyInserter<?, ? super ServerHttpResponse> var1);

        @Deprecated
        public Mono<ServerResponse> syncBody(Object var1);

        public Mono<ServerResponse> render(String var1, Object ... var2);

        public Mono<ServerResponse> render(String var1, Map<String, ?> var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(Consumer<HttpHeaders> var1);

        public B cookie(ResponseCookie var1);

        public B cookies(Consumer<MultiValueMap<String, ResponseCookie>> var1);

        public B allow(HttpMethod ... var1);

        public B allow(Set<HttpMethod> var1);

        public B eTag(String var1);

        public B lastModified(ZonedDateTime var1);

        public B lastModified(Instant var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public Mono<ServerResponse> build();

        public Mono<ServerResponse> build(Publisher<Void> var1);

        public Mono<ServerResponse> build(BiFunction<ServerWebExchange, Context, Mono<Void>> var1);
    }

    public static interface Context {
        public List<HttpMessageWriter<?>> messageWriters();

        public List<ViewResolver> viewResolvers();
    }
}

