/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Hints;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ResponseCookie;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.DefaultEntityResponseBuilder;
import org.springframework.web.reactive.function.server.DefaultRenderingResponseBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultServerResponseBuilder
implements ServerResponse.BodyBuilder {
    private final HttpStatusCode statusCode;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap<String, ResponseCookie>();
    private final Map<String, Object> hints = new HashMap<String, Object>();

    public DefaultServerResponseBuilder(ServerResponse other) {
        Assert.notNull((Object)other, "ServerResponse must not be null");
        this.headers.addAll(other.headers());
        this.cookies.addAll(other.cookies());
        this.statusCode = other.statusCode();
        if (other instanceof AbstractServerResponse) {
            AbstractServerResponse abstractOther = (AbstractServerResponse)other;
            this.hints.putAll(abstractOther.hints);
        }
    }

    public DefaultServerResponseBuilder(HttpStatusCode status) {
        Assert.notNull((Object)status, "HttpStatusCode must not be null");
        this.statusCode = status;
    }

    @Override
    public ServerResponse.BodyBuilder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookie(ResponseCookie cookie) {
        Assert.notNull((Object)cookie, "ResponseCookie must not be null");
        this.cookies.add(cookie.getName(), cookie);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder contentType(MediaType contentType) {
        this.headers.setContentType(contentType);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder eTag(String etag) {
        if (!((String)etag).startsWith("\"") && !((String)etag).startsWith("W/\"")) {
            etag = "\"" + (String)etag;
        }
        if (!((String)etag).endsWith("\"")) {
            etag = (String)etag + "\"";
        }
        this.headers.setETag((String)etag);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder hints(Consumer<Map<String, Object>> hintsConsumer) {
        hintsConsumer.accept(this.hints);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(ZonedDateTime lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder lastModified(Instant lastModified) {
        this.headers.setLastModified(lastModified);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder cacheControl(CacheControl cacheControl) {
        this.headers.setCacheControl(cacheControl);
        return this;
    }

    @Override
    public ServerResponse.BodyBuilder varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Mono<ServerResponse> build() {
        return this.build((ServerWebExchange exchange2, ServerResponse.Context handlerStrategies) -> exchange2.getResponse().setComplete());
    }

    @Override
    public Mono<ServerResponse> build(Publisher<Void> voidPublisher) {
        Assert.notNull(voidPublisher, "Publisher must not be null");
        return this.build((ServerWebExchange exchange2, ServerResponse.Context handlerStrategies) -> Mono.from(voidPublisher).then(exchange2.getResponse().setComplete()));
    }

    @Override
    public Mono<ServerResponse> build(BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction) {
        return Mono.just(new WriterFunctionResponse(this.statusCode, this.headers, this.cookies, writeFunction));
    }

    @Override
    public Mono<ServerResponse> bodyValue(Object body2) {
        return this.initBuilder(body2, BodyInserters.fromValue(body2));
    }

    @Override
    public <T, P extends Publisher<T>> Mono<ServerResponse> body(P publisher, Class<T> elementClass) {
        return this.initBuilder(publisher, BodyInserters.fromPublisher(publisher, elementClass));
    }

    @Override
    public <T, P extends Publisher<T>> Mono<ServerResponse> body(P publisher, ParameterizedTypeReference<T> typeRef) {
        return this.initBuilder(publisher, BodyInserters.fromPublisher(publisher, typeRef));
    }

    @Override
    public Mono<ServerResponse> body(Object producer, Class<?> elementClass) {
        return this.initBuilder(producer, BodyInserters.fromProducer(producer, elementClass));
    }

    @Override
    public Mono<ServerResponse> body(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
        return this.initBuilder(producer, BodyInserters.fromProducer(producer, elementTypeRef));
    }

    private <T> Mono<ServerResponse> initBuilder(T entity, BodyInserter<T, ReactiveHttpOutputMessage> inserter) {
        return new DefaultEntityResponseBuilder<T>(entity, inserter).status(this.statusCode).headers(this.headers).cookies((MultiValueMap<String, ResponseCookie> cookies) -> cookies.addAll(this.cookies)).hints(hints -> hints.putAll(this.hints)).build().map(Function.identity());
    }

    @Override
    public Mono<ServerResponse> body(BodyInserter<?, ? super ServerHttpResponse> inserter) {
        return Mono.just(new BodyInserterResponse(this.statusCode, this.headers, this.cookies, inserter, this.hints));
    }

    @Override
    @Deprecated
    public Mono<ServerResponse> syncBody(Object body2) {
        return this.bodyValue(body2);
    }

    @Override
    public Mono<ServerResponse> render(String name, Object ... modelAttributes) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers(this.headers).cookies((MultiValueMap<String, ResponseCookie> cookies) -> cookies.addAll(this.cookies)).modelAttributes(modelAttributes).build().map(Function.identity());
    }

    @Override
    public Mono<ServerResponse> render(String name, Map<String, ?> model) {
        return new DefaultRenderingResponseBuilder(name).status(this.statusCode).headers(this.headers).cookies((MultiValueMap<String, ResponseCookie> cookies) -> cookies.addAll(this.cookies)).modelAttributes(model).build().map(Function.identity());
    }

    static abstract class AbstractServerResponse
    implements ServerResponse {
        private static final Set<HttpMethod> SAFE_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD);
        private final HttpStatusCode statusCode;
        private final HttpHeaders headers;
        private final MultiValueMap<String, ResponseCookie> cookies;
        final Map<String, Object> hints;

        protected AbstractServerResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, Map<String, Object> hints) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(new LinkedMultiValueMap(cookies));
            this.hints = hints;
        }

        @Override
        public final HttpStatusCode statusCode() {
            return this.statusCode;
        }

        @Override
        @Deprecated
        public int rawStatusCode() {
            return this.statusCode.value();
        }

        @Override
        public final HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, ResponseCookie> cookies() {
            return this.cookies;
        }

        @Override
        public final Mono<Void> writeTo(ServerWebExchange exchange2, ServerResponse.Context context) {
            this.writeStatusAndHeaders(exchange2.getResponse());
            Instant lastModified = Instant.ofEpochMilli(this.headers().getLastModified());
            HttpMethod httpMethod = exchange2.getRequest().getMethod();
            if (SAFE_METHODS.contains(httpMethod) && exchange2.checkNotModified(this.headers().getETag(), lastModified)) {
                return exchange2.getResponse().setComplete();
            }
            return this.writeToInternal(exchange2, context);
        }

        private void writeStatusAndHeaders(ServerHttpResponse response) {
            response.setStatusCode(this.statusCode);
            AbstractServerResponse.copy(this.headers, response.getHeaders());
            AbstractServerResponse.copy(this.cookies, response.getCookies());
        }

        protected abstract Mono<Void> writeToInternal(ServerWebExchange var1, ServerResponse.Context var2);

        private static <K, V> void copy(MultiValueMap<K, V> src, MultiValueMap<K, V> dst) {
            if (!src.isEmpty()) {
                dst.putAll(src);
            }
        }
    }

    private static final class WriterFunctionResponse
    extends AbstractServerResponse {
        private final BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction;

        public WriterFunctionResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, BiFunction<ServerWebExchange, ServerResponse.Context, Mono<Void>> writeFunction) {
            super(statusCode, headers, cookies, Collections.emptyMap());
            Assert.notNull(writeFunction, "BiFunction must not be null");
            this.writeFunction = writeFunction;
        }

        @Override
        protected Mono<Void> writeToInternal(ServerWebExchange exchange2, ServerResponse.Context context) {
            return this.writeFunction.apply(exchange2, context);
        }
    }

    private static final class BodyInserterResponse<T>
    extends AbstractServerResponse {
        private final BodyInserter<T, ? super ServerHttpResponse> inserter;

        public BodyInserterResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, ResponseCookie> cookies, BodyInserter<T, ? super ServerHttpResponse> body2, Map<String, Object> hints) {
            super(statusCode, headers, cookies, hints);
            Assert.notNull(body2, "BodyInserter must not be null");
            this.inserter = body2;
        }

        @Override
        protected Mono<Void> writeToInternal(final ServerWebExchange exchange2, final ServerResponse.Context context) {
            return this.inserter.insert(exchange2.getResponse(), new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return context.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.of(exchange2.getRequest());
                }

                @Override
                public Map<String, Object> hints() {
                    hints.put(Hints.LOG_PREFIX_HINT, exchange2.getLogPrefix());
                    return hints;
                }
            });
        }
    }
}

