/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client.support;

import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebClientAdapter
implements HttpClientAdapter {
    private final WebClient webClient;

    private WebClientAdapter(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    public Mono<Void> requestToVoid(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().then();
    }

    @Override
    public Mono<HttpHeaders> requestToHeaders(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().map(HttpEntity::getHeaders);
    }

    @Override
    public <T> Mono<T> requestToBody(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToMono(bodyType);
    }

    @Override
    public <T> Flux<T> requestToBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToFlux(bodyType);
    }

    @Override
    public Mono<ResponseEntity<Void>> requestToBodilessEntity(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    @Override
    public <T> Mono<ResponseEntity<T>> requestToEntity(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntity(bodyType);
    }

    @Override
    public <T> Mono<ResponseEntity<Flux<T>>> requestToEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntityFlux(bodyType);
    }

    private WebClient.RequestBodySpec newRequest(HttpRequestValues requestValues) {
        WebClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = requestValues.getHttpMethod();
        Assert.notNull((Object)httpMethod, "HttpMethod is required");
        WebClient.RequestBodyUriSpec uriSpec = this.webClient.method(httpMethod);
        if (requestValues.getUri() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(requestValues.getUri());
        } else if (requestValues.getUriTemplate() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(requestValues.getUriTemplate(), requestValues.getUriVariables());
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        bodySpec.headers(headers -> headers.putAll(requestValues.getHeaders()));
        bodySpec.cookies(cookies -> cookies.putAll(requestValues.getCookies()));
        bodySpec.attributes(attributes -> attributes.putAll(requestValues.getAttributes()));
        if (requestValues.getBodyValue() != null) {
            bodySpec.bodyValue(requestValues.getBodyValue());
        } else if (requestValues.getBody() != null) {
            Assert.notNull(requestValues.getBodyElementType(), "Publisher body element type is required");
            bodySpec.body((Object)requestValues.getBody(), requestValues.getBodyElementType());
        }
        return bodySpec;
    }

    public static WebClientAdapter forClient(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }
}

