/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.PreFlightRequestHandler;
import org.springframework.web.reactive.DispatchExceptionHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DispatcherHandler
implements WebHandler,
PreFlightRequestHandler,
ApplicationContextAware {
    @Nullable
    private List<HandlerMapping> handlerMappings;
    @Nullable
    private List<HandlerAdapter> handlerAdapters;
    @Nullable
    private List<HandlerResultHandler> resultHandlers;

    public DispatcherHandler() {
    }

    public DispatcherHandler(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    @Nullable
    public final List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    protected void initStrategies(ApplicationContext context) {
        Map<String, HandlerMapping> mappingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, true, false);
        ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>(mappingBeans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        this.handlerMappings = Collections.unmodifiableList(mappings);
        Map<String, HandlerAdapter> adapterBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, true, false);
        this.handlerAdapters = new ArrayList<HandlerAdapter>(adapterBeans.values());
        AnnotationAwareOrderComparator.sort(this.handlerAdapters);
        Map<String, HandlerResultHandler> beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerResultHandler.class, true, false);
        this.resultHandlers = new ArrayList<HandlerResultHandler>(beans.values());
        AnnotationAwareOrderComparator.sort(this.resultHandlers);
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2) {
        if (this.handlerMappings == null) {
            return this.createNotFoundError();
        }
        if (CorsUtils.isPreFlightRequest(exchange2.getRequest())) {
            return this.handlePreFlight(exchange2);
        }
        return Flux.fromIterable(this.handlerMappings).concatMap(mapping -> mapping.getHandler(exchange2)).next().switchIfEmpty(this.createNotFoundError()).onErrorResume(ex -> this.handleDispatchError(exchange2, (Throwable)ex)).flatMap(handler -> this.handleRequestWith(exchange2, handler));
    }

    private <R> Mono<R> createNotFoundError() {
        return Mono.defer(() -> {
            ResponseStatusException ex = new ResponseStatusException(HttpStatus.NOT_FOUND);
            return Mono.error(ex);
        });
    }

    private Mono<Void> handleDispatchError(ServerWebExchange exchange2, Throwable ex) {
        Mono<HandlerResult> resultMono = Mono.error(ex);
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!(adapter instanceof DispatchExceptionHandler)) continue;
                DispatchExceptionHandler exceptionHandler = (DispatchExceptionHandler)((Object)adapter);
                resultMono = resultMono.onErrorResume(ex2 -> exceptionHandler.handleError(exchange2, (Throwable)ex2));
            }
        }
        return resultMono.flatMap(result -> this.handleResult(exchange2, (HandlerResult)result));
    }

    private Mono<Void> handleRequestWith(ServerWebExchange exchange2, Object handler) {
        if (ObjectUtils.nullSafeEquals(exchange2.getResponse().getStatusCode(), HttpStatus.FORBIDDEN)) {
            return Mono.empty();
        }
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!adapter.supports(handler)) continue;
                return adapter.handle(exchange2, handler).flatMap(result -> this.handleResult(exchange2, (HandlerResult)result));
            }
        }
        return Mono.error(new IllegalStateException("No HandlerAdapter: " + handler));
    }

    private Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult result) {
        Mono<Void> resultMono = this.doHandleResult(exchange2, result, "Handler " + result.getHandler());
        if (result.getExceptionHandler() != null) {
            resultMono = resultMono.onErrorResume(ex -> result.getExceptionHandler().handleError(exchange2, (Throwable)ex).flatMap(result2 -> this.doHandleResult(exchange2, (HandlerResult)result2, "Exception handler " + result2.getHandler() + ", error=\"" + ex.getMessage() + "\"")));
        }
        return resultMono;
    }

    private Mono<Void> doHandleResult(ServerWebExchange exchange2, HandlerResult handlerResult, String description) {
        if (this.resultHandlers != null) {
            for (HandlerResultHandler resultHandler : this.resultHandlers) {
                if (!resultHandler.supports(handlerResult)) continue;
                description = (String)description + " [DispatcherHandler]";
                return resultHandler.handleResult(exchange2, handlerResult).checkpoint((String)description);
            }
        }
        return Mono.error(new IllegalStateException("No HandlerResultHandler for " + handlerResult.getReturnValue()));
    }

    @Override
    public Mono<Void> handlePreFlight(ServerWebExchange exchange2) {
        return Flux.fromIterable(this.handlerMappings != null ? this.handlerMappings : Collections.emptyList()).concatMap(mapping -> mapping.getHandler(exchange2)).switchIfEmpty(Mono.fromRunnable(() -> exchange2.getResponse().setStatusCode(HttpStatus.FORBIDDEN))).next().then();
    }
}

