/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.MethodInfo;

class CompilerControlPlugin {
    private final SortedSet<String> lines = new TreeSet<String>();
    private final Set<MethodInfo> defaultForceInlineMethods = new TreeSet<MethodInfo>(Comparator.comparing(MethodInfo::getQualifiedName));
    private final Set<String> alwaysDontInlineMethods = new TreeSet<String>();

    CompilerControlPlugin() {
    }

    public void defaultForceInline(MethodInfo methodInfo) {
        this.defaultForceInlineMethods.add(methodInfo);
    }

    public void alwaysDontInline(String className, String methodName) {
        this.alwaysDontInlineMethods.add(CompilerControlPlugin.getName(className, methodName));
    }

    public void process(GeneratorSource source, GeneratorDestination destination) {
        try {
            CompilerControl.Mode command;
            CompilerControl ann;
            for (MethodInfo methodInfo : BenchmarkGeneratorUtils.getMethodsAnnotatedWith(source, CompilerControl.class)) {
                ann = methodInfo.getAnnotation(CompilerControl.class);
                if (ann == null) {
                    throw new IllegalStateException("No annotation");
                }
                command = ann.value();
                this.lines.add(command.command() + "," + CompilerControlPlugin.getName(methodInfo));
            }
            for (MethodInfo methodInfo : this.defaultForceInlineMethods) {
                if (methodInfo.getAnnotation(CompilerControl.class) != null || methodInfo.getDeclaringClass().getAnnotation(CompilerControl.class) != null) continue;
                this.lines.add(CompilerControl.Mode.INLINE.command() + "," + CompilerControlPlugin.getName(methodInfo));
            }
            for (String string : this.alwaysDontInlineMethods) {
                this.lines.add(CompilerControl.Mode.DONT_INLINE.command() + "," + string);
            }
            for (ClassInfo classInfo : BenchmarkGeneratorUtils.getClassesAnnotatedWith(source, CompilerControl.class)) {
                ann = classInfo.getAnnotation(CompilerControl.class);
                if (ann == null) {
                    throw new IllegalStateException("No annotation");
                }
                command = ann.value();
                this.lines.add(command.command() + "," + CompilerControlPlugin.getName(classInfo));
            }
        }
        catch (Throwable t) {
            destination.printError("Compiler control generators had thrown the unexpected exception", t);
        }
    }

    public void finish(GeneratorSource source, GeneratorDestination destination) {
        try (OutputStreamWriter w = new OutputStreamWriter(destination.newResource("/META-INF/CompilerHints".substring(1)), StandardCharsets.UTF_8);){
            PrintWriter writer = new PrintWriter(w);
            for (String line : this.lines) {
                writer.println(line);
            }
            writer.close();
        }
        catch (IOException ex) {
            destination.printError("Error writing compiler hint list ", ex);
        }
        catch (Throwable t) {
            destination.printError("Compiler control generators had thrown the unexpected exception", t);
        }
    }

    private static String getName(String className, String methodName) {
        return className.replaceAll("\\.", "/") + "." + methodName;
    }

    private static String getName(MethodInfo mi) {
        return CompilerControlPlugin.getName(CompilerControlPlugin.getClassName(mi.getDeclaringClass()), mi.getName());
    }

    private static String getName(ClassInfo ci) {
        return CompilerControlPlugin.getName(CompilerControlPlugin.getClassName(ci), "*");
    }

    private static String getClassName(ClassInfo ci) {
        return ci.getPackageName() + "." + BenchmarkGeneratorUtils.getNestedNames(ci);
    }
}

