/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMeters;
import reactor.netty.channel.MeterKey;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.http.HttpMetricsRecorder;
import reactor.netty.internal.util.MapUtils;

public class MicrometerHttpMetricsRecorder
extends MicrometerChannelMetricsRecorder
implements HttpMetricsRecorder {
    protected final ConcurrentMap<MeterKey, Timer> dataReceivedTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    protected final ConcurrentMap<MeterKey, Timer> dataSentTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    protected final ConcurrentMap<MeterKey, Timer> responseTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, DistributionSummary> dataSentCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    private final ConcurrentMap<MeterKey, Counter> errorsCache = new ConcurrentHashMap<MeterKey, Counter>();

    protected MicrometerHttpMetricsRecorder(String name, String protocol) {
        super(name, protocol);
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        DistributionSummary dataReceived = MapUtils.computeIfAbsent(this.dataReceivedCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.received")).baseUnit(ChannelMeters.DATA_RECEIVED.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        DistributionSummary dataSent = MapUtils.computeIfAbsent(this.dataSentCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.sent")).baseUnit(ChannelMeters.DATA_SENT.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(uri, address, null, null);
        Counter errors = MapUtils.computeIfAbsent(this.errorsCache, meterKey, key -> MicrometerHttpMetricsRecorder.filter(Counter.builder((String)(this.name() + ".errors")).tags(new String[]{ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address, ChannelMeters.ChannelMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }
}

