/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.DispatchExceptionHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.ControllerMethodResolver;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
DispatchExceptionHandler,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();
    @Nullable
    private WebBindingInitializer webBindingInitializer;
    @Nullable
    private ArgumentResolverConfigurer argumentResolverConfigurer;
    @Nullable
    private ReactiveAdapterRegistry reactiveAdapterRegistry;
    @Nullable
    private ConfigurableApplicationContext applicationContext;
    @Nullable
    private ControllerMethodResolver methodResolver;
    @Nullable
    private ModelInitializer modelInitializer;

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        Assert.notNull(messageReaders, "'messageReaders' must not be null");
        this.messageReaders = messageReaders;
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public void setWebBindingInitializer(@Nullable WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    @Nullable
    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setArgumentResolverConfigurer(@Nullable ArgumentResolverConfigurer configurer) {
        this.argumentResolverConfigurer = configurer;
    }

    @Nullable
    public ArgumentResolverConfigurer getArgumentResolverConfigurer() {
        return this.argumentResolverConfigurer;
    }

    public void setReactiveAdapterRegistry(@Nullable ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    @Nullable
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac;
            this.applicationContext = cac = (ConfigurableApplicationContext)applicationContext;
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, "ApplicationContext is required");
        if (CollectionUtils.isEmpty(this.messageReaders)) {
            ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
            this.messageReaders = codecConfigurer.getReaders();
        }
        if (this.argumentResolverConfigurer == null) {
            this.argumentResolverConfigurer = new ArgumentResolverConfigurer();
        }
        if (this.reactiveAdapterRegistry == null) {
            this.reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
        }
        this.methodResolver = new ControllerMethodResolver(this.argumentResolverConfigurer, this.reactiveAdapterRegistry, this.applicationContext, this.messageReaders);
        this.modelInitializer = new ModelInitializer(this.methodResolver, this.reactiveAdapterRegistry);
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerMethod;
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange2, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Assert.state(this.methodResolver != null && this.modelInitializer != null, "Not initialized");
        InitBinderBindingContext bindingContext = new InitBinderBindingContext(this.getWebBindingInitializer(), this.methodResolver.getInitBinderMethods(handlerMethod));
        InvocableHandlerMethod invocableMethod = this.methodResolver.getRequestMappingMethod(handlerMethod);
        DispatchExceptionHandler exceptionHandler = (exchange22, ex) -> this.handleException(exchange2, ex, handlerMethod, bindingContext);
        return this.modelInitializer.initModel(handlerMethod, bindingContext, exchange2).then(Mono.defer(() -> invocableMethod.invoke(exchange2, bindingContext, new Object[0]))).doOnNext(result -> result.setExceptionHandler(exceptionHandler)).doOnNext(result -> bindingContext.saveModel()).onErrorResume(ex -> exceptionHandler.handleError(exchange2, (Throwable)ex));
    }

    private Mono<HandlerResult> handleException(ServerWebExchange exchange2, Throwable exception, @Nullable HandlerMethod handlerMethod, @Nullable BindingContext bindingContext) {
        block7: {
            Assert.state(this.methodResolver != null, "Not initialized");
            exchange2.getAttributes().remove(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
            exchange2.getResponse().getHeaders().clearContentHeaders();
            InvocableHandlerMethod invocable = this.methodResolver.getExceptionHandlerMethod(exception, handlerMethod);
            if (invocable != null) {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug(exchange2.getLogPrefix() + "Using @ExceptionHandler " + invocable);
                    }
                    if (bindingContext != null) {
                        bindingContext.getModel().asMap().clear();
                    } else {
                        bindingContext = new BindingContext();
                    }
                    Throwable exToExpose = exception;
                    while (exToExpose != null) {
                        exceptions.add(exToExpose);
                        Throwable cause = exToExpose.getCause();
                        exToExpose = cause != exToExpose ? cause : null;
                    }
                    Object[] arguments = new Object[exceptions.size() + 1];
                    exceptions.toArray(arguments);
                    arguments[arguments.length - 1] = handlerMethod;
                    return invocable.invoke(exchange2, bindingContext, arguments);
                }
                catch (Throwable invocationEx) {
                    if (exceptions.contains(invocationEx) || !logger.isWarnEnabled()) break block7;
                    logger.warn(exchange2.getLogPrefix() + "Failure in @ExceptionHandler " + invocable, invocationEx);
                }
            }
        }
        return Mono.error(exception);
    }

    @Override
    public Mono<HandlerResult> handleError(ServerWebExchange exchange2, Throwable ex) {
        return this.handleException(exchange2, ex, null, null);
    }
}

