/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.server.ChangePathPatternParserVisitor;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RequestPredicates {
    private static final Log logger = LogFactory.getLog(RequestPredicates.class);

    public static RequestPredicate all() {
        return request -> true;
    }

    public static RequestPredicate method(HttpMethod httpMethod) {
        return new HttpMethodPredicate(httpMethod);
    }

    public static RequestPredicate methods(HttpMethod ... httpMethods) {
        return new HttpMethodPredicate(httpMethods);
    }

    public static RequestPredicate path(String pattern) {
        Assert.notNull(pattern, "'pattern' must not be null");
        if (!((String)pattern).isEmpty() && !((String)pattern).startsWith("/")) {
            pattern = "/" + (String)pattern;
        }
        return RequestPredicates.pathPredicates(PathPatternParser.defaultInstance).apply((String)pattern);
    }

    public static Function<String, RequestPredicate> pathPredicates(PathPatternParser patternParser) {
        Assert.notNull((Object)patternParser, "PathPatternParser must not be null");
        return pattern -> new PathPatternPredicate(patternParser.parse((String)pattern));
    }

    public static RequestPredicate headers(Predicate<ServerRequest.Headers> headersPredicate) {
        return new HeadersPredicate(headersPredicate);
    }

    public static RequestPredicate contentType(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        return new ContentTypePredicate(mediaTypes);
    }

    public static RequestPredicate accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, "'mediaTypes' must not be empty");
        return new AcceptPredicate(mediaTypes);
    }

    public static RequestPredicate GET(String pattern) {
        return RequestPredicates.method(HttpMethod.GET).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate HEAD(String pattern) {
        return RequestPredicates.method(HttpMethod.HEAD).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate POST(String pattern) {
        return RequestPredicates.method(HttpMethod.POST).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PUT(String pattern) {
        return RequestPredicates.method(HttpMethod.PUT).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate PATCH(String pattern) {
        return RequestPredicates.method(HttpMethod.PATCH).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate DELETE(String pattern) {
        return RequestPredicates.method(HttpMethod.DELETE).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate OPTIONS(String pattern) {
        return RequestPredicates.method(HttpMethod.OPTIONS).and(RequestPredicates.path(pattern));
    }

    public static RequestPredicate pathExtension(String extension) {
        Assert.notNull((Object)extension, "'extension' must not be null");
        return new PathExtensionPredicate(extension);
    }

    public static RequestPredicate pathExtension(Predicate<String> extensionPredicate) {
        return new PathExtensionPredicate(extensionPredicate);
    }

    public static RequestPredicate queryParam(String name, String value) {
        return new QueryParamPredicate(name, value);
    }

    public static RequestPredicate queryParam(String name, Predicate<String> predicate) {
        return new QueryParamPredicate(name, predicate);
    }

    private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual));
        }
    }

    private static void restoreAttributes(ServerRequest request, Map<String, Object> attributes) {
        request.attributes().clear();
        request.attributes().putAll(attributes);
    }

    private static Map<String, String> mergePathVariables(Map<String, String> oldVariables, Map<String, String> newVariables) {
        if (!newVariables.isEmpty()) {
            LinkedHashMap<String, String> mergedVariables = new LinkedHashMap<String, String>(oldVariables);
            mergedVariables.putAll(newVariables);
            return mergedVariables;
        }
        return oldVariables;
    }

    private static PathPattern mergePatterns(@Nullable PathPattern oldPattern, PathPattern newPattern) {
        if (oldPattern != null) {
            return oldPattern.combine(newPattern);
        }
        return newPattern;
    }

    private static class HttpMethodPredicate
    implements RequestPredicate {
        private final Set<HttpMethod> httpMethods;

        public HttpMethodPredicate(HttpMethod httpMethod) {
            Assert.notNull((Object)httpMethod, "HttpMethod must not be null");
            this.httpMethods = Collections.singleton(httpMethod);
        }

        public HttpMethodPredicate(HttpMethod ... httpMethods) {
            Assert.notEmpty((Object[])httpMethods, "HttpMethods must not be empty");
            this.httpMethods = new LinkedHashSet<HttpMethod>(Arrays.asList(httpMethods));
        }

        @Override
        public boolean test(ServerRequest request) {
            HttpMethod method = HttpMethodPredicate.method(request);
            boolean match = this.httpMethods.contains(method);
            RequestPredicates.traceMatch("Method", this.httpMethods, method, match);
            return match;
        }

        private static HttpMethod method(ServerRequest request) {
            String accessControlRequestMethod;
            if (CorsUtils.isPreFlightRequest(request.exchange().getRequest()) && (accessControlRequestMethod = request.headers().firstHeader("Access-Control-Request-Method")) != null) {
                return HttpMethod.valueOf(accessControlRequestMethod);
            }
            return request.method();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.method(Collections.unmodifiableSet(this.httpMethods));
        }

        public String toString() {
            if (this.httpMethods.size() == 1) {
                return this.httpMethods.iterator().next().toString();
            }
            return this.httpMethods.toString();
        }
    }

    private static class HeadersPredicate
    implements RequestPredicate {
        private final Predicate<ServerRequest.Headers> headersPredicate;

        public HeadersPredicate(Predicate<ServerRequest.Headers> headersPredicate) {
            Assert.notNull(headersPredicate, "Predicate must not be null");
            this.headersPredicate = headersPredicate;
        }

        @Override
        public boolean test(ServerRequest request) {
            if (CorsUtils.isPreFlightRequest(request.exchange().getRequest())) {
                return true;
            }
            return this.headersPredicate.test(request.headers());
        }

        public String toString() {
            return this.headersPredicate.toString();
        }
    }

    private static class ContentTypePredicate
    extends HeadersPredicate {
        private final Set<MediaType> mediaTypes;

        public ContentTypePredicate(MediaType ... mediaTypes) {
            this(Set.of(mediaTypes));
        }

        private ContentTypePredicate(Set<MediaType> mediaTypes) {
            super((ServerRequest.Headers headers) -> {
                MediaType contentType = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
                boolean match = mediaTypes.stream().anyMatch(mediaType -> mediaType.includes(contentType));
                RequestPredicates.traceMatch("Content-Type", mediaTypes, contentType, match);
                return match;
            });
            this.mediaTypes = mediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Content-Type", this.mediaTypes.size() == 1 ? this.mediaTypes.iterator().next().toString() : this.mediaTypes.toString());
        }

        @Override
        public String toString() {
            return String.format("Content-Type: %s", this.mediaTypes.size() == 1 ? this.mediaTypes.iterator().next().toString() : this.mediaTypes.toString());
        }
    }

    private static class AcceptPredicate
    extends HeadersPredicate {
        private final Set<MediaType> mediaTypes;

        public AcceptPredicate(MediaType ... mediaTypes) {
            this(Set.of(mediaTypes));
        }

        private AcceptPredicate(Set<MediaType> mediaTypes) {
            super((ServerRequest.Headers headers) -> {
                List<MediaType> acceptedMediaTypes = AcceptPredicate.acceptedMediaTypes(headers);
                boolean match = acceptedMediaTypes.stream().anyMatch(acceptedMediaType -> mediaTypes.stream().anyMatch(acceptedMediaType::isCompatibleWith));
                RequestPredicates.traceMatch("Accept", mediaTypes, acceptedMediaTypes, match);
                return match;
            });
            this.mediaTypes = mediaTypes;
        }

        @NonNull
        private static List<MediaType> acceptedMediaTypes(ServerRequest.Headers headers) {
            List<MediaType> acceptedMediaTypes = headers.accept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            } else {
                MimeTypeUtils.sortBySpecificity(acceptedMediaTypes);
            }
            return acceptedMediaTypes;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.header("Accept", this.mediaTypes.size() == 1 ? this.mediaTypes.iterator().next().toString() : this.mediaTypes.toString());
        }

        @Override
        public String toString() {
            return String.format("Accept: %s", this.mediaTypes.size() == 1 ? this.mediaTypes.iterator().next().toString() : this.mediaTypes.toString());
        }
    }

    private static class PathExtensionPredicate
    implements RequestPredicate {
        private final Predicate<String> extensionPredicate;
        @Nullable
        private final String extension;

        public PathExtensionPredicate(Predicate<String> extensionPredicate) {
            Assert.notNull(extensionPredicate, "Predicate must not be null");
            this.extensionPredicate = extensionPredicate;
            this.extension = null;
        }

        public PathExtensionPredicate(String extension) {
            Assert.notNull((Object)extension, "Extension must not be null");
            this.extensionPredicate = s -> {
                boolean match = extension.equalsIgnoreCase((String)s);
                RequestPredicates.traceMatch("Extension", extension, s, match);
                return match;
            };
            this.extension = extension;
        }

        @Override
        public boolean test(ServerRequest request) {
            String pathExtension = UriUtils.extractFileExtension(request.path());
            return this.extensionPredicate.test(pathExtension);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.pathExtension(this.extension != null ? this.extension : this.extensionPredicate.toString());
        }

        public String toString() {
            return String.format("*.%s", this.extension != null ? this.extension : this.extensionPredicate);
        }
    }

    private static class QueryParamPredicate
    implements RequestPredicate {
        private final String name;
        private final Predicate<String> valuePredicate;
        @Nullable
        private final String value;

        public QueryParamPredicate(String name, Predicate<String> valuePredicate) {
            Assert.notNull((Object)name, "Name must not be null");
            Assert.notNull(valuePredicate, "Predicate must not be null");
            this.name = name;
            this.valuePredicate = valuePredicate;
            this.value = null;
        }

        public QueryParamPredicate(String name, String value) {
            Assert.notNull((Object)name, "Name must not be null");
            Assert.notNull((Object)value, "Value must not be null");
            this.name = name;
            this.valuePredicate = value::equals;
            this.value = value;
        }

        @Override
        public boolean test(ServerRequest request) {
            Optional<String> s = request.queryParam(this.name);
            return s.filter(this.valuePredicate).isPresent();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.queryParam(this.name, this.value != null ? this.value : this.valuePredicate.toString());
        }

        public String toString() {
            return String.format("?%s %s", this.name, this.value != null ? this.value : this.valuePredicate);
        }
    }

    private static class PathPatternPredicate
    implements RequestPredicate,
    ChangePathPatternParserVisitor.Target {
        private PathPattern pattern;

        public PathPatternPredicate(PathPattern pattern) {
            Assert.notNull((Object)pattern, "'pattern' must not be null");
            this.pattern = pattern;
        }

        @Override
        public boolean test(ServerRequest request) {
            PathContainer pathContainer = request.requestPath().pathWithinApplication();
            PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(pathContainer);
            RequestPredicates.traceMatch("Pattern", this.pattern.getPatternString(), request.path(), info != null);
            if (info != null) {
                PathPatternPredicate.mergeAttributes(request, info.getUriVariables(), this.pattern);
                return true;
            }
            return false;
        }

        private static void mergeAttributes(ServerRequest request, Map<String, String> variables, PathPattern pattern) {
            Map<String, String> pathVariables = RequestPredicates.mergePathVariables(request.pathVariables(), variables);
            request.attributes().put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.unmodifiableMap(pathVariables));
            pattern = RequestPredicates.mergePatterns((PathPattern)request.attributes().get(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE), pattern);
            request.attributes().put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pattern);
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return Optional.ofNullable(this.pattern.matchStartOfPath(request.requestPath().pathWithinApplication())).map(info -> new SubPathServerRequestWrapper(request, (PathPattern.PathRemainingMatchInfo)info, this.pattern));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.path(this.pattern.getPatternString());
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            String patternString = this.pattern.getPatternString();
            this.pattern = parser.parse(patternString);
        }

        public String toString() {
            return this.pattern.getPatternString();
        }
    }

    private static class SubPathServerRequestWrapper
    implements ServerRequest {
        private final ServerRequest request;
        private final RequestPath requestPath;
        private final Map<String, Object> attributes;

        public SubPathServerRequestWrapper(ServerRequest request, PathPattern.PathRemainingMatchInfo info, PathPattern pattern) {
            this.request = request;
            this.requestPath = SubPathServerRequestWrapper.requestPath(request.requestPath(), info);
            this.attributes = SubPathServerRequestWrapper.mergeAttributes(request, info.getUriVariables(), pattern);
        }

        private static RequestPath requestPath(RequestPath original, PathPattern.PathRemainingMatchInfo info) {
            StringBuilder contextPath = new StringBuilder(original.contextPath().value());
            contextPath.append(info.getPathMatched().value());
            int length = contextPath.length();
            if (length > 0 && contextPath.charAt(length - 1) == '/') {
                contextPath.setLength(length - 1);
            }
            return original.modifyContextPath(contextPath.toString());
        }

        private static Map<String, Object> mergeAttributes(ServerRequest request, Map<String, String> pathVariables, PathPattern pattern) {
            ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(request.attributes());
            result.put(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, RequestPredicates.mergePathVariables(request.pathVariables(), pathVariables));
            pattern = RequestPredicates.mergePatterns((PathPattern)request.attributes().get(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE), pattern);
            result.put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pattern);
            return result;
        }

        @Override
        public HttpMethod method() {
            return this.request.method();
        }

        @Override
        @Deprecated
        public String methodName() {
            return this.request.methodName();
        }

        @Override
        public URI uri() {
            return this.request.uri();
        }

        @Override
        public UriBuilder uriBuilder() {
            return this.request.uriBuilder();
        }

        @Override
        public RequestPath requestPath() {
            return this.requestPath;
        }

        @Override
        public ServerRequest.Headers headers() {
            return this.request.headers();
        }

        @Override
        public MultiValueMap<String, HttpCookie> cookies() {
            return this.request.cookies();
        }

        @Override
        public Optional<InetSocketAddress> remoteAddress() {
            return this.request.remoteAddress();
        }

        @Override
        public Optional<InetSocketAddress> localAddress() {
            return this.request.localAddress();
        }

        @Override
        public List<HttpMessageReader<?>> messageReaders() {
            return this.request.messageReaders();
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
            return this.request.body(extractor);
        }

        @Override
        public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
            return this.request.body(extractor, hints);
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
            return this.request.bodyToMono(elementClass);
        }

        @Override
        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
            return this.request.bodyToMono(typeReference);
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
            return this.request.bodyToFlux(elementClass);
        }

        @Override
        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
            return this.request.bodyToFlux(typeReference);
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public Optional<String> queryParam(String name) {
            return this.request.queryParam(name);
        }

        @Override
        public MultiValueMap<String, String> queryParams() {
            return this.request.queryParams();
        }

        @Override
        public Map<String, String> pathVariables() {
            return this.attributes.getOrDefault(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
        }

        @Override
        public Mono<WebSession> session() {
            return this.request.session();
        }

        @Override
        public Mono<? extends Principal> principal() {
            return this.request.principal();
        }

        @Override
        public Mono<MultiValueMap<String, String>> formData() {
            return this.request.formData();
        }

        @Override
        public Mono<MultiValueMap<String, Part>> multipartData() {
            return this.request.multipartData();
        }

        @Override
        public ServerWebExchange exchange() {
            return this.request.exchange();
        }

        public String toString() {
            return this.method() + " " + this.path();
        }
    }

    static class OrRequestPredicate
    implements RequestPredicate,
    ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestPredicate right;

        public OrRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerRequest request) {
            HashMap<String, Object> oldAttributes = new HashMap<String, Object>(request.attributes());
            if (this.left.test(request)) {
                return true;
            }
            RequestPredicates.restoreAttributes(request, oldAttributes);
            if (this.right.test(request)) {
                return true;
            }
            RequestPredicates.restoreAttributes(request, oldAttributes);
            return false;
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            Optional<ServerRequest> leftResult = this.left.nest(request);
            if (leftResult.isPresent()) {
                return leftResult;
            }
            return this.right.nest(request);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startOr();
            this.left.accept(visitor);
            visitor.or();
            this.right.accept(visitor);
            visitor.endOr();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target leftTarget = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                leftTarget.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target rightTarget = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                rightTarget.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s || %s)", this.left, this.right);
        }
    }

    static class NegateRequestPredicate
    implements RequestPredicate,
    ChangePathPatternParserVisitor.Target {
        private final RequestPredicate delegate;

        public NegateRequestPredicate(RequestPredicate delegate) {
            Assert.notNull((Object)delegate, "Delegate must not be null");
            this.delegate = delegate;
        }

        @Override
        public boolean test(ServerRequest request) {
            boolean result;
            HashMap<String, Object> oldAttributes = new HashMap<String, Object>(request.attributes());
            boolean bl = result = !this.delegate.test(request);
            if (!result) {
                RequestPredicates.restoreAttributes(request, oldAttributes);
            }
            return result;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNegate();
            this.delegate.accept(visitor);
            visitor.endNegate();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            RequestPredicate requestPredicate = this.delegate;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target target = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                target.changeParser(parser);
            }
        }

        public String toString() {
            return "!" + this.delegate.toString();
        }
    }

    static class AndRequestPredicate
    implements RequestPredicate,
    ChangePathPatternParserVisitor.Target {
        private final RequestPredicate left;
        private final RequestPredicate right;

        public AndRequestPredicate(RequestPredicate left, RequestPredicate right) {
            Assert.notNull((Object)left, "Left RequestPredicate must not be null");
            Assert.notNull((Object)right, "Right RequestPredicate must not be null");
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(ServerRequest request) {
            HashMap<String, Object> oldAttributes = new HashMap<String, Object>(request.attributes());
            if (this.left.test(request) && this.right.test(request)) {
                return true;
            }
            RequestPredicates.restoreAttributes(request, oldAttributes);
            return false;
        }

        @Override
        public Optional<ServerRequest> nest(ServerRequest request) {
            return this.left.nest(request).flatMap(this.right::nest);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startAnd();
            this.left.accept(visitor);
            visitor.and();
            this.right.accept(visitor);
            visitor.endAnd();
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            RequestPredicate requestPredicate = this.left;
            if (requestPredicate instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target leftTarget = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                leftTarget.changeParser(parser);
            }
            if ((requestPredicate = this.right) instanceof ChangePathPatternParserVisitor.Target) {
                ChangePathPatternParserVisitor.Target rightTarget = (ChangePathPatternParserVisitor.Target)((Object)requestPredicate);
                rightTarget.changeParser(parser);
            }
        }

        public String toString() {
            return String.format("(%s && %s)", this.left, this.right);
        }
    }

    public static interface Visitor {
        public void method(Set<HttpMethod> var1);

        public void path(String var1);

        public void pathExtension(String var1);

        public void header(String var1, String var2);

        public void queryParam(String var1, String var2);

        public void startAnd();

        public void and();

        public void endAnd();

        public void startOr();

        public void or();

        public void endOr();

        public void startNegate();

        public void endNegate();

        public void unknown(RequestPredicate var1);
    }
}

