/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncContextSupplier;
import feign.Contract;
import feign.DefaultMethodHandler;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMapEncoder;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.template.UriUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ReflectiveFeign<C>
extends Feign {
    private final ParseHandlersByName<C> targetToHandlersByName;
    private final InvocationHandlerFactory factory;
    private final AsyncContextSupplier<C> defaultContextSupplier;

    ReflectiveFeign(ParseHandlersByName<C> targetToHandlersByName, InvocationHandlerFactory factory, AsyncContextSupplier<C> defaultContextSupplier) {
        this.targetToHandlersByName = targetToHandlersByName;
        this.factory = factory;
        this.defaultContextSupplier = defaultContextSupplier;
    }

    @Override
    public <T> T newInstance(Target<T> target) {
        return this.newInstance(target, this.defaultContextSupplier.newContext());
    }

    public <T> T newInstance(Target<T> target, C requestContext) {
        TargetSpecificationVerifier.verify(target);
        Map<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = this.targetToHandlersByName.apply(target, requestContext);
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (InvocationHandlerFactory.MethodHandler methodHandler : methodToHandler.values()) {
            if (!(methodHandler instanceof DefaultMethodHandler)) continue;
            ((DefaultMethodHandler)methodHandler).bindTo(proxy);
        }
        return (T)proxy;
    }

    private static class TargetSpecificationVerifier {
        private TargetSpecificationVerifier() {
        }

        public static <T> void verify(Target<T> target) {
            Class<T> type = target.type();
            if (!type.isInterface()) {
                throw new IllegalArgumentException("Type must be an interface: " + type);
            }
            for (Method m : type.getMethods()) {
                Class<?> retType = m.getReturnType();
                if (!CompletableFuture.class.isAssignableFrom(retType)) continue;
                if (retType != CompletableFuture.class) {
                    throw new IllegalArgumentException("Method return type is not CompleteableFuture: " + TargetSpecificationVerifier.getFullMethodName(type, retType, m));
                }
                Type genRetType = m.getGenericReturnType();
                if (!(genRetType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Method return type is not parameterized: " + TargetSpecificationVerifier.getFullMethodName(type, genRetType, m));
                }
                if (!(((ParameterizedType)genRetType).getActualTypeArguments()[0] instanceof WildcardType)) continue;
                throw new IllegalArgumentException("Wildcards are not supported for return-type parameters: " + TargetSpecificationVerifier.getFullMethodName(type, genRetType, m));
            }
        }

        private static String getFullMethodName(Class<?> type, Type retType, Method m) {
            return retType.getTypeName() + " " + type.toGenericString() + "." + m.getName();
        }
    }

    private static class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            boolean alwaysEncodeBody = mutable.methodMetadata().alwaysEncodeBody();
            Object[] body2 = null;
            if (!alwaysEncodeBody) {
                body2 = argv[this.metadata.bodyIndex()];
                Util.checkArgument(body2 != null, "Body parameter %s was null", this.metadata.bodyIndex());
            }
            try {
                if (alwaysEncodeBody) {
                    body2 = argv == null ? new Object[]{} : argv;
                    this.encoder.encode(body2, (Type)((Object)Object[].class), mutable);
                } else {
                    this.encoder.encode(body2, this.metadata.bodyType(), mutable);
                }
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildFormEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            LinkedHashMap<String, Object> formVariables = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildTemplateByResolvingArgs
    implements RequestTemplate.Factory {
        private final QueryMapEncoder queryMapEncoder;
        protected final MethodMetadata metadata;
        protected final Target<?> target;
        private final Map<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();

        private BuildTemplateByResolvingArgs(MethodMetadata metadata, QueryMapEncoder queryMapEncoder, Target target) {
            this.metadata = metadata;
            this.target = target;
            this.queryMapEncoder = queryMapEncoder;
            if (metadata.indexToExpander() != null) {
                this.indexToExpander.putAll(metadata.indexToExpander());
                return;
            }
            if (metadata.indexToExpanderClass().isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Class<? extends Param.Expander>> indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
                try {
                    this.indexToExpander.put(indexToExpanderClass.getKey(), indexToExpanderClass.getValue().newInstance());
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public RequestTemplate create(Object[] argv) {
            Object value;
            RequestTemplate mutable = RequestTemplate.from(this.metadata.template());
            mutable.feignTarget(this.target);
            if (this.metadata.urlIndex() != null) {
                int urlIndex = this.metadata.urlIndex();
                Util.checkArgument(argv[urlIndex] != null, "URI parameter %s was null", urlIndex);
                mutable.target(String.valueOf(argv[urlIndex]));
            }
            LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
            for (Map.Entry<Integer, Collection<String>> entry : this.metadata.indexToName().entrySet()) {
                int i2 = entry.getKey();
                Object value2 = argv[entry.getKey()];
                if (value2 == null) continue;
                if (this.indexToExpander.containsKey(i2)) {
                    value2 = this.expandElements(this.indexToExpander.get(i2), value2);
                }
                for (String name : entry.getValue()) {
                    varBuilder.put(name, value2);
                }
            }
            RequestTemplate template = this.resolve(argv, mutable, varBuilder);
            if (this.metadata.queryMapIndex() != null) {
                value = argv[this.metadata.queryMapIndex()];
                Map<String, Object> queryMap = this.toQueryMap(value);
                template = this.addQueryMapQueryParameters(queryMap, template);
            }
            if (this.metadata.headerMapIndex() != null) {
                value = argv[this.metadata.headerMapIndex()];
                Map<String, Object> headerMap = this.toQueryMap(value);
                template = this.addHeaderMapHeaders(headerMap, template);
            }
            return template;
        }

        private Map<String, Object> toQueryMap(Object value) {
            if (value instanceof Map) {
                return (Map)value;
            }
            try {
                return this.queryMapEncoder.encode(value);
            }
            catch (EncodeException e) {
                throw new IllegalStateException(e);
            }
        }

        private Object expandElements(Param.Expander expander, Object value) {
            if (value instanceof Iterable) {
                return this.expandIterable(expander, (Iterable)value);
            }
            return expander.expand(value);
        }

        private List<String> expandIterable(Param.Expander expander, Iterable value) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object element : value) {
                if (element == null) continue;
                values.add(expander.expand(element));
            }
            return values;
        }

        private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values.add(nextObject == null ? null : nextObject.toString());
                    }
                } else {
                    values.add(currValue == null ? null : currValue.toString());
                }
                mutable.header(currEntry.getKey(), values);
            }
            return mutable;
        }

        private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values.add(nextObject == null ? null : UriUtils.encode(nextObject.toString()));
                    }
                } else if (currValue instanceof Object[]) {
                    for (Object value : (Object[])currValue) {
                        values.add(value == null ? null : UriUtils.encode(value.toString()));
                    }
                } else if (currValue != null) {
                    values.add(UriUtils.encode(currValue.toString()));
                }
                if (values.size() <= 0) continue;
                mutable.query(UriUtils.encode(currEntry.getKey()), values);
            }
            return mutable;
        }

        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            return mutable.resolve(variables);
        }
    }

    static final class ParseHandlersByName<C> {
        private final Contract contract;
        private final Encoder encoder;
        private final QueryMapEncoder queryMapEncoder;
        private final InvocationHandlerFactory.MethodHandler.Factory<C> factory;

        ParseHandlersByName(Contract contract, Encoder encoder, QueryMapEncoder queryMapEncoder, InvocationHandlerFactory.MethodHandler.Factory<C> factory) {
            this.contract = contract;
            this.factory = factory;
            this.queryMapEncoder = queryMapEncoder;
            this.encoder = Util.checkNotNull(encoder, "encoder", new Object[0]);
        }

        public Map<Method, InvocationHandlerFactory.MethodHandler> apply(Target target, C requestContext) {
            LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> result = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
            List<MethodMetadata> metadataList = this.contract.parseAndValidateMetadata(target.type());
            for (MethodMetadata md : metadataList) {
                Method method = md.method();
                if (method.getDeclaringClass() == Object.class) continue;
                InvocationHandlerFactory.MethodHandler handler = this.createMethodHandler(target, md, requestContext);
                result.put(method, handler);
            }
            for (Method method : target.type().getMethods()) {
                if (!Util.isDefault(method)) continue;
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                result.put(method, handler);
            }
            return result;
        }

        private InvocationHandlerFactory.MethodHandler createMethodHandler(Target<?> target, MethodMetadata md, C requestContext) {
            if (md.isIgnored()) {
                return args -> {
                    throw new IllegalStateException(md.configKey() + " is not a method handled by feign");
                };
            }
            BuildTemplateByResolvingArgs buildTemplate = this.getBuildTemplate(target, md);
            return this.factory.create(target, md, buildTemplate, requestContext);
        }

        private BuildTemplateByResolvingArgs getBuildTemplate(Target target, MethodMetadata md) {
            if (!md.formParams().isEmpty() && md.template().bodyTemplate() == null) {
                return new BuildFormEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target);
            }
            if (md.bodyIndex() != null || md.alwaysEncodeBody()) {
                return new BuildEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target);
            }
            return new BuildTemplateByResolvingArgs(md, this.queryMapEncoder, target);
        }
    }

    static class FeignInvocationHandler
    implements InvocationHandler {
        private final Target target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        FeignInvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = Util.checkNotNull(target, "target", new Object[0]);
            this.dispatch = Util.checkNotNull(dispatch, "dispatch for %s", target);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                try {
                    InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                    return this.equals(otherHandler);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            return this.dispatch.get(method).invoke(args);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeignInvocationHandler) {
                FeignInvocationHandler other = (FeignInvocationHandler)obj;
                return this.target.equals(other.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

