/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedAnnotation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    @Nullable
    private volatile Integer hashCode;
    @Nullable
    private volatile String string;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> annotation, Class<A> type) {
        Assert.notNull(annotation, "MergedAnnotation must not be null");
        Assert.notNull(type, "Type must not be null");
        Assert.isTrue(type.isAnnotation(), "Type must be an annotation");
        this.annotation = annotation;
        this.type = type;
        this.attributes = AttributeMethods.forAnnotationType(type);
    }

    @Override
    public Object invoke(Object proxy, Method method2, Object[] args) {
        if (ReflectionUtils.isEqualsMethod(method2)) {
            return this.annotationEquals(args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method2)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod(method2)) {
            return this.annotationToString();
        }
        if (this.isAnnotationTypeMethod(method2)) {
            return this.type;
        }
        if (this.attributes.indexOf(method2.getName()) != -1) {
            return this.getAttributeValue(method2);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method2, this.type));
    }

    private boolean isAnnotationTypeMethod(Method method2) {
        return method2.getName().equals("annotationType") && method2.getParameterCount() == 0;
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Object otherValue;
            Method attribute = this.attributes.get(i2);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = AnnotationUtils.invokeAnnotationMethod(attribute, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = this.computeHashCode();
        }
        return hashCode;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            Object value = this.getAttributeValue(attribute);
            hashCode += 127 * attribute.getName().hashCode() ^ this.getValueHashCode(value);
        }
        return hashCode;
    }

    private int getValueHashCode(Object value) {
        if (value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.hashCode((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.hashCode((char[])value);
        }
        if (value instanceof double[]) {
            return Arrays.hashCode((double[])value);
        }
        if (value instanceof float[]) {
            return Arrays.hashCode((float[])value);
        }
        if (value instanceof int[]) {
            return Arrays.hashCode((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.hashCode((long[])value);
        }
        if (value instanceof short[]) {
            return Arrays.hashCode((short[])value);
        }
        if (value instanceof Object[]) {
            return Arrays.hashCode((Object[])value);
        }
        return value.hashCode();
    }

    private String annotationToString() {
        String string = this.string;
        if (string == null) {
            StringBuilder builder = new StringBuilder("@").append(SynthesizedMergedAnnotationInvocationHandler.getName(this.type)).append('(');
            for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
                Method attribute = this.attributes.get(i2);
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(attribute.getName());
                builder.append('=');
                builder.append(this.toString(this.getAttributeValue(attribute)));
            }
            builder.append(')');
            this.string = string = builder.toString();
        }
        return string;
    }

    private String toString(Object value) {
        if (value instanceof String) {
            return '\"' + value.toString() + '\"';
        }
        if (value instanceof Character) {
            return '\'' + value.toString() + '\'';
        }
        if (value instanceof Byte) {
            return String.format("(byte) 0x%02X", value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value) + 'L';
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue()) + 'f';
        }
        if (value instanceof Double) {
            return Double.toString((Double)value) + 'd';
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Class) {
            return SynthesizedMergedAnnotationInvocationHandler.getName((Class)value) + ".class";
        }
        if (value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder("{");
            for (int i2 = 0; i2 < Array.getLength(value); ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(Array.get(value, i2)));
            }
            builder.append('}');
            return builder.toString();
        }
        return String.valueOf(value);
    }

    private Object getAttributeValue(Method method2) {
        Object value = this.valueCache.computeIfAbsent(method2.getName(), attributeName -> {
            Class<?> type = ClassUtils.resolvePrimitiveIfNecessary(method2.getReturnType());
            return this.annotation.getValue((String)attributeName, type).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + attributeName + "' in merged annotation " + this.annotation.getType().getName()));
        });
        if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = this.cloneArray(value);
        }
        return value;
    }

    private Object cloneArray(Object array) {
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        return ((Object[])array).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> annotation, Class<A> type) {
        Class[] classArray;
        ClassLoader classLoader = type.getClassLoader();
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type);
        if (SynthesizedMergedAnnotationInvocationHandler.isVisible(classLoader, SynthesizedAnnotation.class)) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = type;
            classArray = classArray2;
            classArray2[1] = SynthesizedAnnotation.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = type;
        }
        Class[] interfaces = classArray;
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces, handler));
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }

    private static boolean isVisible(ClassLoader classLoader, Class<?> interfaceClass) {
        if (classLoader == interfaceClass.getClassLoader()) {
            return true;
        }
        try {
            return Class.forName(interfaceClass.getName(), false, classLoader) == interfaceClass;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

