/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.Jetty10WebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class Jetty10RequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final Class<?> webSocketCreatorClass;
    private static final Method getContainerMethod;
    private static final Method upgradeMethod;
    private static final Method setAcceptedSubProtocol;

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpServletRequest servletRequest = (HttpServletRequest)ServerHttpRequestDecorator.getNativeRequest(request);
        HttpServletResponse servletResponse = (HttpServletResponse)ServerHttpResponseDecorator.getNativeResponse(response);
        ServletContext servletContext = servletRequest.getServletContext();
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory factory = response.bufferFactory();
        return exchange2.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            Jetty10WebSocketHandlerAdapter adapter = new Jetty10WebSocketHandlerAdapter(ContextWebSocketHandler.decorate(handler, contextView), session -> new JettyWebSocketSession((Session)session, handshakeInfo, factory));
            try {
                Object creator = Jetty10RequestUpgradeStrategy.createJettyWebSocketCreator(adapter, subProtocol);
                Object container = ReflectionUtils.invokeMethod(getContainerMethod, null, servletContext);
                ReflectionUtils.invokeMethod(upgradeMethod, container, creator, servletRequest, servletResponse);
            }
            catch (Exception ex) {
                return Mono.error(ex);
            }
            return Mono.empty();
        }));
    }

    private static Object createJettyWebSocketCreator(Jetty10WebSocketHandlerAdapter adapter, @Nullable String protocol) {
        ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
        factory.addInterface(webSocketCreatorClass);
        factory.addAdvice((Advice)new WebSocketCreatorInterceptor(adapter, protocol));
        return factory.getProxy();
    }

    static {
        ClassLoader loader = Jetty10RequestUpgradeStrategy.class.getClassLoader();
        try {
            webSocketCreatorClass = loader.loadClass("org.eclipse.jetty.websocket.server.JettyWebSocketCreator");
            Class<?> type = loader.loadClass("org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer");
            getContainerMethod = type.getMethod("getContainer", ServletContext.class);
            Method upgrade = ReflectionUtils.findMethod(type, "upgrade", null);
            Assert.state(upgrade != null, "Upgrade method not found");
            upgradeMethod = upgrade;
            type = loader.loadClass("org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse");
            setAcceptedSubProtocol = type.getMethod("setAcceptedSubProtocol", String.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("No compatible Jetty version found", ex);
        }
    }

    private static class WebSocketCreatorInterceptor
    implements MethodInterceptor {
        private final Jetty10WebSocketHandlerAdapter adapter;
        @Nullable
        private final String protocol;

        public WebSocketCreatorInterceptor(Jetty10WebSocketHandlerAdapter adapter, @Nullable String protocol) {
            this.adapter = adapter;
            this.protocol = protocol;
        }

        @Nullable
        public Object invoke(@NonNull MethodInvocation invocation) {
            if (this.protocol != null) {
                ReflectionUtils.invokeMethod(setAcceptedSubProtocol, invocation.getArguments()[1], this.protocol);
            }
            return this.adapter;
        }
    }
}

