/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.BiFunction;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.webclient.CustomizableWebClientBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public abstract class CoreWebBuilder<T>
extends ReactiveFeign.Builder<T> {
    protected CustomizableWebClientBuilder webClientBuilder;

    protected CoreWebBuilder(WebClient.Builder webClientBuilder) {
        this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
        this.webClientBuilder.clientConnector(this.buildClientConnector());
        this.updateClientFactory();
    }

    protected CoreWebBuilder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
        this.webClientBuilder.clientConnector(this.buildClientConnector());
        webClientCustomizer.accept(this.webClientBuilder);
        this.updateClientFactory();
    }

    @Override
    public ReactiveFeignBuilder<T> objectMapper(ObjectMapper objectMapper) {
        this.webClientBuilder.exchangeStrategies(builder -> builder.codecs(configurer -> {
            ClientCodecConfigurer.ClientDefaultCodecs clientDefaultCodecs = configurer.defaultCodecs();
            clientDefaultCodecs.jackson2JsonDecoder(new Jackson2JsonDecoder(objectMapper, new MimeType[0]));
            clientDefaultCodecs.jackson2JsonEncoder(new Jackson2JsonEncoder(objectMapper, new MimeType[0]));
        }));
        this.updateClientFactory();
        return this;
    }

    protected void updateClientFactory() {
        this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, this.webClientBuilder.build(), this.errorMapper()));
    }

    protected abstract BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper();

    protected abstract ClientHttpConnector buildClientConnector();
}

