/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.multipart.PartHttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.client.ReactiveHttpClientFactory;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public abstract class CoreWebBuilder<T>
extends ReactiveFeign.Builder<T> {
    private static final List<MediaType> MULTIPART_MEDIA_TYPES = Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED);
    protected WebClient.Builder webClientBuilder;
    protected WebClientFeignCustomizer webClientCustomizer;

    protected CoreWebBuilder(WebClient.Builder webClientBuilder) {
        this.webClientBuilder = webClientBuilder;
        this.webClientBuilder.codecs(this.multipartCodec());
    }

    protected CoreWebBuilder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        this(webClientBuilder);
        this.webClientCustomizer = webClientCustomizer;
    }

    @Override
    protected ReactiveHttpClientFactory clientFactory() {
        this.webClientBuilder.clientConnector(this.clientConnector());
        if (this.webClientCustomizer != null) {
            this.webClientCustomizer.accept(this.webClientBuilder);
        }
        return methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, this.webClientBuilder.build(), this.errorMapper());
    }

    @Override
    public ReactiveFeignBuilder<T> objectMapper(ObjectMapper objectMapper) {
        this.webClientBuilder.codecs(codecsConfigurer -> {
            ClientCodecConfigurer.ClientDefaultCodecs clientDefaultCodecs = codecsConfigurer.defaultCodecs();
            clientDefaultCodecs.jackson2JsonDecoder(new Jackson2JsonDecoder(objectMapper, new MimeType[0]));
            clientDefaultCodecs.jackson2JsonEncoder(new Jackson2JsonEncoder(objectMapper, new MimeType[0]));
        });
        return this;
    }

    protected abstract BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper();

    protected abstract ClientHttpConnector clientConnector();

    private Consumer<ClientCodecConfigurer> multipartCodec() {
        return clientCodecConfigurer -> clientCodecConfigurer.customCodecs().register(new PartHttpMessageWriter(){

            @Override
            public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
                return this.isMediaTypeCompatible(mediaType) && Part.class.isAssignableFrom(elementType.toClass());
            }

            public boolean isMediaTypeCompatible(@Nullable MediaType mediaType) {
                if (mediaType == null) {
                    return true;
                }
                for (MediaType supportedMediaType : MULTIPART_MEDIA_TYPES) {
                    if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

