/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentType {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"/]*)/?>");
    private final String mediaType;
    private final Charset charset;

    private ContentType(String mediaType, Charset charset) {
        this.mediaType = mediaType;
        this.charset = charset;
    }

    public static ContentType parse(String contentType2) {
        int splitPos = contentType2.indexOf(59);
        if (splitPos == -1) {
            return new ContentType(contentType2, StandardCharsets.UTF_8);
        }
        String mediaType = contentType2.substring(0, splitPos).trim();
        Charset charset = ContentType.getCharsetFromContentType(contentType2.substring(splitPos + 1));
        return new ContentType(mediaType, charset);
    }

    private static Charset getCharsetFromContentType(CharSequence contentType2) {
        if (contentType2 == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType2);
        if (m.find()) {
            String charset = m.group(1).trim();
            if (Charset.isSupported(charset)) {
                return Charset.forName(charset);
            }
            if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                return Charset.forName(charset);
            }
        }
        return StandardCharsets.UTF_8;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

