/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivejson.ReactorObjectReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyReactiveHttpResponse
implements ReactiveHttpResponse {
    public static final String CHARSET_DELIMITER = ";charset=";
    private ReactiveHttpRequest request;
    private final Response clientResponse;
    private final Publisher<ContentChunk> contentChunks;
    private final Class returnPublisherType;
    private Class<?> returnActualClass;
    private final ObjectReader objectReader;
    private final JsonFactory jsonFactory;

    JettyReactiveHttpResponse(ReactiveHttpRequest request, Response clientResponse, Publisher<ContentChunk> contentChunks, Class returnPublisherType, Class returnActualClass, JsonFactory jsonFactory, ObjectReader objectReader) {
        this.request = request;
        this.clientResponse = clientResponse;
        this.contentChunks = contentChunks;
        this.returnPublisherType = returnPublisherType;
        this.returnActualClass = returnActualClass;
        this.objectReader = objectReader;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public ReactiveHttpRequest request() {
        return this.request;
    }

    @Override
    public int status() {
        return this.clientResponse.getStatus();
    }

    @Override
    public Map<String, List<String>> headers() {
        HttpFields headers2 = this.clientResponse.getHeaders();
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>(headers2.size());
        headers2.forEach(httpField -> headersMap.compute(httpField.getName(), (oldName, oldValues) -> {
            List<String> values;
            if (oldValues == null) {
                values = Arrays.asList(httpField.getValues());
            } else {
                values = new ArrayList<String>(oldValues.size() + httpField.getValues().length);
                values.addAll((Collection<String>)oldValues);
                values.addAll(Arrays.asList(httpField.getValues()));
            }
            return values;
        }));
        return headersMap;
    }

    public Publisher<?> body() {
        ReactorObjectReader reactorObjectReader = new ReactorObjectReader(this.jsonFactory);
        Flux<ByteBuffer> content = this.directContent();
        if (this.returnActualClass == ByteBuffer.class) {
            return content;
        }
        if (this.returnActualClass.isAssignableFrom(String.class) && this.returnPublisherType == Mono.class) {
            Charset charset = this.getCharset();
            return content.map(byteBuffer -> charset.decode((ByteBuffer)byteBuffer).toString());
        }
        if (this.returnPublisherType == Mono.class) {
            return reactorObjectReader.read(content, this.objectReader);
        }
        if (this.returnPublisherType == Flux.class) {
            return reactorObjectReader.readElements(content, this.objectReader);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    @Override
    public Mono<Void> releaseBody() {
        return Flux.from(this.contentChunks).then();
    }

    private Charset getCharset() {
        return Optional.ofNullable(this.clientResponse.getHeaders().get(HttpHeader.CONTENT_TYPE.asString())).map(header -> {
            int pos = header.indexOf(CHARSET_DELIMITER);
            if (pos >= 0) {
                return header.substring(pos + CHARSET_DELIMITER.length());
            }
            return null;
        }).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    private Flux<ByteBuffer> directContent() {
        return Flux.from(this.contentChunks).map(contentChunk -> contentChunk.buffer.slice());
    }

    @Override
    public Mono<byte[]> bodyData() {
        return this.joinChunks();
    }

    private Mono<byte[]> joinChunks() {
        return this.directContent().reduce(new ByteArrayOutputStream(), (baos, byteBuffer) -> {
            int limit = byteBuffer.limit();
            for (int i2 = byteBuffer.position(); i2 < limit; ++i2) {
                baos.write(byteBuffer.get(i2));
            }
            return baos;
        }).map(ByteArrayOutputStream::toByteArray);
    }
}

