/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface HandlerFilterFunction<T extends ServerResponse, R extends ServerResponse> {
    public Mono<R> filter(ServerRequest var1, HandlerFunction<T> var2);

    default public HandlerFilterFunction<T, R> andThen(HandlerFilterFunction<T, T> after) {
        Assert.notNull(after, "HandlerFilterFunction must not be null");
        return (request, next) -> {
            HandlerFunction nextHandler = handlerRequest -> after.filter(handlerRequest, next);
            return this.filter(request, nextHandler);
        };
    }

    default public HandlerFunction<R> apply(HandlerFunction<T> handler) {
        Assert.notNull(handler, "HandlerFunction must not be null");
        return request -> this.filter(request, handler);
    }

    public static HandlerFilterFunction<?, ?> ofRequestProcessor(Function<ServerRequest, Mono<ServerRequest>> requestProcessor) {
        Assert.notNull(requestProcessor, "Function must not be null");
        return (request, next) -> ((Mono)requestProcessor.apply(request)).flatMap(next::handle);
    }

    public static <T extends ServerResponse, R extends ServerResponse> HandlerFilterFunction<T, R> ofResponseProcessor(Function<T, Mono<R>> responseProcessor) {
        Assert.notNull(responseProcessor, "Function must not be null");
        return (request, next) -> next.handle(request).flatMap(responseProcessor);
    }
}

